/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.ClassEncoding;
import eu.toolchain.scribe.DecoderFactory;
import eu.toolchain.scribe.DefaultEntityDecoder;
import eu.toolchain.scribe.DefaultEntityFieldMapping;
import eu.toolchain.scribe.EncoderFactory;
import eu.toolchain.scribe.EntityDecoder;
import eu.toolchain.scribe.EntityEncoder;
import eu.toolchain.scribe.EntityField;
import eu.toolchain.scribe.EntityFieldEncoder;
import eu.toolchain.scribe.EntityFieldMapping;
import eu.toolchain.scribe.EntityFieldStreamEncoder;
import eu.toolchain.scribe.EntityResolver;
import eu.toolchain.scribe.EntityStreamEncoder;
import eu.toolchain.scribe.FieldReader;
import eu.toolchain.scribe.Flags;
import eu.toolchain.scribe.InstanceBuilder;
import eu.toolchain.scribe.Mapping;
import eu.toolchain.scribe.ReadFieldsEntityEncoder;
import eu.toolchain.scribe.ReadFieldsEntityStreamEncoder;
import eu.toolchain.scribe.StreamEncoderFactory;
import eu.toolchain.scribe.detector.Match;
import eu.toolchain.scribe.detector.MatchPriority;
import eu.toolchain.scribe.reflection.Annotations;
import eu.toolchain.scribe.reflection.JavaType;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class MethodClassEncoding
implements ClassEncoding {
    private final List<DefaultEntityFieldMapping> fields;
    private final InstanceBuilder instanceBuilder;

    public <Target> EntityEncoder<Target, Object> newEntityEncoder(EntityResolver resolver, EncoderFactory<Target> factory) {
        ArrayList<ReadFieldsEntityEncoder.Field<Target, Object>> fields = new ArrayList<ReadFieldsEntityEncoder.Field<Target, Object>>();
        for (DefaultEntityFieldMapping field : this.fields) {
            EntityFieldEncoder<Target, Object> fieldEncoder = field.newEntityFieldEncoder(resolver, factory).orElseThrow(() -> new IllegalArgumentException("Unable to apply encoding for field (" + field + ")"));
            fields.add(new ReadFieldsEntityEncoder.Field<Target, Object>(fieldEncoder, field.getReader()));
        }
        return new ReadFieldsEntityEncoder<Target>(Collections.unmodifiableList(fields), factory);
    }

    public <Target> EntityStreamEncoder<Target, Object> newEntityStreamEncoder(EntityResolver resolver, StreamEncoderFactory<Target> factory) {
        ArrayList<ReadFieldsEntityStreamEncoder.ReadFieldsEntityField<Target, Object>> fields = new ArrayList<ReadFieldsEntityStreamEncoder.ReadFieldsEntityField<Target, Object>>();
        for (DefaultEntityFieldMapping field : this.fields) {
            EntityFieldStreamEncoder<Target, Object> encoder = field.newEntityFieldStreamEncoder(resolver, factory).orElseThrow(() -> new IllegalArgumentException("Unable to apply encoding for field (" + field + ")"));
            fields.add(new ReadFieldsEntityStreamEncoder.ReadFieldsEntityField<Target, Object>(encoder, field.getReader()));
        }
        return new ReadFieldsEntityStreamEncoder(Collections.unmodifiableList(fields), factory);
    }

    public <Target> EntityDecoder<Target, Object> newEntityDecoder(EntityResolver resolver, DecoderFactory<Target> factory) {
        ArrayList fields = new ArrayList();
        for (EntityFieldMapping entityFieldMapping : this.fields) {
            fields.add(entityFieldMapping.newEntityFieldDecoder(resolver, factory).orElseThrow(() -> new IllegalArgumentException("Unable to apply encoding for field (" + field + ")")));
        }
        return new DefaultEntityDecoder(Collections.unmodifiableList(fields), this.instanceBuilder, factory);
    }

    public static Stream<Match<ClassEncoding>> detect(EntityResolver resolver, JavaType type) {
        return resolver.detectInstanceBuilder(type).map(creator -> {
            ArrayList<DefaultEntityFieldMapping> fields = new ArrayList<DefaultEntityFieldMapping>();
            for (EntityField field : creator.getFields()) {
                String fieldName = field.getName().orElseGet(() -> creator.getFieldNames().map(names -> (String)names.get(field.getIndex())).orElseThrow(() -> new IllegalArgumentException("Cannot detect property name for field: " + field.toString())));
                FieldReader reader = (FieldReader)resolver.detectFieldReader(type, fieldName, field.getType()).orElseThrow(() -> new IllegalArgumentException("Can't figure out how to read " + type + " field (" + fieldName + ")"));
                Annotations base = field.getAnnotations().merge(reader.annotations());
                Annotations annotations = !field.isImmediate() ? base.merge(resolver.detectImmediateAnnotations(type, fieldName)) : base;
                Mapping m = resolver.mapping(reader.fieldType(), annotations);
                Flags flags = resolver.detectFieldFlags(reader.fieldType(), annotations);
                fields.add(new DefaultEntityFieldMapping(fieldName, m, reader, flags));
            }
            return Stream.of(new MethodClassEncoding(Collections.unmodifiableList(fields), (InstanceBuilder)creator));
        }).orElseGet(Stream::empty).map(Match.withPriority((MatchPriority)MatchPriority.HIGH));
    }

    @ConstructorProperties(value={"fields", "instanceBuilder"})
    public MethodClassEncoding(List<DefaultEntityFieldMapping> fields, InstanceBuilder instanceBuilder) {
        this.fields = fields;
        this.instanceBuilder = instanceBuilder;
    }

    public List<DefaultEntityFieldMapping> getFields() {
        return this.fields;
    }

    public InstanceBuilder getInstanceBuilder() {
        return this.instanceBuilder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodClassEncoding)) {
            return false;
        }
        MethodClassEncoding other = (MethodClassEncoding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<DefaultEntityFieldMapping> this$fields = this.getFields();
        List<DefaultEntityFieldMapping> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        InstanceBuilder this$instanceBuilder = this.getInstanceBuilder();
        InstanceBuilder other$instanceBuilder = other.getInstanceBuilder();
        return !(this$instanceBuilder == null ? other$instanceBuilder != null : !this$instanceBuilder.equals(other$instanceBuilder));
    }

    public boolean canEqual(Object other) {
        return other instanceof MethodClassEncoding;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<DefaultEntityFieldMapping> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 0 : ((Object)$fields).hashCode());
        InstanceBuilder $instanceBuilder = this.getInstanceBuilder();
        result = result * 59 + ($instanceBuilder == null ? 0 : $instanceBuilder.hashCode());
        return result;
    }

    public String toString() {
        return "MethodClassEncoding(fields=" + this.getFields() + ", instanceBuilder=" + this.getInstanceBuilder() + ")";
    }
}

