/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.CaseFormat;
import eu.toolchain.scribe.FieldReader;
import eu.toolchain.scribe.detector.Match;
import eu.toolchain.scribe.detector.MatchPriority;
import eu.toolchain.scribe.reflection.Annotations;
import eu.toolchain.scribe.reflection.JavaType;
import java.beans.ConstructorProperties;
import java.util.function.Function;
import java.util.stream.Stream;

public class GetterFieldReader
implements FieldReader {
    public static final Function<String, String> LOWER_TO_UPPER = CaseFormat::lowerCamelToUpperCamel;
    private final JavaType.Method getter;
    private final Annotations annotations;
    private final JavaType fieldType;

    public Object read(Object instance) {
        try {
            return this.getter.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Annotations annotations() {
        return this.annotations;
    }

    public JavaType fieldType() {
        return this.fieldType;
    }

    public static Stream<Match<FieldReader>> detect(JavaType type, String fieldName, JavaType fieldType) {
        String getterName = GetterFieldReader.getFieldName(fieldName, fieldType);
        return type.getMethod(getterName, new JavaType[0]).map(getter -> {
            JavaType returnType = getter.getReturnType();
            Annotations annotations = Annotations.of((Stream)getter.getAnnotationStream());
            if (!fieldType.equals((Object)returnType)) {
                throw new IllegalArgumentException("Getter " + getter + " return incompatible return value (" + returnType + "), expected (" + fieldType + ")");
            }
            return new GetterFieldReader((JavaType.Method)getter, annotations, returnType);
        }).map(Match.withPriority((MatchPriority)MatchPriority.LOW));
    }

    private static String getFieldName(String fieldName, JavaType fieldType) {
        if (fieldType.isBoolean() && !fieldType.isBoxed()) {
            return "is" + LOWER_TO_UPPER.apply(fieldName);
        }
        return "get" + LOWER_TO_UPPER.apply(fieldName);
    }

    @ConstructorProperties(value={"getter", "annotations", "fieldType"})
    public GetterFieldReader(JavaType.Method getter, Annotations annotations, JavaType fieldType) {
        this.getter = getter;
        this.annotations = annotations;
        this.fieldType = fieldType;
    }

    public JavaType.Method getGetter() {
        return this.getter;
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }

    public JavaType getFieldType() {
        return this.fieldType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetterFieldReader)) {
            return false;
        }
        GetterFieldReader other = (GetterFieldReader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JavaType.Method this$getter = this.getGetter();
        JavaType.Method other$getter = other.getGetter();
        if (this$getter == null ? other$getter != null : !this$getter.equals(other$getter)) {
            return false;
        }
        Annotations this$annotations = this.getAnnotations();
        Annotations other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !this$annotations.equals(other$annotations)) {
            return false;
        }
        JavaType this$fieldType = this.getFieldType();
        JavaType other$fieldType = other.getFieldType();
        return !(this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType));
    }

    public boolean canEqual(Object other) {
        return other instanceof GetterFieldReader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavaType.Method $getter = this.getGetter();
        result = result * 59 + ($getter == null ? 0 : $getter.hashCode());
        Annotations $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 0 : $annotations.hashCode());
        JavaType $fieldType = this.getFieldType();
        result = result * 59 + ($fieldType == null ? 0 : $fieldType.hashCode());
        return result;
    }

    public String toString() {
        return "GetterFieldReader(getter=" + this.getGetter() + ", annotations=" + this.getAnnotations() + ", fieldType=" + this.getFieldType() + ")";
    }
}

