/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.AbstractClassMapping;
import eu.toolchain.scribe.ClassEncoding;
import eu.toolchain.scribe.ClassMapping;
import eu.toolchain.scribe.ConcreteClassMapping;
import eu.toolchain.scribe.DecodeValue;
import eu.toolchain.scribe.Decoder;
import eu.toolchain.scribe.DecoderFactory;
import eu.toolchain.scribe.DefaultModule;
import eu.toolchain.scribe.EncodeValue;
import eu.toolchain.scribe.Encoder;
import eu.toolchain.scribe.EncoderFactory;
import eu.toolchain.scribe.EntityField;
import eu.toolchain.scribe.EntityMapperBuilder;
import eu.toolchain.scribe.EntityResolver;
import eu.toolchain.scribe.ExecutableType;
import eu.toolchain.scribe.FieldReader;
import eu.toolchain.scribe.Flags;
import eu.toolchain.scribe.InstanceBuilder;
import eu.toolchain.scribe.Mapping;
import eu.toolchain.scribe.Module;
import eu.toolchain.scribe.NativeAnnotationsModule;
import eu.toolchain.scribe.Option;
import eu.toolchain.scribe.StreamEncoder;
import eu.toolchain.scribe.StreamEncoderFactory;
import eu.toolchain.scribe.SubType;
import eu.toolchain.scribe.TypeAlias;
import eu.toolchain.scribe.TypeDecoderProvider;
import eu.toolchain.scribe.TypeEncoderProvider;
import eu.toolchain.scribe.TypeReference;
import eu.toolchain.scribe.TypeStreamEncoderProvider;
import eu.toolchain.scribe.ValueMapping;
import eu.toolchain.scribe.detector.ClassEncodingDetector;
import eu.toolchain.scribe.detector.DecodeValueDetector;
import eu.toolchain.scribe.detector.EncodeValueDetector;
import eu.toolchain.scribe.detector.FieldNameDetector;
import eu.toolchain.scribe.detector.FieldReaderDetector;
import eu.toolchain.scribe.detector.FlagDetector;
import eu.toolchain.scribe.detector.InstanceBuilderDetector;
import eu.toolchain.scribe.detector.MappingDetector;
import eu.toolchain.scribe.detector.Match;
import eu.toolchain.scribe.detector.SubTypesDetector;
import eu.toolchain.scribe.detector.TypeAliasDetector;
import eu.toolchain.scribe.detector.TypeNameDetector;
import eu.toolchain.scribe.reflection.Annotations;
import eu.toolchain.scribe.reflection.JavaType;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EntityMapper
implements EntityResolver {
    private final List<TypeAliasDetector> typeAliasDetectors;
    private final List<MappingDetector> mappingDetectors;
    private final List<FieldReaderDetector> fieldReaderDetectors;
    private final List<InstanceBuilderDetector> instanceBuilderDetectors;
    private final List<ClassEncodingDetector> classEncodingDetectors;
    private final List<SubTypesDetector> subTypesDetectors;
    private final List<EncodeValueDetector> encodeValueDetectors;
    private final List<DecodeValueDetector> decodeValueDetectors;
    private final List<FieldNameDetector> fieldNameDetectors;
    private final List<FlagDetector> flagDetectors;
    private final List<TypeNameDetector> typeNameDetectors;
    private final Map<Class<? extends Option>, Option> options;
    private final ConcurrentMap<EntityKey, Mapping> cache = new ConcurrentHashMap<EntityKey, Mapping>();
    private final Object resolverLock = new Object();

    public <Target> TypeStreamEncoderProvider<Target> streamEncoderFor(final StreamEncoderFactory<Target> factory) {
        return new TypeStreamEncoderProvider<Target>(){

            public StreamEncoder<Target, Object> newStreamEncoder(Type type) {
                return (StreamEncoder)EntityMapper.this.mapping(JavaType.of((Type)type)).newStreamEncoder((EntityResolver)EntityMapper.this, Flags.empty(), factory).orElseThrow(() -> new IllegalArgumentException("Unable to resolve encoding for type (" + type + ")"));
            }

            public <Source> StreamEncoder<Target, Source> newStreamEncoder(Class<Source> type) {
                return this.newStreamEncoder((Type)type);
            }

            public <Source> StreamEncoder<Target, Source> newStreamEncoder(TypeReference<Source> type) {
                return this.newStreamEncoder(type.getType());
            }
        };
    }

    public <Target> TypeEncoderProvider<Target> encoderFor(final EncoderFactory<Target> factory) {
        return new TypeEncoderProvider<Target>(){

            public Encoder<Target, Object> newEncoder(Type type) {
                return (Encoder)EntityMapper.this.mapping(JavaType.of((Type)type)).newEncoder((EntityResolver)EntityMapper.this, Flags.empty(), factory).orElseThrow(() -> new IllegalArgumentException("Unable to resolve encoding for type (" + type + ")"));
            }

            public <Source> Encoder<Target, Source> newEncoder(Class<Source> type) {
                return this.newEncoder((Type)type);
            }

            public <Source> Encoder<Target, Source> newEncoder(TypeReference<Source> type) {
                return this.newEncoder(type.getType());
            }
        };
    }

    public <Target> TypeDecoderProvider<Target> decoderFor(final DecoderFactory<Target> factory) {
        return new TypeDecoderProvider<Target>(){

            public Decoder<Target, Object> newDecoder(Type type) {
                return (Decoder)EntityMapper.this.mapping(JavaType.of((Type)type)).newDecoder((EntityResolver)EntityMapper.this, Flags.empty(), factory).orElseThrow(() -> new IllegalArgumentException("Unable to resolve encoding for type (" + type + ")"));
            }

            public <Source> Decoder<Target, Source> newDecoder(Class<Source> type) {
                return this.newDecoder((Type)type);
            }

            public <Source> Decoder<Target, Source> newDecoder(TypeReference<Source> type) {
                return this.newDecoder(type.getType());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mapping mapping(JavaType type, Annotations annotations) {
        EntityKey key = new EntityKey(type, annotations);
        Mapping mapping = (Mapping)this.cache.get(key);
        if (mapping != null) {
            return mapping;
        }
        Object object = this.resolverLock;
        synchronized (object) {
            Mapping candidate = (Mapping)this.cache.get(key);
            if (candidate != null) {
                return candidate;
            }
            Mapping newMapping = this.resolveAliasing(type, annotations);
            this.cache.put(key, newMapping);
            newMapping.initialize((EntityResolver)this);
            return newMapping;
        }
    }

    public Mapping mapping(JavaType type) {
        return this.mapping(type, Annotations.empty());
    }

    public Optional<InstanceBuilder> detectInstanceBuilder(JavaType type) {
        return Match.bestUniqueMatch(this.instanceBuilderDetectors.stream(), c -> c.detect((EntityResolver)this, type));
    }

    public Optional<FieldReader> detectFieldReader(JavaType type, String fieldName, JavaType fieldType) {
        return Match.bestUniqueMatch(this.fieldReaderDetectors.stream(), c -> c.detect(type, fieldName, fieldType));
    }

    public Optional<ClassEncoding> detectEntityMapping(JavaType type) {
        return Match.bestUniqueMatch(this.classEncodingDetectors.stream(), d -> d.detect((EntityResolver)this, type));
    }

    public List<SubType> resolveSubTypes(JavaType type) {
        return Match.bestUniqueMatch(this.subTypesDetectors.stream(), d -> d.detect((EntityResolver)this, type)).orElseGet(Collections::emptyList);
    }

    public Optional<EncodeValue> detectEncodeValue(JavaType type) {
        return Match.bestUniqueMatch(this.encodeValueDetectors.stream(), d -> d.detect((EntityResolver)this, type));
    }

    public Optional<DecodeValue> detectDecodeValue(JavaType type, JavaType fieldType) {
        return Match.bestUniqueMatch(this.decodeValueDetectors.stream(), d -> d.detect((EntityResolver)this, type, fieldType));
    }

    public Optional<String> detectFieldName(JavaType type, Annotations annotations) {
        return Match.bestUniqueMatch(this.fieldNameDetectors.stream(), d -> d.detect((EntityResolver)this, type, annotations));
    }

    public Optional<String> detectTypeName(JavaType type) {
        return Match.bestUniqueMatch(this.typeNameDetectors.stream(), d -> d.detect((EntityResolver)this, type));
    }

    public List<EntityField> detectExecutableFields(ExecutableType executable) {
        ArrayList<EntityField> fields = new ArrayList<EntityField>();
        int index = 0;
        for (JavaType.Parameter p : executable.getParameters()) {
            int i = index++;
            Annotations annotations = Annotations.of((Stream)p.getAnnotationStream());
            JavaType type = p.getParameterType();
            Optional<String> name = this.detectFieldName(type, annotations);
            fields.add(new EntityField(false, i, annotations, type, name));
        }
        return fields;
    }

    public Flags detectFieldFlags(JavaType type, Annotations annotations) {
        return Flags.copyOf((Collection)this.flagDetectors.stream().flatMap(d -> d.detect((EntityResolver)this, type, annotations)).collect(Collectors.toList()));
    }

    public <O extends Option> Optional<O> getOption(Class<O> option) {
        return Optional.ofNullable(this.options.get(option));
    }

    public <O extends Option> boolean isOptionPresent(O option) {
        return this.options.values().contains(option);
    }

    public EntityMapper withOptions(Option ... options) {
        if (options.length == 0) {
            return this;
        }
        Builder builder = this.toBuilder();
        Arrays.stream(options).forEach(builder::option);
        return builder.build();
    }

    public Annotations detectImmediateAnnotations(JavaType type, String fieldName) {
        return type.getField(fieldName).map(f -> Annotations.of((Stream)f.getAnnotationStream())).orElseGet(Annotations::empty);
    }

    private Mapping resolveAliasing(JavaType type, Annotations annotations) {
        List<TypeAlias> aliasing = this.resolveTypeAliases(type, annotations);
        if (aliasing.isEmpty()) {
            return this.resolveTypeMapping(type);
        }
        return this.applyTypeAliases(aliasing);
    }

    private Mapping applyTypeAliases(List<TypeAlias> aliasing) {
        TypeAlias lastAlias = aliasing.get(aliasing.size() - 1);
        ListIterator<TypeAlias> it = aliasing.listIterator(aliasing.size());
        Mapping lastMapping = this.resolveTypeMapping(lastAlias.getFromType());
        while (it.hasPrevious()) {
            lastMapping = it.previous().apply(lastMapping);
        }
        return lastMapping;
    }

    private Mapping resolveTypeMapping(JavaType sourceType) {
        return Match.bestUniqueMatch(this.mappingDetectors.stream(), m -> m.map((EntityResolver)this, sourceType)).orElseGet(() -> this.resolveBean(sourceType));
    }

    private List<TypeAlias> resolveTypeAliases(JavaType type, Annotations annotations) {
        ArrayList<TypeAlias> aliasing = new ArrayList<TypeAlias>();
        ArrayList<JavaType> seen = new ArrayList<JavaType>();
        seen.add(type);
        JavaType current = type;
        while (true) {
            JavaType t = current;
            Optional m = this.firstMatch(this.typeAliasDetectors.stream(), a -> a.detect(t, annotations));
            if (!m.isPresent()) break;
            TypeAlias alias = (TypeAlias)m.get();
            if (seen.contains(alias.getFromType())) {
                seen.add(alias.getToType());
                StringJoiner joiner = new StringJoiner(" -> ", "", "");
                seen.stream().map(Object::toString).forEach(joiner::add);
                throw new IllegalArgumentException("Cycle in aliasing detected: " + joiner.toString());
            }
            seen.add(alias.getFromType());
            aliasing.add(alias);
            current = alias.getFromType();
        }
        return aliasing;
    }

    private <Target, Source> Optional<Source> firstMatch(Stream<Target> alternatives, Function<Target, Stream<Source>> map) {
        List results = alternatives.flatMap(map).collect(Collectors.toList());
        if (results.size() > 1) {
            throw new IllegalArgumentException("Found multiple matches for type: " + results);
        }
        return results.stream().findFirst();
    }

    private Mapping resolveBean(JavaType type) {
        return this.resolveEncodeValue(type).orElseGet(() -> {
            Optional<String> typeName = this.detectTypeName(type);
            if (type.isAbstract()) {
                return this.doAbstract(type, typeName);
            }
            return this.doConcrete(type, typeName);
        });
    }

    private Optional<Mapping> resolveEncodeValue(JavaType type) {
        return this.detectEncodeValue(type).map(encodeValue -> {
            Mapping target = encodeValue.getTargetMapping();
            DecodeValue decodeValue = this.detectDecodeValue(type, target.getType()).orElseThrow(() -> new IllegalArgumentException("Value encoder (" + encodeValue + ") detected, but no corresponding decoder for type (" + type + ")"));
            return new ValueMapping((EncodeValue)encodeValue, decodeValue);
        });
    }

    private ClassMapping doAbstract(JavaType type, Optional<String> typeName) {
        List<SubType> subTypes = this.resolveSubTypes(type);
        return new AbstractClassMapping(type, typeName, subTypes, Optional.empty());
    }

    private ClassMapping doConcrete(JavaType type, Optional<String> typeName) {
        return new ConcreteClassMapping(type, typeName);
    }

    public Builder toBuilder() {
        return new Builder(new ArrayList<TypeAliasDetector>(this.typeAliasDetectors), new ArrayList<MappingDetector>(this.mappingDetectors), new ArrayList<FieldReaderDetector>(this.fieldReaderDetectors), new ArrayList<InstanceBuilderDetector>(this.instanceBuilderDetectors), new ArrayList<ClassEncodingDetector>(this.classEncodingDetectors), new ArrayList<SubTypesDetector>(this.subTypesDetectors), new ArrayList<EncodeValueDetector>(this.encodeValueDetectors), new ArrayList<DecodeValueDetector>(this.decodeValueDetectors), new ArrayList<FieldNameDetector>(this.fieldNameDetectors), new ArrayList<FlagDetector>(this.flagDetectors), new ArrayList<TypeNameDetector>(this.typeNameDetectors), new HashSet<Option>(this.options.values()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder defaultBuilder() {
        return EntityMapper.builder().install(new DefaultModule());
    }

    public static Builder nativeBuilder() {
        return EntityMapper.defaultBuilder().install(new NativeAnnotationsModule());
    }

    @ConstructorProperties(value={"typeAliasDetectors", "mappingDetectors", "fieldReaderDetectors", "instanceBuilderDetectors", "classEncodingDetectors", "subTypesDetectors", "encodeValueDetectors", "decodeValueDetectors", "fieldNameDetectors", "flagDetectors", "typeNameDetectors", "options"})
    public EntityMapper(List<TypeAliasDetector> typeAliasDetectors, List<MappingDetector> mappingDetectors, List<FieldReaderDetector> fieldReaderDetectors, List<InstanceBuilderDetector> instanceBuilderDetectors, List<ClassEncodingDetector> classEncodingDetectors, List<SubTypesDetector> subTypesDetectors, List<EncodeValueDetector> encodeValueDetectors, List<DecodeValueDetector> decodeValueDetectors, List<FieldNameDetector> fieldNameDetectors, List<FlagDetector> flagDetectors, List<TypeNameDetector> typeNameDetectors, Map<Class<? extends Option>, Option> options) {
        this.typeAliasDetectors = typeAliasDetectors;
        this.mappingDetectors = mappingDetectors;
        this.fieldReaderDetectors = fieldReaderDetectors;
        this.instanceBuilderDetectors = instanceBuilderDetectors;
        this.classEncodingDetectors = classEncodingDetectors;
        this.subTypesDetectors = subTypesDetectors;
        this.encodeValueDetectors = encodeValueDetectors;
        this.decodeValueDetectors = decodeValueDetectors;
        this.fieldNameDetectors = fieldNameDetectors;
        this.flagDetectors = flagDetectors;
        this.typeNameDetectors = typeNameDetectors;
        this.options = options;
    }

    public static class Builder
    implements EntityMapperBuilder {
        private final ArrayList<TypeAliasDetector> typeAliasDetectors;
        private final ArrayList<MappingDetector> mappingDetectors;
        private final ArrayList<FieldReaderDetector> fieldReaderDetectors;
        private final ArrayList<InstanceBuilderDetector> instanceBuilderDetectors;
        private final ArrayList<ClassEncodingDetector> classEncodingDetectors;
        private final ArrayList<SubTypesDetector> subTypesDetectors;
        private final ArrayList<EncodeValueDetector> encodeValueDetectors;
        private final ArrayList<DecodeValueDetector> decodeValueDetectors;
        private final ArrayList<FieldNameDetector> fieldNameDetectors;
        private final ArrayList<FlagDetector> flagDetectors;
        private final ArrayList<TypeNameDetector> typeNameDetectors;
        private final HashSet<Option> options;

        public Builder() {
            this.typeAliasDetectors = new ArrayList();
            this.mappingDetectors = new ArrayList();
            this.fieldReaderDetectors = new ArrayList();
            this.instanceBuilderDetectors = new ArrayList();
            this.classEncodingDetectors = new ArrayList();
            this.subTypesDetectors = new ArrayList();
            this.encodeValueDetectors = new ArrayList();
            this.decodeValueDetectors = new ArrayList();
            this.fieldNameDetectors = new ArrayList();
            this.flagDetectors = new ArrayList();
            this.typeNameDetectors = new ArrayList();
            this.options = new HashSet();
        }

        public Builder typeAlias(TypeAliasDetector detector) {
            this.typeAliasDetectors.add(detector);
            return this;
        }

        public Builder mapping(MappingDetector detector) {
            this.mappingDetectors.add(detector);
            return this;
        }

        public Builder fieldReader(FieldReaderDetector detector) {
            this.fieldReaderDetectors.add(detector);
            return this;
        }

        public Builder instanceBuilder(InstanceBuilderDetector detector) {
            this.instanceBuilderDetectors.add(detector);
            return this;
        }

        public Builder classEncoding(ClassEncodingDetector detector) {
            this.classEncodingDetectors.add(detector);
            return this;
        }

        public Builder subTypes(SubTypesDetector detector) {
            this.subTypesDetectors.add(detector);
            return this;
        }

        public Builder encodeValue(EncodeValueDetector detector) {
            this.encodeValueDetectors.add(detector);
            return this;
        }

        public Builder decodeValue(DecodeValueDetector detector) {
            this.decodeValueDetectors.add(detector);
            return this;
        }

        public Builder fieldName(FieldNameDetector detector) {
            this.fieldNameDetectors.add(detector);
            return this;
        }

        public Builder flag(FlagDetector detector) {
            this.flagDetectors.add(detector);
            return this;
        }

        public Builder typeName(TypeNameDetector detector) {
            this.typeNameDetectors.add(detector);
            return this;
        }

        public Builder option(Option option) {
            this.options.add(option);
            return this;
        }

        public Builder install(Module module) {
            module.register((EntityMapperBuilder)this);
            return this;
        }

        public EntityMapper build() {
            Map options = this.options.stream().collect(Collectors.toMap(Object::getClass, Function.identity()));
            return new EntityMapper(Collections.unmodifiableList(new ArrayList<TypeAliasDetector>(this.typeAliasDetectors)), Collections.unmodifiableList(new ArrayList<MappingDetector>(this.mappingDetectors)), Collections.unmodifiableList(new ArrayList<FieldReaderDetector>(this.fieldReaderDetectors)), Collections.unmodifiableList(new ArrayList<InstanceBuilderDetector>(this.instanceBuilderDetectors)), Collections.unmodifiableList(new ArrayList<ClassEncodingDetector>(this.classEncodingDetectors)), Collections.unmodifiableList(new ArrayList<SubTypesDetector>(this.subTypesDetectors)), Collections.unmodifiableList(new ArrayList<EncodeValueDetector>(this.encodeValueDetectors)), Collections.unmodifiableList(new ArrayList<DecodeValueDetector>(this.decodeValueDetectors)), Collections.unmodifiableList(new ArrayList<FieldNameDetector>(this.fieldNameDetectors)), Collections.unmodifiableList(new ArrayList<FlagDetector>(this.flagDetectors)), Collections.unmodifiableList(new ArrayList<TypeNameDetector>(this.typeNameDetectors)), Collections.unmodifiableMap(options));
        }

        @ConstructorProperties(value={"typeAliasDetectors", "mappingDetectors", "fieldReaderDetectors", "instanceBuilderDetectors", "classEncodingDetectors", "subTypesDetectors", "encodeValueDetectors", "decodeValueDetectors", "fieldNameDetectors", "flagDetectors", "typeNameDetectors", "options"})
        public Builder(ArrayList<TypeAliasDetector> typeAliasDetectors, ArrayList<MappingDetector> mappingDetectors, ArrayList<FieldReaderDetector> fieldReaderDetectors, ArrayList<InstanceBuilderDetector> instanceBuilderDetectors, ArrayList<ClassEncodingDetector> classEncodingDetectors, ArrayList<SubTypesDetector> subTypesDetectors, ArrayList<EncodeValueDetector> encodeValueDetectors, ArrayList<DecodeValueDetector> decodeValueDetectors, ArrayList<FieldNameDetector> fieldNameDetectors, ArrayList<FlagDetector> flagDetectors, ArrayList<TypeNameDetector> typeNameDetectors, HashSet<Option> options) {
            this.typeAliasDetectors = typeAliasDetectors;
            this.mappingDetectors = mappingDetectors;
            this.fieldReaderDetectors = fieldReaderDetectors;
            this.instanceBuilderDetectors = instanceBuilderDetectors;
            this.classEncodingDetectors = classEncodingDetectors;
            this.subTypesDetectors = subTypesDetectors;
            this.encodeValueDetectors = encodeValueDetectors;
            this.decodeValueDetectors = decodeValueDetectors;
            this.fieldNameDetectors = fieldNameDetectors;
            this.flagDetectors = flagDetectors;
            this.typeNameDetectors = typeNameDetectors;
            this.options = options;
        }
    }

    public static class EntityKey {
        private final JavaType type;
        private final Annotations annotations;

        @ConstructorProperties(value={"type", "annotations"})
        public EntityKey(JavaType type, Annotations annotations) {
            this.type = type;
            this.annotations = annotations;
        }

        public JavaType getType() {
            return this.type;
        }

        public Annotations getAnnotations() {
            return this.annotations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntityKey)) {
                return false;
            }
            EntityKey other = (EntityKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Annotations this$annotations = this.getAnnotations();
            Annotations other$annotations = other.getAnnotations();
            return !(this$annotations == null ? other$annotations != null : !this$annotations.equals(other$annotations));
        }

        public boolean canEqual(Object other) {
            return other instanceof EntityKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 0 : $type.hashCode());
            Annotations $annotations = this.getAnnotations();
            result = result * 59 + ($annotations == null ? 0 : $annotations.hashCode());
            return result;
        }

        public String toString() {
            return "EntityMapper.EntityKey(type=" + this.getType() + ", annotations=" + this.getAnnotations() + ")";
        }
    }
}

