/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.Context;
import eu.toolchain.scribe.StreamEncoder;
import eu.toolchain.scribe.reflection.JavaType;
import java.beans.ConstructorProperties;

class EntityEncodeValueStreamEncoder<Target, Source>
implements StreamEncoder<Target, Source> {
    private final JavaType.Method valueMethod;
    private final StreamEncoder<Target, Source> parent;

    public void streamEncode(Context path, Source instance, Target target) {
        Object value;
        try {
            value = this.valueMethod.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw path.error("failed to get value", (Throwable)e);
        }
        this.parent.streamEncode(path, value, target);
    }

    public void streamEncodeEmpty(Context path, Target target) {
        this.parent.streamEncodeEmpty(path, target);
    }

    @ConstructorProperties(value={"valueMethod", "parent"})
    public EntityEncodeValueStreamEncoder(JavaType.Method valueMethod, StreamEncoder<Target, Source> parent) {
        this.valueMethod = valueMethod;
        this.parent = parent;
    }

    public JavaType.Method getValueMethod() {
        return this.valueMethod;
    }

    public StreamEncoder<Target, Source> getParent() {
        return this.parent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityEncodeValueStreamEncoder)) {
            return false;
        }
        EntityEncodeValueStreamEncoder other = (EntityEncodeValueStreamEncoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JavaType.Method this$valueMethod = this.getValueMethod();
        JavaType.Method other$valueMethod = other.getValueMethod();
        if (this$valueMethod == null ? other$valueMethod != null : !this$valueMethod.equals(other$valueMethod)) {
            return false;
        }
        StreamEncoder<Target, Source> this$parent = this.getParent();
        StreamEncoder<Target, Source> other$parent = other.getParent();
        return !(this$parent == null ? other$parent != null : !this$parent.equals(other$parent));
    }

    public boolean canEqual(Object other) {
        return other instanceof EntityEncodeValueStreamEncoder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavaType.Method $valueMethod = this.getValueMethod();
        result = result * 59 + ($valueMethod == null ? 0 : $valueMethod.hashCode());
        StreamEncoder<Target, Source> $parent = this.getParent();
        result = result * 59 + ($parent == null ? 0 : $parent.hashCode());
        return result;
    }

    public String toString() {
        return "EntityEncodeValueStreamEncoder(valueMethod=" + this.getValueMethod() + ", parent=" + this.getParent() + ")";
    }
}

