/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.ConstructorEntityDecodeValueDecoder;
import eu.toolchain.scribe.DecodeValue;
import eu.toolchain.scribe.Decoder;
import eu.toolchain.scribe.DecoderFactory;
import eu.toolchain.scribe.EntityResolver;
import eu.toolchain.scribe.Flags;
import eu.toolchain.scribe.Mapping;
import eu.toolchain.scribe.detector.DecodeValueDetector;
import eu.toolchain.scribe.detector.Match;
import eu.toolchain.scribe.detector.MatchPriority;
import eu.toolchain.scribe.reflection.AccessibleType;
import eu.toolchain.scribe.reflection.JavaType;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConstructorEntityDecodeValue
implements DecodeValue {
    private final JavaType sourceType;
    private final Mapping targetMapping;
    private final JavaType.Constructor constructor;

    public <Target, Source> Optional<Decoder<Target, Source>> newDecoder(EntityResolver resolver, DecoderFactory<Target> factory) {
        return this.targetMapping.newDecoder(resolver, Flags.empty(), factory).map(parent -> new ConstructorEntityDecodeValueDecoder(this.constructor, parent));
    }

    public static DecodeValueDetector forAnnotation(Class<? extends Annotation> annotation) {
        return (resolver, sourceType, targetType) -> sourceType.findByAnnotation(JavaType::getConstructors, annotation).filter(AccessibleType::isPublic).filter(m -> m.getParameters().stream().map(JavaType.Parameter::getParameterType).collect(Collectors.toList()).equals(Collections.singletonList(targetType))).flatMap(c -> {
            Mapping targetMapping = resolver.mapping(targetType);
            return Stream.of(new ConstructorEntityDecodeValue(sourceType, targetMapping, (JavaType.Constructor)c));
        }).map(Match.withPriority((MatchPriority)MatchPriority.HIGH));
    }

    @ConstructorProperties(value={"sourceType", "targetMapping", "constructor"})
    public ConstructorEntityDecodeValue(JavaType sourceType, Mapping targetMapping, JavaType.Constructor constructor) {
        this.sourceType = sourceType;
        this.targetMapping = targetMapping;
        this.constructor = constructor;
    }

    public JavaType getSourceType() {
        return this.sourceType;
    }

    public Mapping getTargetMapping() {
        return this.targetMapping;
    }

    public JavaType.Constructor getConstructor() {
        return this.constructor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConstructorEntityDecodeValue)) {
            return false;
        }
        ConstructorEntityDecodeValue other = (ConstructorEntityDecodeValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JavaType this$sourceType = this.getSourceType();
        JavaType other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        Mapping this$targetMapping = this.getTargetMapping();
        Mapping other$targetMapping = other.getTargetMapping();
        if (this$targetMapping == null ? other$targetMapping != null : !this$targetMapping.equals(other$targetMapping)) {
            return false;
        }
        JavaType.Constructor this$constructor = this.getConstructor();
        JavaType.Constructor other$constructor = other.getConstructor();
        return !(this$constructor == null ? other$constructor != null : !this$constructor.equals(other$constructor));
    }

    public boolean canEqual(Object other) {
        return other instanceof ConstructorEntityDecodeValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavaType $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 0 : $sourceType.hashCode());
        Mapping $targetMapping = this.getTargetMapping();
        result = result * 59 + ($targetMapping == null ? 0 : $targetMapping.hashCode());
        JavaType.Constructor $constructor = this.getConstructor();
        result = result * 59 + ($constructor == null ? 0 : $constructor.hashCode());
        return result;
    }

    public String toString() {
        return "ConstructorEntityDecodeValue(sourceType=" + this.getSourceType() + ", targetMapping=" + this.getTargetMapping() + ", constructor=" + this.getConstructor() + ")";
    }
}

