/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.FieldReader;
import eu.toolchain.scribe.detector.FieldReaderDetector;
import eu.toolchain.scribe.detector.Match;
import eu.toolchain.scribe.detector.MatchPriority;
import eu.toolchain.scribe.reflection.Annotations;
import eu.toolchain.scribe.reflection.JavaType;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.function.Function;
import java.util.stream.Stream;

public class AnnotatedFieldReader
implements FieldReader {
    private final JavaType.Method getter;
    private final Annotations annotations;
    private final JavaType fieldType;

    public Object read(Object instance) {
        try {
            return this.getter.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Annotations annotations() {
        return this.annotations;
    }

    public JavaType fieldType() {
        return this.fieldType;
    }

    public static <T extends Annotation> FieldReaderDetector forAnnotation(Class<T> annotation, Function<T, String> annotationValue) {
        return (type, fieldName, knownType) -> type.findByAnnotation(JavaType::getMethods, annotation).filter(m -> ((String)annotationValue.apply(m.getAnnotation(annotation).findFirst().get())).equals(fieldName)).map(m -> {
            JavaType fieldType = m.getReturnType();
            if (!knownType.equals((Object)fieldType)) {
                throw new IllegalArgumentException("Getter " + m + " return incompatible return value (" + fieldType + "), expected (" + knownType + ")");
            }
            Annotations annotations = Annotations.of((Stream)m.getAnnotationStream());
            return new AnnotatedFieldReader((JavaType.Method)m, annotations, fieldType);
        }).map(Match.withPriority((MatchPriority)MatchPriority.HIGH));
    }

    @ConstructorProperties(value={"getter", "annotations", "fieldType"})
    public AnnotatedFieldReader(JavaType.Method getter, Annotations annotations, JavaType fieldType) {
        this.getter = getter;
        this.annotations = annotations;
        this.fieldType = fieldType;
    }

    public JavaType.Method getGetter() {
        return this.getter;
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }

    public JavaType getFieldType() {
        return this.fieldType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnnotatedFieldReader)) {
            return false;
        }
        AnnotatedFieldReader other = (AnnotatedFieldReader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JavaType.Method this$getter = this.getGetter();
        JavaType.Method other$getter = other.getGetter();
        if (this$getter == null ? other$getter != null : !this$getter.equals(other$getter)) {
            return false;
        }
        Annotations this$annotations = this.getAnnotations();
        Annotations other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !this$annotations.equals(other$annotations)) {
            return false;
        }
        JavaType this$fieldType = this.getFieldType();
        JavaType other$fieldType = other.getFieldType();
        return !(this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType));
    }

    public boolean canEqual(Object other) {
        return other instanceof AnnotatedFieldReader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavaType.Method $getter = this.getGetter();
        result = result * 59 + ($getter == null ? 0 : $getter.hashCode());
        Annotations $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 0 : $annotations.hashCode());
        JavaType $fieldType = this.getFieldType();
        result = result * 59 + ($fieldType == null ? 0 : $fieldType.hashCode());
        return result;
    }

    public String toString() {
        return "AnnotatedFieldReader(getter=" + this.getGetter() + ", annotations=" + this.getAnnotations() + ", fieldType=" + this.getFieldType() + ")";
    }
}

