/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.Context;
import eu.toolchain.scribe.EncoderFactory;
import eu.toolchain.scribe.EntityEncoder;
import eu.toolchain.scribe.EntityFieldEncoder;
import eu.toolchain.scribe.EntityFieldsEncoder;
import eu.toolchain.scribe.reflection.JavaType;
import java.beans.ConstructorProperties;
import java.util.Map;

public class AbstractEntityEncoder<Target>
implements EntityEncoder<Target, Object> {
    private final Map<JavaType, TypeEntry<Target>> byType;
    private final EncoderFactory<Target> factory;
    private final EntityFieldEncoder<Target, String> typeEncoder;

    public Target encode(EntityFieldsEncoder<Target> encoder, Context path, Object instance, Runnable callback) {
        TypeEntry<Target> sub = this.byType.get(JavaType.of(instance.getClass()));
        if (sub == null) {
            throw new RuntimeException("Could not resolve subtype for: " + instance);
        }
        return (Target)sub.getEncoder().encode(encoder, path, instance, () -> {
            callback.run();
            encoder.encodeField(this.typeEncoder, path.push(this.typeEncoder.getName()), (Object)sub.getType());
        });
    }

    public Target encode(Context path, Object instance) {
        return this.encode(this.factory.newEntityEncoder(), path, instance, EntityEncoder.EMPTY_CALLBACK);
    }

    public Target encodeEmpty(Context path) {
        return (Target)this.factory.newEntityEncoder().buildEmpty(path);
    }

    @ConstructorProperties(value={"byType", "factory", "typeEncoder"})
    public AbstractEntityEncoder(Map<JavaType, TypeEntry<Target>> byType, EncoderFactory<Target> factory, EntityFieldEncoder<Target, String> typeEncoder) {
        this.byType = byType;
        this.factory = factory;
        this.typeEncoder = typeEncoder;
    }

    public Map<JavaType, TypeEntry<Target>> getByType() {
        return this.byType;
    }

    public EncoderFactory<Target> getFactory() {
        return this.factory;
    }

    public EntityFieldEncoder<Target, String> getTypeEncoder() {
        return this.typeEncoder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractEntityEncoder)) {
            return false;
        }
        AbstractEntityEncoder other = (AbstractEntityEncoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<JavaType, TypeEntry<Target>> this$byType = this.getByType();
        Map<JavaType, TypeEntry<Target>> other$byType = other.getByType();
        if (this$byType == null ? other$byType != null : !((Object)this$byType).equals(other$byType)) {
            return false;
        }
        EncoderFactory<Target> this$factory = this.getFactory();
        EncoderFactory<Target> other$factory = other.getFactory();
        if (this$factory == null ? other$factory != null : !this$factory.equals(other$factory)) {
            return false;
        }
        EntityFieldEncoder<Target, String> this$typeEncoder = this.getTypeEncoder();
        EntityFieldEncoder<Target, String> other$typeEncoder = other.getTypeEncoder();
        return !(this$typeEncoder == null ? other$typeEncoder != null : !this$typeEncoder.equals(other$typeEncoder));
    }

    public boolean canEqual(Object other) {
        return other instanceof AbstractEntityEncoder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<JavaType, TypeEntry<Target>> $byType = this.getByType();
        result = result * 59 + ($byType == null ? 0 : ((Object)$byType).hashCode());
        EncoderFactory<Target> $factory = this.getFactory();
        result = result * 59 + ($factory == null ? 0 : $factory.hashCode());
        EntityFieldEncoder<Target, String> $typeEncoder = this.getTypeEncoder();
        result = result * 59 + ($typeEncoder == null ? 0 : $typeEncoder.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractEntityEncoder(byType=" + this.getByType() + ", factory=" + this.getFactory() + ", typeEncoder=" + this.getTypeEncoder() + ")";
    }

    public static class TypeEntry<Target> {
        final String type;
        final EntityEncoder<Target, Object> encoder;

        @ConstructorProperties(value={"type", "encoder"})
        public TypeEntry(String type, EntityEncoder<Target, Object> encoder) {
            this.type = type;
            this.encoder = encoder;
        }

        public String getType() {
            return this.type;
        }

        public EntityEncoder<Target, Object> getEncoder() {
            return this.encoder;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeEntry)) {
                return false;
            }
            TypeEntry other = (TypeEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            EntityEncoder<Target, Object> this$encoder = this.getEncoder();
            EntityEncoder<Target, Object> other$encoder = other.getEncoder();
            return !(this$encoder == null ? other$encoder != null : !this$encoder.equals(other$encoder));
        }

        public boolean canEqual(Object other) {
            return other instanceof TypeEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 0 : $type.hashCode());
            EntityEncoder<Target, Object> $encoder = this.getEncoder();
            result = result * 59 + ($encoder == null ? 0 : $encoder.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractEntityEncoder.TypeEntry(type=" + this.getType() + ", encoder=" + this.getEncoder() + ")";
        }
    }
}

