/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe.typemapping;

import eu.toolchain.scribe.Decoded;
import eu.toolchain.scribe.Decoder;
import eu.toolchain.scribe.DecoderFactory;
import eu.toolchain.scribe.EntityResolver;
import eu.toolchain.scribe.JavaType;
import eu.toolchain.scribe.Match;
import eu.toolchain.scribe.MatchPriority;
import eu.toolchain.scribe.entitymapper.DecodeValueDetector;
import eu.toolchain.scribe.typemapping.DecodeValue;
import eu.toolchain.scribe.typemapping.TypeMapping;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StaticMethodEntityDecodeValue
implements DecodeValue {
    private final JavaType entityType;
    private final TypeMapping target;
    private final JavaType.Method method;

    public <Target, Source> Optional<Decoder<Target, Source>> newDecoder(EntityResolver resolver, DecoderFactory<Target> factory) {
        return this.target.newDecoder(resolver, factory).map(parent -> (path, instance) -> {
            Decoded value = parent.decode(path, instance);
            try {
                return Decoded.of((Object)this.method.invoke(null, new Object[]{value}));
            }
            catch (Exception e) {
                throw path.error("failed to get value", (Throwable)e);
            }
        });
    }

    public static DecodeValueDetector forAnnotation(Class<? extends Annotation> annotation) {
        return (resolver, entityType, targetType) -> entityType.findByAnnotation(JavaType::getMethods, annotation).filter(m -> m.isPublic() && m.isStatic()).filter(m -> m.getParameters().stream().map(JavaType.Parameter::getParameterType).collect(Collectors.toList()).equals(Collections.singletonList(targetType))).flatMap(m -> {
            TypeMapping source = resolver.mapping(targetType);
            return Stream.of(new StaticMethodEntityDecodeValue(entityType, source, (JavaType.Method)m));
        }).map(Match.withPriority((MatchPriority)MatchPriority.HIGH));
    }

    @ConstructorProperties(value={"entityType", "target", "method"})
    public StaticMethodEntityDecodeValue(JavaType entityType, TypeMapping target, JavaType.Method method) {
        this.entityType = entityType;
        this.target = target;
        this.method = method;
    }

    public JavaType getEntityType() {
        return this.entityType;
    }

    public TypeMapping getTarget() {
        return this.target;
    }

    public JavaType.Method getMethod() {
        return this.method;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StaticMethodEntityDecodeValue)) {
            return false;
        }
        StaticMethodEntityDecodeValue other = (StaticMethodEntityDecodeValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JavaType this$entityType = this.getEntityType();
        JavaType other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        TypeMapping this$target = this.getTarget();
        TypeMapping other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        JavaType.Method this$method = this.getMethod();
        JavaType.Method other$method = other.getMethod();
        return !(this$method == null ? other$method != null : !this$method.equals(other$method));
    }

    public boolean canEqual(Object other) {
        return other instanceof StaticMethodEntityDecodeValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavaType $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 0 : $entityType.hashCode());
        TypeMapping $target = this.getTarget();
        result = result * 59 + ($target == null ? 0 : $target.hashCode());
        JavaType.Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 0 : $method.hashCode());
        return result;
    }

    public String toString() {
        return "StaticMethodEntityDecodeValue(entityType=" + this.getEntityType() + ", target=" + this.getTarget() + ", method=" + this.getMethod() + ")";
    }
}

