/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe.typemapping;

import eu.toolchain.scribe.DatabindOptions;
import eu.toolchain.scribe.Decoder;
import eu.toolchain.scribe.DecoderFactory;
import eu.toolchain.scribe.Encoder;
import eu.toolchain.scribe.EncoderFactory;
import eu.toolchain.scribe.EntityDecoder;
import eu.toolchain.scribe.EntityEncoder;
import eu.toolchain.scribe.EntityResolver;
import eu.toolchain.scribe.EntityStreamEncoder;
import eu.toolchain.scribe.JavaType;
import eu.toolchain.scribe.StreamEncoder;
import eu.toolchain.scribe.StreamEncoderFactory;
import eu.toolchain.scribe.entitymapper.SubType;
import eu.toolchain.scribe.typemapping.AbstractEntityDecoder;
import eu.toolchain.scribe.typemapping.AbstractEntityEncoder;
import eu.toolchain.scribe.typemapping.AbstractEntityStreamEncoder;
import eu.toolchain.scribe.typemapping.EntityTypeMapping;
import eu.toolchain.scribe.typemapping.TypeEntityFieldDecoder;
import eu.toolchain.scribe.typemapping.TypeEntityFieldEncoder;
import eu.toolchain.scribe.typemapping.TypeEntityFieldStreamEncoder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class PropertyAbstractEntityTypeMapping
implements EntityTypeMapping {
    public static final JavaType STRING = JavaType.of(String.class);
    public static final String DEFAULT_TYPE_FIELD = "type";
    private final JavaType type;
    private final Optional<String> typeName;
    private final List<SubType> subTypes;
    private final Optional<String> typeField;

    public Optional<String> typeName() {
        return this.typeName;
    }

    public <Target> EntityEncoder<Target, Object> newEntityTypeEncoder(EntityResolver resolver, EncoderFactory<Target> factory) {
        HashMap byType = new HashMap();
        for (SubType subType : this.subTypes) {
            EntityTypeMapping m = subType.getMapping();
            EntityEncoder encoding = m.newEntityTypeEncoder(resolver, factory);
            String typeName = this.getTypeName(subType, m);
            byType.put(m.getType(), new AbstractEntityEncoder.EntityEncoderEntry(typeName, encoding));
        }
        String fieldName = this.getTypeFieldName(resolver);
        Encoder encoder = (Encoder)factory.newEncoder(resolver, STRING).findFirst().orElseThrow(() -> new IllegalStateException("Could not find an encoder for the type field"));
        return new AbstractEntityEncoder(byType, factory, new TypeEntityFieldEncoder(fieldName, encoder));
    }

    public <Target> EntityStreamEncoder<Target, Object> newEntityTypeStreamEncoder(EntityResolver resolver, StreamEncoderFactory<Target> factory) {
        HashMap byType = new HashMap();
        for (SubType subType : this.subTypes) {
            EntityTypeMapping m = subType.getMapping();
            EntityStreamEncoder encoder = m.newEntityTypeStreamEncoder(resolver, factory);
            String typeName = this.getTypeName(subType, m);
            byType.put(m.getType(), new AbstractEntityStreamEncoder.EntityEncoderEntry(typeName, encoder));
        }
        String fieldName = this.getTypeFieldName(resolver);
        StreamEncoder encoder = (StreamEncoder)factory.newStreamEncoder(resolver, STRING).findFirst().orElseThrow(() -> new IllegalStateException("Could not find an encoder for the type field"));
        return new AbstractEntityStreamEncoder(byType, factory, new TypeEntityFieldStreamEncoder(fieldName, encoder));
    }

    public <Target> EntityDecoder<Target, Object> newEntityTypeDecoder(EntityResolver resolver, DecoderFactory<Target> factory) {
        HashMap byName = new HashMap();
        for (SubType subType : this.subTypes) {
            EntityTypeMapping m = subType.getMapping();
            EntityDecoder encoding = m.newEntityTypeDecoder(resolver, factory);
            String typeName = this.getTypeName(subType, m);
            byName.put(typeName, encoding);
        }
        String fieldName = this.getTypeFieldName(resolver);
        Decoder encoder = (Decoder)factory.newDecoder(resolver, STRING).findFirst().orElseThrow(() -> new IllegalStateException("Could not find an encoder for the type field"));
        return new AbstractEntityDecoder(byName, factory, new TypeEntityFieldDecoder(fieldName, encoder));
    }

    private String getTypeFieldName(EntityResolver resolver) {
        return this.typeField.orElseGet(() -> resolver.getOption(DatabindOptions.TypeFieldName.class).map(DatabindOptions.TypeFieldName::getName).orElse(DEFAULT_TYPE_FIELD));
    }

    private String getTypeName(SubType subType, EntityTypeMapping m) {
        return subType.getName().orElseGet(() -> (String)m.typeName().orElseThrow(() -> new IllegalStateException("No type name available for sub-type (" + subType + ")")));
    }

    @ConstructorProperties(value={"type", "typeName", "subTypes", "typeField"})
    public PropertyAbstractEntityTypeMapping(JavaType type, Optional<String> typeName, List<SubType> subTypes, Optional<String> typeField) {
        this.type = type;
        this.typeName = typeName;
        this.subTypes = subTypes;
        this.typeField = typeField;
    }

    public JavaType getType() {
        return this.type;
    }

    public Optional<String> getTypeName() {
        return this.typeName;
    }

    public List<SubType> getSubTypes() {
        return this.subTypes;
    }

    public Optional<String> getTypeField() {
        return this.typeField;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyAbstractEntityTypeMapping)) {
            return false;
        }
        PropertyAbstractEntityTypeMapping other = (PropertyAbstractEntityTypeMapping)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JavaType this$type = this.getType();
        JavaType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Optional<String> this$typeName = this.getTypeName();
        Optional<String> other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !((Object)this$typeName).equals(other$typeName)) {
            return false;
        }
        List<SubType> this$subTypes = this.getSubTypes();
        List<SubType> other$subTypes = other.getSubTypes();
        if (this$subTypes == null ? other$subTypes != null : !((Object)this$subTypes).equals(other$subTypes)) {
            return false;
        }
        Optional<String> this$typeField = this.getTypeField();
        Optional<String> other$typeField = other.getTypeField();
        return !(this$typeField == null ? other$typeField != null : !((Object)this$typeField).equals(other$typeField));
    }

    public boolean canEqual(Object other) {
        return other instanceof PropertyAbstractEntityTypeMapping;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavaType $type = this.getType();
        result = result * 59 + ($type == null ? 0 : $type.hashCode());
        Optional<String> $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 0 : ((Object)$typeName).hashCode());
        List<SubType> $subTypes = this.getSubTypes();
        result = result * 59 + ($subTypes == null ? 0 : ((Object)$subTypes).hashCode());
        Optional<String> $typeField = this.getTypeField();
        result = result * 59 + ($typeField == null ? 0 : ((Object)$typeField).hashCode());
        return result;
    }

    public String toString() {
        return "PropertyAbstractEntityTypeMapping(type=" + this.getType() + ", typeName=" + this.getTypeName() + ", subTypes=" + this.getSubTypes() + ", typeField=" + this.getTypeField() + ")";
    }
}

