/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe.typemapping;

import eu.toolchain.scribe.Context;
import eu.toolchain.scribe.Encoder;
import eu.toolchain.scribe.EncoderFactory;
import eu.toolchain.scribe.EntityResolver;
import eu.toolchain.scribe.JavaType;
import eu.toolchain.scribe.Match;
import eu.toolchain.scribe.MatchPriority;
import eu.toolchain.scribe.StreamEncoder;
import eu.toolchain.scribe.StreamEncoderFactory;
import eu.toolchain.scribe.entitymapper.EncodeValueDetector;
import eu.toolchain.scribe.typemapping.EncodeValue;
import eu.toolchain.scribe.typemapping.TypeMapping;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.stream.Stream;

public class EntityEncodeValue
implements EncodeValue {
    private final JavaType entityType;
    private final TypeMapping targetMapping;
    private final JavaType.Method valueMethod;

    public <Target, Source> Optional<Encoder<Target, Source>> newEncoder(EntityResolver resolver, EncoderFactory<Target> factory) {
        return this.targetMapping.newEncoder(resolver, factory).map(parent -> new Encoder<Target, Source>((Encoder)parent){
            final /* synthetic */ Encoder val$parent;
            {
                this.val$parent = encoder;
            }

            public Target encode(Context path, Source instance) {
                Object value;
                try {
                    value = EntityEncodeValue.this.valueMethod.invoke(instance, new Object[0]);
                }
                catch (Exception e) {
                    throw path.error("failed to get value", (Throwable)e);
                }
                return this.val$parent.encode(path, value);
            }

            public Target encodeEmpty(Context path) {
                return this.val$parent.encodeEmpty(path);
            }
        });
    }

    public <Target, Source> Optional<StreamEncoder<Target, Source>> newStreamEncoder(EntityResolver resolver, StreamEncoderFactory<Target> factory) {
        return this.targetMapping.newStreamEncoder(resolver, factory).map(parent -> new StreamEncoder<Target, Source>((StreamEncoder)parent){
            final /* synthetic */ StreamEncoder val$parent;
            {
                this.val$parent = streamEncoder;
            }

            public void streamEncode(Context path, Source instance, Target target) {
                Object value;
                try {
                    value = EntityEncodeValue.this.valueMethod.invoke(instance, new Object[0]);
                }
                catch (Exception e) {
                    throw path.error("failed to get value", (Throwable)e);
                }
                this.val$parent.streamEncode(path, value, target);
            }

            public void streamEncodeEmpty(Context path, Target target) {
                this.val$parent.streamEncodeEmpty(path, target);
            }
        });
    }

    public static EncodeValueDetector forAnnotation(Class<? extends Annotation> annotation) {
        return (resolver, sourceType) -> sourceType.findByAnnotation(JavaType::getMethods, annotation).filter(m -> m.isPublic() && !m.isStatic()).flatMap(m -> {
            if (m.getParameters().size() != 0) {
                throw new IllegalArgumentException(String.format("@%s method must have no parameters: %s", annotation.getSimpleName(), m));
            }
            TypeMapping targetType = resolver.mapping(m.getReturnType());
            return Stream.of(new EntityEncodeValue(sourceType, targetType, (JavaType.Method)m));
        }).map(Match.withPriority((MatchPriority)MatchPriority.HIGH));
    }

    @ConstructorProperties(value={"entityType", "targetMapping", "valueMethod"})
    public EntityEncodeValue(JavaType entityType, TypeMapping targetMapping, JavaType.Method valueMethod) {
        this.entityType = entityType;
        this.targetMapping = targetMapping;
        this.valueMethod = valueMethod;
    }

    public JavaType getEntityType() {
        return this.entityType;
    }

    public TypeMapping getTargetMapping() {
        return this.targetMapping;
    }

    public JavaType.Method getValueMethod() {
        return this.valueMethod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityEncodeValue)) {
            return false;
        }
        EntityEncodeValue other = (EntityEncodeValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JavaType this$entityType = this.getEntityType();
        JavaType other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        TypeMapping this$targetMapping = this.getTargetMapping();
        TypeMapping other$targetMapping = other.getTargetMapping();
        if (this$targetMapping == null ? other$targetMapping != null : !this$targetMapping.equals(other$targetMapping)) {
            return false;
        }
        JavaType.Method this$valueMethod = this.getValueMethod();
        JavaType.Method other$valueMethod = other.getValueMethod();
        return !(this$valueMethod == null ? other$valueMethod != null : !this$valueMethod.equals(other$valueMethod));
    }

    public boolean canEqual(Object other) {
        return other instanceof EntityEncodeValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavaType $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 0 : $entityType.hashCode());
        TypeMapping $targetMapping = this.getTargetMapping();
        result = result * 59 + ($targetMapping == null ? 0 : $targetMapping.hashCode());
        JavaType.Method $valueMethod = this.getValueMethod();
        result = result * 59 + ($valueMethod == null ? 0 : $valueMethod.hashCode());
        return result;
    }

    public String toString() {
        return "EntityEncodeValue(entityType=" + this.getEntityType() + ", targetMapping=" + this.getTargetMapping() + ", valueMethod=" + this.getValueMethod() + ")";
    }
}

