/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe.typemapping;

import eu.toolchain.scribe.AccessibleType;
import eu.toolchain.scribe.Decoder;
import eu.toolchain.scribe.DecoderFactory;
import eu.toolchain.scribe.EntityResolver;
import eu.toolchain.scribe.JavaType;
import eu.toolchain.scribe.Match;
import eu.toolchain.scribe.MatchPriority;
import eu.toolchain.scribe.entitymapper.DecodeValueDetector;
import eu.toolchain.scribe.typemapping.DecodeValue;
import eu.toolchain.scribe.typemapping.TypeMapping;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConstructorEntityDecodeValue
implements DecodeValue {
    private final JavaType entityType;
    private final TypeMapping source;
    private final JavaType.Constructor constructor;

    public <Target, Source> Optional<Decoder<Target, Source>> newDecoder(EntityResolver resolver, DecoderFactory<Target> factory) {
        return this.source.newDecoder(resolver, factory).map(parent -> (path, instance) -> parent.decode(path, instance).map(value -> {
            try {
                return this.constructor.newInstance(new Object[]{value});
            }
            catch (Exception e) {
                throw path.error("failed to get value", (Throwable)e);
            }
        }));
    }

    public static DecodeValueDetector forAnnotation(Class<? extends Annotation> annotation) {
        return (resolver, entityType, targetType) -> entityType.findByAnnotation(JavaType::getConstructors, annotation).filter(AccessibleType::isPublic).filter(m -> m.getParameters().stream().map(JavaType.Parameter::getParameterType).collect(Collectors.toList()).equals(Collections.singletonList(targetType))).flatMap(c -> {
            TypeMapping source = resolver.mapping(targetType);
            return Stream.of(new ConstructorEntityDecodeValue(entityType, source, (JavaType.Constructor)c));
        }).map(Match.withPriority((MatchPriority)MatchPriority.HIGH));
    }

    @ConstructorProperties(value={"entityType", "source", "constructor"})
    public ConstructorEntityDecodeValue(JavaType entityType, TypeMapping source, JavaType.Constructor constructor) {
        this.entityType = entityType;
        this.source = source;
        this.constructor = constructor;
    }

    public JavaType getEntityType() {
        return this.entityType;
    }

    public TypeMapping getSource() {
        return this.source;
    }

    public JavaType.Constructor getConstructor() {
        return this.constructor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConstructorEntityDecodeValue)) {
            return false;
        }
        ConstructorEntityDecodeValue other = (ConstructorEntityDecodeValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JavaType this$entityType = this.getEntityType();
        JavaType other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        TypeMapping this$source = this.getSource();
        TypeMapping other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        JavaType.Constructor this$constructor = this.getConstructor();
        JavaType.Constructor other$constructor = other.getConstructor();
        return !(this$constructor == null ? other$constructor != null : !this$constructor.equals(other$constructor));
    }

    public boolean canEqual(Object other) {
        return other instanceof ConstructorEntityDecodeValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavaType $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 0 : $entityType.hashCode());
        TypeMapping $source = this.getSource();
        result = result * 59 + ($source == null ? 0 : $source.hashCode());
        JavaType.Constructor $constructor = this.getConstructor();
        result = result * 59 + ($constructor == null ? 0 : $constructor.hashCode());
        return result;
    }

    public String toString() {
        return "ConstructorEntityDecodeValue(entityType=" + this.getEntityType() + ", source=" + this.getSource() + ", constructor=" + this.getConstructor() + ")";
    }
}

