/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe.typemapping;

import eu.toolchain.scribe.Context;
import eu.toolchain.scribe.EntityFieldsStreamEncoder;
import eu.toolchain.scribe.EntityStreamEncoder;
import eu.toolchain.scribe.JavaType;
import eu.toolchain.scribe.StreamEncoderFactory;
import eu.toolchain.scribe.entitymapping.EntityFieldStreamEncoder;
import java.beans.ConstructorProperties;
import java.util.Map;

public class AbstractEntityStreamEncoder<Target>
implements EntityStreamEncoder<Target, Object> {
    private final Map<JavaType, EntityEncoderEntry<Target>> byType;
    private final StreamEncoderFactory<Target> factory;
    private final EntityFieldStreamEncoder<Target, String> typeEncoder;

    public void streamEncode(EntityFieldsStreamEncoder<Target> encoder, Context path, Object instance, Target target, Runnable callback) {
        EntityEncoderEntry<Target> sub = this.byType.get(JavaType.of(instance.getClass()));
        if (sub == null) {
            throw path.error("Could not resolve subtype for instance (" + instance + ")");
        }
        sub.getEncoder().streamEncode(encoder, path, instance, target, () -> {
            callback.run();
            encoder.encodeField(this.typeEncoder, path.push(this.typeEncoder.getName()), (Object)sub.getType(), target);
        });
    }

    public void streamEncode(Context path, Object instance, Target target) {
        this.streamEncode(this.factory.newEntityStreamEncoder(), path, instance, target, EntityStreamEncoder.EMPTY_CALLBACK);
    }

    public void streamEncodeEmpty(Context path, Target target) {
        this.factory.newEntityStreamEncoder().encodeEmpty(path, target);
    }

    @ConstructorProperties(value={"byType", "factory", "typeEncoder"})
    public AbstractEntityStreamEncoder(Map<JavaType, EntityEncoderEntry<Target>> byType, StreamEncoderFactory<Target> factory, EntityFieldStreamEncoder<Target, String> typeEncoder) {
        this.byType = byType;
        this.factory = factory;
        this.typeEncoder = typeEncoder;
    }

    public Map<JavaType, EntityEncoderEntry<Target>> getByType() {
        return this.byType;
    }

    public StreamEncoderFactory<Target> getFactory() {
        return this.factory;
    }

    public EntityFieldStreamEncoder<Target, String> getTypeEncoder() {
        return this.typeEncoder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractEntityStreamEncoder)) {
            return false;
        }
        AbstractEntityStreamEncoder other = (AbstractEntityStreamEncoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<JavaType, EntityEncoderEntry<Target>> this$byType = this.getByType();
        Map<JavaType, EntityEncoderEntry<Target>> other$byType = other.getByType();
        if (this$byType == null ? other$byType != null : !((Object)this$byType).equals(other$byType)) {
            return false;
        }
        StreamEncoderFactory<Target> this$factory = this.getFactory();
        StreamEncoderFactory<Target> other$factory = other.getFactory();
        if (this$factory == null ? other$factory != null : !this$factory.equals(other$factory)) {
            return false;
        }
        EntityFieldStreamEncoder<Target, String> this$typeEncoder = this.getTypeEncoder();
        EntityFieldStreamEncoder<Target, String> other$typeEncoder = other.getTypeEncoder();
        return !(this$typeEncoder == null ? other$typeEncoder != null : !this$typeEncoder.equals(other$typeEncoder));
    }

    public boolean canEqual(Object other) {
        return other instanceof AbstractEntityStreamEncoder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<JavaType, EntityEncoderEntry<Target>> $byType = this.getByType();
        result = result * 59 + ($byType == null ? 0 : ((Object)$byType).hashCode());
        StreamEncoderFactory<Target> $factory = this.getFactory();
        result = result * 59 + ($factory == null ? 0 : $factory.hashCode());
        EntityFieldStreamEncoder<Target, String> $typeEncoder = this.getTypeEncoder();
        result = result * 59 + ($typeEncoder == null ? 0 : $typeEncoder.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractEntityStreamEncoder(byType=" + this.getByType() + ", factory=" + this.getFactory() + ", typeEncoder=" + this.getTypeEncoder() + ")";
    }

    public static class EntityEncoderEntry<Target> {
        final String type;
        final EntityStreamEncoder<Target, Object> encoder;

        @ConstructorProperties(value={"type", "encoder"})
        public EntityEncoderEntry(String type, EntityStreamEncoder<Target, Object> encoder) {
            this.type = type;
            this.encoder = encoder;
        }

        public String getType() {
            return this.type;
        }

        public EntityStreamEncoder<Target, Object> getEncoder() {
            return this.encoder;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntityEncoderEntry)) {
                return false;
            }
            EntityEncoderEntry other = (EntityEncoderEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            EntityStreamEncoder<Target, Object> this$encoder = this.getEncoder();
            EntityStreamEncoder<Target, Object> other$encoder = other.getEncoder();
            return !(this$encoder == null ? other$encoder != null : !this$encoder.equals(other$encoder));
        }

        public boolean canEqual(Object other) {
            return other instanceof EntityEncoderEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 0 : $type.hashCode());
            EntityStreamEncoder<Target, Object> $encoder = this.getEncoder();
            result = result * 59 + ($encoder == null ? 0 : $encoder.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractEntityStreamEncoder.EntityEncoderEntry(type=" + this.getType() + ", encoder=" + this.getEncoder() + ")";
        }
    }
}

