/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe.typemapping;

import eu.toolchain.scribe.Context;
import eu.toolchain.scribe.Decoded;
import eu.toolchain.scribe.DecoderFactory;
import eu.toolchain.scribe.EntityDecoder;
import eu.toolchain.scribe.EntityFieldsDecoder;
import eu.toolchain.scribe.typemapping.TypeEntityFieldDecoder;
import java.beans.ConstructorProperties;
import java.util.Map;

public class AbstractEntityDecoder<Target>
implements EntityDecoder<Target, Object> {
    final Map<String, EntityDecoder<Target, Object>> byName;
    final DecoderFactory<Target> factory;
    final TypeEntityFieldDecoder<Target> typeDecoder;

    public Decoded<Object> decode(EntityFieldsDecoder<Target> decoder, Context path) {
        String type = (String)decoder.decodeField(this.typeDecoder, path.push(this.typeDecoder.getName())).orElseThrow(() -> new RuntimeException("No type information available"));
        EntityDecoder<Target, Object> sub = this.byName.get(type);
        if (sub == null) {
            throw new RuntimeException("Sub-type (" + type + ") required, but no such type available");
        }
        return sub.decode(decoder, path);
    }

    public Decoded<Object> decode(Context path, Target instance) {
        return this.factory.newEntityDecoder(instance).flatMap(d -> this.decode((EntityFieldsDecoder<Target>)d, path));
    }

    @ConstructorProperties(value={"byName", "factory", "typeDecoder"})
    public AbstractEntityDecoder(Map<String, EntityDecoder<Target, Object>> byName, DecoderFactory<Target> factory, TypeEntityFieldDecoder<Target> typeDecoder) {
        this.byName = byName;
        this.factory = factory;
        this.typeDecoder = typeDecoder;
    }

    public Map<String, EntityDecoder<Target, Object>> getByName() {
        return this.byName;
    }

    public DecoderFactory<Target> getFactory() {
        return this.factory;
    }

    public TypeEntityFieldDecoder<Target> getTypeDecoder() {
        return this.typeDecoder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractEntityDecoder)) {
            return false;
        }
        AbstractEntityDecoder other = (AbstractEntityDecoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, EntityDecoder<Target, Object>> this$byName = this.getByName();
        Map<String, EntityDecoder<Target, Object>> other$byName = other.getByName();
        if (this$byName == null ? other$byName != null : !((Object)this$byName).equals(other$byName)) {
            return false;
        }
        DecoderFactory<Target> this$factory = this.getFactory();
        DecoderFactory<Target> other$factory = other.getFactory();
        if (this$factory == null ? other$factory != null : !this$factory.equals(other$factory)) {
            return false;
        }
        TypeEntityFieldDecoder<Target> this$typeDecoder = this.getTypeDecoder();
        TypeEntityFieldDecoder<Target> other$typeDecoder = other.getTypeDecoder();
        return !(this$typeDecoder == null ? other$typeDecoder != null : !((Object)this$typeDecoder).equals(other$typeDecoder));
    }

    public boolean canEqual(Object other) {
        return other instanceof AbstractEntityDecoder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, EntityDecoder<Target, Object>> $byName = this.getByName();
        result = result * 59 + ($byName == null ? 0 : ((Object)$byName).hashCode());
        DecoderFactory<Target> $factory = this.getFactory();
        result = result * 59 + ($factory == null ? 0 : $factory.hashCode());
        TypeEntityFieldDecoder<Target> $typeDecoder = this.getTypeDecoder();
        result = result * 59 + ($typeDecoder == null ? 0 : ((Object)$typeDecoder).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractEntityDecoder(byName=" + this.getByName() + ", factory=" + this.getFactory() + ", typeDecoder=" + this.getTypeDecoder() + ")";
    }
}

