/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe.entitymapping;

import eu.toolchain.scribe.Annotations;
import eu.toolchain.scribe.DecoderFactory;
import eu.toolchain.scribe.EncoderFactory;
import eu.toolchain.scribe.EntityDecoder;
import eu.toolchain.scribe.EntityEncoder;
import eu.toolchain.scribe.EntityField;
import eu.toolchain.scribe.EntityResolver;
import eu.toolchain.scribe.EntityStreamEncoder;
import eu.toolchain.scribe.JavaType;
import eu.toolchain.scribe.Match;
import eu.toolchain.scribe.MatchPriority;
import eu.toolchain.scribe.StreamEncoderFactory;
import eu.toolchain.scribe.creatormethod.InstanceBuilder;
import eu.toolchain.scribe.entitymapping.DefaultEntityDecoder;
import eu.toolchain.scribe.entitymapping.DefaultEntityFieldMapping;
import eu.toolchain.scribe.entitymapping.EntityFieldEncoder;
import eu.toolchain.scribe.entitymapping.EntityFieldMapping;
import eu.toolchain.scribe.entitymapping.EntityFieldStreamEncoder;
import eu.toolchain.scribe.entitymapping.EntityMapping;
import eu.toolchain.scribe.entitymapping.ReadFieldsEntityEncoder;
import eu.toolchain.scribe.entitymapping.ReadFieldsEntityStreamEncoder;
import eu.toolchain.scribe.fieldreader.FieldReader;
import eu.toolchain.scribe.typemapping.TypeMapping;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class DefaultEntityMapping
implements EntityMapping {
    private final List<DefaultEntityFieldMapping> fields;
    private final InstanceBuilder instanceBuilder;

    public List<? extends EntityFieldMapping> fields() {
        return this.fields;
    }

    public <Target> EntityEncoder<Target, Object> newEntityTypeEncoder(EntityResolver resolver, EncoderFactory<Target> factory) {
        ArrayList<ReadFieldsEntityEncoder.ReadFieldsEntityField> fields = new ArrayList<ReadFieldsEntityEncoder.ReadFieldsEntityField>();
        for (DefaultEntityFieldMapping field : this.fields) {
            EntityFieldEncoder<Target, Object> fieldEncoder = field.newEntityFieldEncoder(resolver, factory).orElseThrow(() -> new IllegalArgumentException("Unable to apply encoding for field (" + field + ")"));
            fields.add(new ReadFieldsEntityEncoder.ReadFieldsEntityField(fieldEncoder, field.getReader()));
        }
        return new ReadFieldsEntityEncoder(Collections.unmodifiableList(fields), factory);
    }

    public <Target> EntityStreamEncoder<Target, Object> newEntityTypeStreamEncoder(EntityResolver resolver, StreamEncoderFactory<Target> factory) {
        ArrayList<ReadFieldsEntityStreamEncoder.ReadFieldsEntityField> fields = new ArrayList<ReadFieldsEntityStreamEncoder.ReadFieldsEntityField>();
        for (DefaultEntityFieldMapping field : this.fields) {
            EntityFieldStreamEncoder<Target, Object> encoder = field.newEntityFieldStreamEncoder(resolver, factory).orElseThrow(() -> new IllegalArgumentException("Unable to apply encoding for field (" + field + ")"));
            fields.add(new ReadFieldsEntityStreamEncoder.ReadFieldsEntityField(encoder, field.getReader()));
        }
        return new ReadFieldsEntityStreamEncoder(Collections.unmodifiableList(fields), factory);
    }

    public <Target> EntityDecoder<Target, Object> newEntityTypeDecoder(EntityResolver resolver, DecoderFactory<Target> factory) {
        ArrayList fields = new ArrayList();
        for (EntityFieldMapping entityFieldMapping : this.fields) {
            fields.add(entityFieldMapping.newEntityFieldDecoder(resolver, factory).orElseThrow(() -> new IllegalArgumentException("Unable to apply encoding for field (" + field + ")")));
        }
        return new DefaultEntityDecoder(Collections.unmodifiableList(fields), this.instanceBuilder, factory);
    }

    public static Stream<Match<EntityMapping>> detect(EntityResolver resolver, JavaType type) {
        return resolver.detectCreatorMethod(type).map(creator -> {
            ArrayList<DefaultEntityFieldMapping> fields = new ArrayList<DefaultEntityFieldMapping>();
            for (EntityField field : creator.getFields()) {
                String fieldName = field.getName().orElseGet(() -> creator.getFieldNames().map(names -> (String)names.get(field.getIndex())).orElseThrow(() -> new IllegalArgumentException("Cannot detect property name for field: " + field.toString())));
                FieldReader reader = (FieldReader)resolver.detectFieldReader(type, fieldName, field.getType()).orElseThrow(() -> new IllegalArgumentException("Can't figure out how to read " + type + " field (" + fieldName + ")"));
                Annotations annotations = field.getAnnotations().merge(reader.annotations());
                TypeMapping m = resolver.mapping(reader.fieldType(), annotations);
                fields.add(new DefaultEntityFieldMapping(fieldName, m, reader));
            }
            return Stream.of(new DefaultEntityMapping(Collections.unmodifiableList(fields), (InstanceBuilder)creator));
        }).orElseGet(Stream::empty).map(Match.withPriority((MatchPriority)MatchPriority.HIGH));
    }

    @ConstructorProperties(value={"fields", "instanceBuilder"})
    public DefaultEntityMapping(List<DefaultEntityFieldMapping> fields, InstanceBuilder instanceBuilder) {
        this.fields = fields;
        this.instanceBuilder = instanceBuilder;
    }

    public List<DefaultEntityFieldMapping> getFields() {
        return this.fields;
    }

    public InstanceBuilder getInstanceBuilder() {
        return this.instanceBuilder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultEntityMapping)) {
            return false;
        }
        DefaultEntityMapping other = (DefaultEntityMapping)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<DefaultEntityFieldMapping> this$fields = this.getFields();
        List<DefaultEntityFieldMapping> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        InstanceBuilder this$instanceBuilder = this.getInstanceBuilder();
        InstanceBuilder other$instanceBuilder = other.getInstanceBuilder();
        return !(this$instanceBuilder == null ? other$instanceBuilder != null : !this$instanceBuilder.equals(other$instanceBuilder));
    }

    public boolean canEqual(Object other) {
        return other instanceof DefaultEntityMapping;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<DefaultEntityFieldMapping> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 0 : ((Object)$fields).hashCode());
        InstanceBuilder $instanceBuilder = this.getInstanceBuilder();
        result = result * 59 + ($instanceBuilder == null ? 0 : $instanceBuilder.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultEntityMapping(fields=" + this.getFields() + ", instanceBuilder=" + this.getInstanceBuilder() + ")";
    }
}

