/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe.entitymapping;

import eu.toolchain.scribe.AccessibleType;
import eu.toolchain.scribe.Annotations;
import eu.toolchain.scribe.DecoderFactory;
import eu.toolchain.scribe.EncoderFactory;
import eu.toolchain.scribe.EntityDecoder;
import eu.toolchain.scribe.EntityEncoder;
import eu.toolchain.scribe.EntityResolver;
import eu.toolchain.scribe.EntityStreamEncoder;
import eu.toolchain.scribe.JavaType;
import eu.toolchain.scribe.Match;
import eu.toolchain.scribe.MatchPriority;
import eu.toolchain.scribe.StreamEncoderFactory;
import eu.toolchain.scribe.entitymapping.BuilderEntityDecoder;
import eu.toolchain.scribe.entitymapping.BuilderEntityFieldDecoder;
import eu.toolchain.scribe.entitymapping.BuilderEntityFieldEncoder;
import eu.toolchain.scribe.entitymapping.BuilderEntityFieldMapping;
import eu.toolchain.scribe.entitymapping.BuilderEntityFieldStreamEncoder;
import eu.toolchain.scribe.entitymapping.EntityFieldMapping;
import eu.toolchain.scribe.entitymapping.EntityMapping;
import eu.toolchain.scribe.entitymapping.ReadFieldsEntityEncoder;
import eu.toolchain.scribe.entitymapping.ReadFieldsEntityStreamEncoder;
import eu.toolchain.scribe.fieldreader.FieldReader;
import eu.toolchain.scribe.typemapping.TypeMapping;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class BuilderEntityMapping
implements EntityMapping {
    private final List<BuilderEntityFieldMapping> fields;
    private final JavaType.Method newInstance;
    private final JavaType.Method build;

    public List<? extends EntityFieldMapping> fields() {
        return this.fields;
    }

    public <Target> EntityEncoder<Target, Object> newEntityTypeEncoder(EntityResolver resolver, EncoderFactory<Target> factory) {
        ArrayList<ReadFieldsEntityEncoder.ReadFieldsEntityField> fields = new ArrayList<ReadFieldsEntityEncoder.ReadFieldsEntityField>();
        for (BuilderEntityFieldMapping field : this.fields) {
            BuilderEntityFieldEncoder<Target> fieldEncoder = field.newEntityFieldEncoder(resolver, factory).orElseThrow(() -> new IllegalArgumentException("Unable to apply encoding for field (" + field + ")"));
            fields.add(new ReadFieldsEntityEncoder.ReadFieldsEntityField(fieldEncoder, field.getReader()));
        }
        return new ReadFieldsEntityEncoder(Collections.unmodifiableList(fields), factory);
    }

    public <Target> EntityStreamEncoder<Target, Object> newEntityTypeStreamEncoder(EntityResolver resolver, StreamEncoderFactory<Target> factory) {
        ArrayList<ReadFieldsEntityStreamEncoder.ReadFieldsEntityField> fields = new ArrayList<ReadFieldsEntityStreamEncoder.ReadFieldsEntityField>();
        for (BuilderEntityFieldMapping field : this.fields) {
            BuilderEntityFieldStreamEncoder<Target> encoder = field.newEntityFieldStreamEncoder(resolver, factory).orElseThrow(() -> new IllegalArgumentException("Unable to apply encoding for field (" + field + ")"));
            fields.add(new ReadFieldsEntityStreamEncoder.ReadFieldsEntityField(encoder, field.getReader()));
        }
        return new ReadFieldsEntityStreamEncoder(Collections.unmodifiableList(fields), factory);
    }

    public <Target> EntityDecoder<Target, Object> newEntityTypeDecoder(EntityResolver resolver, DecoderFactory<Target> factory) {
        ArrayList<BuilderEntityFieldDecoder<Target>> fields = new ArrayList<BuilderEntityFieldDecoder<Target>>();
        for (BuilderEntityFieldMapping field : this.fields) {
            fields.add(field.newEntityFieldDecoder(resolver, factory).orElseThrow(() -> new IllegalArgumentException("Unable to apply encoding for field (" + field + ")")));
        }
        return new BuilderEntityDecoder(Collections.unmodifiableList(fields), this.newInstance, this.build, factory);
    }

    public static Stream<Match<EntityMapping>> detect(EntityResolver resolver, JavaType type) {
        return type.getMethod("builder", new JavaType[0]).filter(AccessibleType::isStatic).map(newInstance -> {
            ArrayList fields = new ArrayList();
            JavaType returnType = newInstance.getReturnType();
            JavaType.Method builderBuild = (JavaType.Method)returnType.getMethod("build", new JavaType[0]).findFirst().orElseThrow(() -> new IllegalArgumentException("Method build() missing on type (" + returnType + ")"));
            if (!builderBuild.getReturnType().equals((Object)type)) {
                throw new IllegalArgumentException(builderBuild + " returns (" + builderBuild.getReturnType() + ") instead forAnnotation expected (" + type + ")");
            }
            type.getFields().filter(f -> !f.isStatic()).forEach(field -> {
                JavaType propertyType = field.getFieldType();
                FieldReader reader = (FieldReader)resolver.detectFieldReader(type, field.getName(), propertyType).orElseThrow(() -> new IllegalArgumentException("Can't figure out how to read (" + type + ") field (" + field.getName() + ")"));
                JavaType.Method setter = (JavaType.Method)returnType.getMethod(field.getName(), new JavaType[]{propertyType}).findFirst().orElseThrow(() -> new IllegalArgumentException("Builder does not have method " + returnType + "#" + field.getName() + "(" + propertyType + ")"));
                Annotations annotations = reader.annotations().merge(Annotations.of((Stream)field.getAnnotationStream()));
                String fieldName = resolver.detectFieldName(type, annotations).orElseGet(() -> ((JavaType.Field)field).getName());
                TypeMapping m = resolver.mapping(reader.fieldType(), annotations);
                fields.add(new BuilderEntityFieldMapping(fieldName, m, reader, setter));
            });
            return new BuilderEntityMapping(Collections.unmodifiableList(fields), (JavaType.Method)newInstance, builderBuild);
        }).map(Match.withPriority((MatchPriority)MatchPriority.LOW));
    }

    @ConstructorProperties(value={"fields", "newInstance", "build"})
    public BuilderEntityMapping(List<BuilderEntityFieldMapping> fields, JavaType.Method newInstance, JavaType.Method build) {
        this.fields = fields;
        this.newInstance = newInstance;
        this.build = build;
    }

    public List<BuilderEntityFieldMapping> getFields() {
        return this.fields;
    }

    public JavaType.Method getNewInstance() {
        return this.newInstance;
    }

    public JavaType.Method getBuild() {
        return this.build;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuilderEntityMapping)) {
            return false;
        }
        BuilderEntityMapping other = (BuilderEntityMapping)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<BuilderEntityFieldMapping> this$fields = this.getFields();
        List<BuilderEntityFieldMapping> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        JavaType.Method this$newInstance = this.getNewInstance();
        JavaType.Method other$newInstance = other.getNewInstance();
        if (this$newInstance == null ? other$newInstance != null : !this$newInstance.equals(other$newInstance)) {
            return false;
        }
        JavaType.Method this$build = this.getBuild();
        JavaType.Method other$build = other.getBuild();
        return !(this$build == null ? other$build != null : !this$build.equals(other$build));
    }

    public boolean canEqual(Object other) {
        return other instanceof BuilderEntityMapping;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<BuilderEntityFieldMapping> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 0 : ((Object)$fields).hashCode());
        JavaType.Method $newInstance = this.getNewInstance();
        result = result * 59 + ($newInstance == null ? 0 : $newInstance.hashCode());
        JavaType.Method $build = this.getBuild();
        result = result * 59 + ($build == null ? 0 : $build.hashCode());
        return result;
    }

    public String toString() {
        return "BuilderEntityMapping(fields=" + this.getFields() + ", newInstance=" + this.getNewInstance() + ", build=" + this.getBuild() + ")";
    }
}

