/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe.creatormethod;

import eu.toolchain.scribe.AccessibleType;
import eu.toolchain.scribe.Annotations;
import eu.toolchain.scribe.EntityField;
import eu.toolchain.scribe.ExecutableType;
import eu.toolchain.scribe.JavaType;
import eu.toolchain.scribe.Match;
import eu.toolchain.scribe.MatchPriority;
import eu.toolchain.scribe.creatormethod.CreatorMethod;
import eu.toolchain.scribe.entitymapper.CreatorMethodDetector;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class ConstructorCreatorMethod
implements CreatorMethod {
    private final List<EntityField> fields;
    private final Optional<List<String>> fieldNames;
    private final JavaType.Constructor constructor;

    public Object newInstance(List<Object> arguments) {
        try {
            return this.constructor.newInstance(arguments.toArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CreatorMethodDetector forEmpty() {
        return (resolver, type) -> type.getConstructors().filter(AccessibleType::isPublic).filter(c -> c.getParameters().isEmpty()).map(c -> new ConstructorCreatorMethod(Collections.emptyList(), Optional.empty(), (JavaType.Constructor)c)).map(Match.withPriority((MatchPriority)MatchPriority.LOW));
    }

    public static <A extends Annotation> CreatorMethodDetector forAnnotation(Class<A> marker) {
        return ConstructorCreatorMethod.forAnnotation(marker, a -> Optional.empty());
    }

    public static <A extends Annotation> CreatorMethodDetector forAnnotation(Class<A> marker, Function<A, Optional<List<String>>> names) {
        Annotations.verifyRetentionPolicy(marker, (RetentionPolicy)RetentionPolicy.RUNTIME);
        return (resolver, type) -> type.getConstructors().flatMap(c -> {
            if (!c.isPublic()) {
                return Stream.of(new ConstructorCreatorMethod[0]);
            }
            return c.getAnnotation(marker).map(a -> {
                List fields = resolver.detectExecutableFields((ExecutableType)c);
                Optional fieldNames = (Optional)names.apply(a);
                fieldNames.ifPresent(n -> {
                    if (n.size() != fields.size()) {
                        throw new IllegalArgumentException("Constructor (" + c + ") unexpected number forAnnotation fields (" + fields.size() + "), expected (" + n.size() + ") due to value in " + a + " annotation");
                    }
                });
                return new ConstructorCreatorMethod(fields, fieldNames, (JavaType.Constructor)c);
            });
        }).map(Match.withPriority((MatchPriority)MatchPriority.HIGH));
    }

    @ConstructorProperties(value={"fields", "fieldNames", "constructor"})
    public ConstructorCreatorMethod(List<EntityField> fields, Optional<List<String>> fieldNames, JavaType.Constructor constructor) {
        this.fields = fields;
        this.fieldNames = fieldNames;
        this.constructor = constructor;
    }

    public List<EntityField> getFields() {
        return this.fields;
    }

    public Optional<List<String>> getFieldNames() {
        return this.fieldNames;
    }

    public JavaType.Constructor getConstructor() {
        return this.constructor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConstructorCreatorMethod)) {
            return false;
        }
        ConstructorCreatorMethod other = (ConstructorCreatorMethod)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<EntityField> this$fields = this.getFields();
        List<EntityField> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        Optional<List<String>> this$fieldNames = this.getFieldNames();
        Optional<List<String>> other$fieldNames = other.getFieldNames();
        if (this$fieldNames == null ? other$fieldNames != null : !((Object)this$fieldNames).equals(other$fieldNames)) {
            return false;
        }
        JavaType.Constructor this$constructor = this.getConstructor();
        JavaType.Constructor other$constructor = other.getConstructor();
        return !(this$constructor == null ? other$constructor != null : !this$constructor.equals(other$constructor));
    }

    public boolean canEqual(Object other) {
        return other instanceof ConstructorCreatorMethod;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<EntityField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 0 : ((Object)$fields).hashCode());
        Optional<List<String>> $fieldNames = this.getFieldNames();
        result = result * 59 + ($fieldNames == null ? 0 : ((Object)$fieldNames).hashCode());
        JavaType.Constructor $constructor = this.getConstructor();
        result = result * 59 + ($constructor == null ? 0 : $constructor.hashCode());
        return result;
    }

    public String toString() {
        return "ConstructorCreatorMethod(fields=" + this.getFields() + ", fieldNames=" + this.getFieldNames() + ", constructor=" + this.getConstructor() + ")";
    }
}

