/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.Annotations;
import eu.toolchain.scribe.Decoder;
import eu.toolchain.scribe.DecoderFactory;
import eu.toolchain.scribe.DefaultModule;
import eu.toolchain.scribe.Encoder;
import eu.toolchain.scribe.EncoderFactory;
import eu.toolchain.scribe.EntityField;
import eu.toolchain.scribe.EntityMapperBuilder;
import eu.toolchain.scribe.EntityResolver;
import eu.toolchain.scribe.ExecutableType;
import eu.toolchain.scribe.JavaType;
import eu.toolchain.scribe.Match;
import eu.toolchain.scribe.Module;
import eu.toolchain.scribe.NativeAnnotationsModule;
import eu.toolchain.scribe.Option;
import eu.toolchain.scribe.StreamEncoder;
import eu.toolchain.scribe.StreamEncoderFactory;
import eu.toolchain.scribe.TypeDecoderProvider;
import eu.toolchain.scribe.TypeEncoderProvider;
import eu.toolchain.scribe.TypeReference;
import eu.toolchain.scribe.TypeStreamEncoderProvider;
import eu.toolchain.scribe.ValueTypeMapping;
import eu.toolchain.scribe.creatormethod.CreatorMethod;
import eu.toolchain.scribe.entitymapper.CreatorMethodDetector;
import eu.toolchain.scribe.entitymapper.DecodeValueDetector;
import eu.toolchain.scribe.entitymapper.EncodeValueDetector;
import eu.toolchain.scribe.entitymapper.EntityMappingDetector;
import eu.toolchain.scribe.entitymapper.FieldNameDetector;
import eu.toolchain.scribe.entitymapper.FieldReaderDetector;
import eu.toolchain.scribe.entitymapper.SubType;
import eu.toolchain.scribe.entitymapper.SubTypesDetector;
import eu.toolchain.scribe.entitymapper.TypeAliasDetector;
import eu.toolchain.scribe.entitymapper.TypeNameDetector;
import eu.toolchain.scribe.entitymapping.EntityMapping;
import eu.toolchain.scribe.fieldreader.FieldReader;
import eu.toolchain.scribe.typealias.TypeAlias;
import eu.toolchain.scribe.typemapper.TypeMapper;
import eu.toolchain.scribe.typemapping.ConcreteEntityTypeMapping;
import eu.toolchain.scribe.typemapping.DecodeValue;
import eu.toolchain.scribe.typemapping.EncodeValue;
import eu.toolchain.scribe.typemapping.EntityTypeMapping;
import eu.toolchain.scribe.typemapping.PropertyAbstractEntityTypeMapping;
import eu.toolchain.scribe.typemapping.TypeMapping;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EntityMapper
implements EntityResolver {
    private static final Comparator<Match<?>> BY_SCORE_COMPARATOR = (a, b) -> Integer.compare(b.getPriority().ordinal(), a.getPriority().ordinal());
    private final List<TypeAliasDetector> typeAliasDetectors;
    private final List<TypeMapper> typeMapperDetectors;
    private final List<FieldReaderDetector> fieldReaderDetectors;
    private final List<CreatorMethodDetector> creatorMethodDetectors;
    private final List<EntityMappingDetector> entityMappingDetectors;
    private final List<SubTypesDetector> subTypesDetectors;
    private final List<EncodeValueDetector> encodeValueDetectors;
    private final List<DecodeValueDetector> decodeValueDetectors;
    private final List<FieldNameDetector> fieldNameDetectors;
    private final List<TypeNameDetector> typeNameDetectors;
    private final Map<Class<? extends Option>, Option> options;
    private final ConcurrentMap<EntityKey, TypeMapping> cache = new ConcurrentHashMap<EntityKey, TypeMapping>();
    private final Object resolverLock = new Object();

    public <Target> TypeStreamEncoderProvider<Target> streamEncoderFor(final StreamEncoderFactory<Target> factory) {
        return new TypeStreamEncoderProvider<Target>(){

            public StreamEncoder<Target, Object> newStreamEncoder(Type type) {
                return (StreamEncoder)EntityMapper.this.mapping(JavaType.of((Type)type)).newStreamEncoder((EntityResolver)EntityMapper.this, factory).orElseThrow(() -> new IllegalArgumentException("Unable to resolve encoding for type (" + type + ")"));
            }

            public <Source> StreamEncoder<Target, Source> newStreamEncoder(Class<Source> type) {
                return this.newStreamEncoder((Type)type);
            }

            public <Source> StreamEncoder<Target, Source> newStreamEncoder(TypeReference<Source> type) {
                return this.newStreamEncoder(type.getType());
            }
        };
    }

    public <Target> TypeEncoderProvider<Target> encoderFor(final EncoderFactory<Target> factory) {
        return new TypeEncoderProvider<Target>(){

            public Encoder<Target, Object> newEncoder(Type type) {
                return (Encoder)EntityMapper.this.mapping(JavaType.of((Type)type)).newEncoder((EntityResolver)EntityMapper.this, factory).orElseThrow(() -> new IllegalArgumentException("Unable to resolve encoding for type (" + type + ")"));
            }

            public <Source> Encoder<Target, Source> newEncoder(Class<Source> type) {
                return this.newEncoder((Type)type);
            }

            public <Source> Encoder<Target, Source> newEncoder(TypeReference<Source> type) {
                return this.newEncoder(type.getType());
            }
        };
    }

    public <Target> TypeDecoderProvider<Target> decoderFor(final DecoderFactory<Target> factory) {
        return new TypeDecoderProvider<Target>(){

            public Decoder<Target, Object> newDecoder(Type type) {
                return (Decoder)EntityMapper.this.mapping(JavaType.of((Type)type)).newDecoder((EntityResolver)EntityMapper.this, factory).orElseThrow(() -> new IllegalArgumentException("Unable to resolve encoding for type (" + type + ")"));
            }

            public <Source> Decoder<Target, Source> newDecoder(Class<Source> type) {
                return this.newDecoder((Type)type);
            }

            public <Source> Decoder<Target, Source> newDecoder(TypeReference<Source> type) {
                return this.newDecoder(type.getType());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeMapping mapping(JavaType type, Annotations annotations) {
        EntityKey key = new EntityKey(type, annotations);
        TypeMapping mapping = (TypeMapping)this.cache.get(key);
        if (mapping != null) {
            return mapping;
        }
        Object object = this.resolverLock;
        synchronized (object) {
            TypeMapping candidate = (TypeMapping)this.cache.get(key);
            if (candidate != null) {
                return candidate;
            }
            TypeMapping newMapping = this.resolveAliasing(type, annotations);
            this.cache.put(key, newMapping);
            newMapping.initialize((EntityResolver)this);
            return newMapping;
        }
    }

    public TypeMapping mapping(JavaType type) {
        return this.mapping(type, Annotations.empty());
    }

    public Optional<? extends CreatorMethod> detectCreatorMethod(JavaType type) {
        return this.firstPriorityMatch(this.creatorMethodDetectors.stream(), c -> c.detect((EntityResolver)this, type));
    }

    public Optional<FieldReader> detectFieldReader(JavaType type, String fieldName, JavaType fieldType) {
        return this.firstPriorityMatch(this.fieldReaderDetectors.stream(), c -> c.detect(type, fieldName, fieldType));
    }

    public Optional<EntityMapping> detectEntityMapping(JavaType type) {
        return this.firstPriorityMatch(this.entityMappingDetectors.stream(), d -> d.detect((EntityResolver)this, type));
    }

    public List<SubType> resolveSubTypes(JavaType type) {
        return this.firstPriorityMatch(this.subTypesDetectors.stream(), d -> d.detect((EntityResolver)this, type)).orElseGet(Collections::emptyList);
    }

    public Optional<EncodeValue> detectEncodeValue(JavaType type) {
        return this.firstPriorityMatch(this.encodeValueDetectors.stream(), d -> d.detect((EntityResolver)this, type));
    }

    public Optional<DecodeValue> detectDecodeValue(JavaType type, JavaType fieldType) {
        return this.firstPriorityMatch(this.decodeValueDetectors.stream(), d -> d.detect((EntityResolver)this, type, fieldType));
    }

    public Optional<String> detectFieldName(JavaType type, Annotations annotations) {
        return this.firstPriorityMatch(this.fieldNameDetectors.stream(), d -> d.detect((EntityResolver)this, type, annotations));
    }

    public Optional<String> detectTypeName(JavaType type) {
        return this.firstPriorityMatch(this.typeNameDetectors.stream(), d -> d.detect((EntityResolver)this, type));
    }

    public List<EntityField> detectExecutableFields(ExecutableType executable) {
        ArrayList<EntityField> fields = new ArrayList<EntityField>();
        int index = 0;
        for (JavaType.Parameter p : executable.getParameters()) {
            int i = index++;
            Annotations annotations = Annotations.of((Stream)p.getAnnotationStream());
            JavaType type = p.getParameterType();
            Optional<String> name = this.detectFieldName(type, annotations);
            fields.add(new EntityField(i, annotations, type, name));
        }
        return fields;
    }

    public <O extends Option> Optional<O> getOption(Class<O> option) {
        return Optional.ofNullable(this.options.get(option));
    }

    public <O extends Option> boolean isOptionPresent(O option) {
        return this.options.values().contains(option);
    }

    public EntityMapper withOptions(Option ... options) {
        if (options.length == 0) {
            return this;
        }
        Builder builder = this.toBuilder();
        Arrays.stream(options).forEach(builder::option);
        return builder.build();
    }

    private TypeMapping resolveAliasing(JavaType type, Annotations annotations) {
        List<TypeAlias> aliasing = this.resolveTypeAliases(type, annotations);
        if (aliasing.isEmpty()) {
            return this.resolveTypeMapping(type);
        }
        return this.applyTypeAliases(aliasing);
    }

    private TypeMapping applyTypeAliases(List<TypeAlias> aliasing) {
        TypeAlias lastAlias = aliasing.get(aliasing.size() - 1);
        ListIterator<TypeAlias> it = aliasing.listIterator(aliasing.size());
        TypeMapping lastMapping = this.resolveTypeMapping(lastAlias.getFromType());
        while (it.hasPrevious()) {
            lastMapping = it.previous().apply(lastMapping);
        }
        return lastMapping;
    }

    private TypeMapping resolveTypeMapping(JavaType sourceType) {
        return this.firstPriorityMatch(this.typeMapperDetectors.stream(), m -> m.map((EntityResolver)this, sourceType)).orElseGet(() -> this.resolveBean(sourceType));
    }

    private List<TypeAlias> resolveTypeAliases(JavaType type, Annotations annotations) {
        ArrayList<TypeAlias> aliasing = new ArrayList<TypeAlias>();
        ArrayList<JavaType> seen = new ArrayList<JavaType>();
        seen.add(type);
        JavaType current = type;
        while (true) {
            JavaType t = current;
            Optional m = this.firstMatch(this.typeAliasDetectors.stream(), a -> a.apply(t, annotations));
            if (!m.isPresent()) break;
            TypeAlias alias = (TypeAlias)m.get();
            if (seen.contains(alias.getFromType())) {
                seen.add(alias.getToType());
                StringJoiner joiner = new StringJoiner(" -> ", "", "");
                seen.stream().map(Object::toString).forEach(joiner::add);
                throw new IllegalArgumentException("Cycle in aliasing detected: " + joiner.toString());
            }
            seen.add(alias.getFromType());
            aliasing.add(alias);
            current = alias.getFromType();
        }
        return aliasing;
    }

    private <Target, Source> Optional<Source> firstMatch(Stream<Target> alternatives, Function<Target, Stream<Source>> map) {
        List results = alternatives.flatMap(map).collect(Collectors.toList());
        if (results.size() > 1) {
            throw new IllegalArgumentException("Found multiple matches for type: " + results);
        }
        return results.stream().findFirst();
    }

    private <Target, Source> Optional<Source> firstPriorityMatch(Stream<Target> alternatives, Function<Target, Stream<Match<Source>>> map) {
        List results = alternatives.flatMap(map).collect(Collectors.toList());
        ArrayList sorted = new ArrayList(results);
        Collections.sort(sorted, BY_SCORE_COMPARATOR);
        if (results.size() > 1 && ((Match)sorted.get(0)).getPriority() == ((Match)sorted.get(1)).getPriority()) {
            throw new IllegalArgumentException("Found multiple matches with the same priority: " + sorted);
        }
        return sorted.stream().map(Match::getValue).findFirst();
    }

    private TypeMapping resolveBean(JavaType type) {
        return this.resolveEncodeValue(type).orElseGet(() -> {
            Optional<String> typeName = this.detectTypeName(type);
            if (type.isAbstract()) {
                return this.doAbstract(type, typeName);
            }
            return this.doConcrete(type, typeName);
        });
    }

    private Optional<TypeMapping> resolveEncodeValue(JavaType type) {
        return this.detectEncodeValue(type).map(encodeValue -> {
            TypeMapping target = encodeValue.getTargetMapping();
            DecodeValue decodeValue = this.detectDecodeValue(type, target.getType()).orElseThrow(() -> new IllegalArgumentException("Value encoder detected, but no corresponding decoder: " + type));
            return new ValueTypeMapping((EncodeValue)encodeValue, decodeValue);
        });
    }

    private EntityTypeMapping doAbstract(JavaType type, Optional<String> typeName) {
        List<SubType> subTypes = this.resolveSubTypes(type);
        return new PropertyAbstractEntityTypeMapping(type, typeName, subTypes, Optional.empty());
    }

    private EntityTypeMapping doConcrete(JavaType type, Optional<String> typeName) {
        return new ConcreteEntityTypeMapping(type, typeName);
    }

    public Builder toBuilder() {
        return new Builder(new ArrayList<TypeAliasDetector>(this.typeAliasDetectors), new ArrayList<TypeMapper>(this.typeMapperDetectors), new ArrayList<FieldReaderDetector>(this.fieldReaderDetectors), new ArrayList<CreatorMethodDetector>(this.creatorMethodDetectors), new ArrayList<EntityMappingDetector>(this.entityMappingDetectors), new ArrayList<SubTypesDetector>(this.subTypesDetectors), new ArrayList<EncodeValueDetector>(this.encodeValueDetectors), new ArrayList<DecodeValueDetector>(this.decodeValueDetectors), new ArrayList<FieldNameDetector>(this.fieldNameDetectors), new ArrayList<TypeNameDetector>(this.typeNameDetectors), new HashSet<Option>(this.options.values()));
    }

    public static EntityMapperBuilder<EntityMapper> builder() {
        return new Builder();
    }

    public static EntityMapperBuilder<EntityMapper> defaultBuilder() {
        return EntityMapper.builder().register((Module)new DefaultModule());
    }

    public static EntityMapperBuilder<EntityMapper> nativeBuilder() {
        return EntityMapper.defaultBuilder().register((Module)new NativeAnnotationsModule());
    }

    @ConstructorProperties(value={"typeAliasDetectors", "typeMapperDetectors", "fieldReaderDetectors", "creatorMethodDetectors", "entityMappingDetectors", "subTypesDetectors", "encodeValueDetectors", "decodeValueDetectors", "fieldNameDetectors", "typeNameDetectors", "options"})
    public EntityMapper(List<TypeAliasDetector> typeAliasDetectors, List<TypeMapper> typeMapperDetectors, List<FieldReaderDetector> fieldReaderDetectors, List<CreatorMethodDetector> creatorMethodDetectors, List<EntityMappingDetector> entityMappingDetectors, List<SubTypesDetector> subTypesDetectors, List<EncodeValueDetector> encodeValueDetectors, List<DecodeValueDetector> decodeValueDetectors, List<FieldNameDetector> fieldNameDetectors, List<TypeNameDetector> typeNameDetectors, Map<Class<? extends Option>, Option> options) {
        this.typeAliasDetectors = typeAliasDetectors;
        this.typeMapperDetectors = typeMapperDetectors;
        this.fieldReaderDetectors = fieldReaderDetectors;
        this.creatorMethodDetectors = creatorMethodDetectors;
        this.entityMappingDetectors = entityMappingDetectors;
        this.subTypesDetectors = subTypesDetectors;
        this.encodeValueDetectors = encodeValueDetectors;
        this.decodeValueDetectors = decodeValueDetectors;
        this.fieldNameDetectors = fieldNameDetectors;
        this.typeNameDetectors = typeNameDetectors;
        this.options = options;
    }

    public static class Builder
    implements EntityMapperBuilder<EntityMapper> {
        private final ArrayList<TypeAliasDetector> typeAliasDetectors;
        private final ArrayList<TypeMapper> typeMapperDetectors;
        private final ArrayList<FieldReaderDetector> fieldReaderDetectors;
        private final ArrayList<CreatorMethodDetector> creatorMethodDetectors;
        private final ArrayList<EntityMappingDetector> entityMappingDetectors;
        private final ArrayList<SubTypesDetector> subTypesDetectors;
        private final ArrayList<EncodeValueDetector> encodeValueDetectors;
        private final ArrayList<DecodeValueDetector> decodeValueDetectors;
        private final ArrayList<FieldNameDetector> fieldNameDetectors;
        private final ArrayList<TypeNameDetector> typeNameDetectors;
        private final HashSet<Option> options;

        public Builder() {
            this.typeAliasDetectors = new ArrayList();
            this.typeMapperDetectors = new ArrayList();
            this.fieldReaderDetectors = new ArrayList();
            this.creatorMethodDetectors = new ArrayList();
            this.entityMappingDetectors = new ArrayList();
            this.subTypesDetectors = new ArrayList();
            this.encodeValueDetectors = new ArrayList();
            this.decodeValueDetectors = new ArrayList();
            this.fieldNameDetectors = new ArrayList();
            this.typeNameDetectors = new ArrayList();
            this.options = new HashSet();
        }

        public Builder typeAliasDetector(TypeAliasDetector typeAliasDetector) {
            this.typeAliasDetectors.add(typeAliasDetector);
            return this;
        }

        public Builder typeMapper(TypeMapper typeMapper) {
            this.typeMapperDetectors.add(typeMapper);
            return this;
        }

        public Builder fieldReaderDetector(FieldReaderDetector fieldReader) {
            this.fieldReaderDetectors.add(fieldReader);
            return this;
        }

        public Builder creatorMethodDetector(CreatorMethodDetector creatorMethod) {
            this.creatorMethodDetectors.add(creatorMethod);
            return this;
        }

        public Builder entityMappingDetector(EntityMappingDetector binding) {
            this.entityMappingDetectors.add(binding);
            return this;
        }

        public Builder subTypesDetector(SubTypesDetector subTypeDetector) {
            this.subTypesDetectors.add(subTypeDetector);
            return this;
        }

        public Builder encodeValueDetector(EncodeValueDetector encodeValueDetector) {
            this.encodeValueDetectors.add(encodeValueDetector);
            return this;
        }

        public Builder decodeValueDetector(DecodeValueDetector decodeValueDetector) {
            this.decodeValueDetectors.add(decodeValueDetector);
            return this;
        }

        public Builder fieldNameDetector(FieldNameDetector fieldNameDetector) {
            this.fieldNameDetectors.add(fieldNameDetector);
            return this;
        }

        public Builder typeNameDetector(TypeNameDetector typeNameDetector) {
            this.typeNameDetectors.add(typeNameDetector);
            return this;
        }

        public Builder option(Option option) {
            this.options.add(option);
            return this;
        }

        public EntityMapper build() {
            Map options = this.options.stream().collect(Collectors.toMap(o -> o.getClass(), Function.identity()));
            return new EntityMapper(Collections.unmodifiableList(new ArrayList<TypeAliasDetector>(this.typeAliasDetectors)), Collections.unmodifiableList(new ArrayList<TypeMapper>(this.typeMapperDetectors)), Collections.unmodifiableList(new ArrayList<FieldReaderDetector>(this.fieldReaderDetectors)), Collections.unmodifiableList(new ArrayList<CreatorMethodDetector>(this.creatorMethodDetectors)), Collections.unmodifiableList(new ArrayList<EntityMappingDetector>(this.entityMappingDetectors)), Collections.unmodifiableList(new ArrayList<SubTypesDetector>(this.subTypesDetectors)), Collections.unmodifiableList(new ArrayList<EncodeValueDetector>(this.encodeValueDetectors)), Collections.unmodifiableList(new ArrayList<DecodeValueDetector>(this.decodeValueDetectors)), Collections.unmodifiableList(new ArrayList<FieldNameDetector>(this.fieldNameDetectors)), Collections.unmodifiableList(new ArrayList<TypeNameDetector>(this.typeNameDetectors)), Collections.unmodifiableMap(options));
        }

        public EntityMapperBuilder<EntityMapper> register(Module module) {
            return module.register((EntityMapperBuilder)this);
        }

        @ConstructorProperties(value={"typeAliasDetectors", "typeMapperDetectors", "fieldReaderDetectors", "creatorMethodDetectors", "entityMappingDetectors", "subTypesDetectors", "encodeValueDetectors", "decodeValueDetectors", "fieldNameDetectors", "typeNameDetectors", "options"})
        public Builder(ArrayList<TypeAliasDetector> typeAliasDetectors, ArrayList<TypeMapper> typeMapperDetectors, ArrayList<FieldReaderDetector> fieldReaderDetectors, ArrayList<CreatorMethodDetector> creatorMethodDetectors, ArrayList<EntityMappingDetector> entityMappingDetectors, ArrayList<SubTypesDetector> subTypesDetectors, ArrayList<EncodeValueDetector> encodeValueDetectors, ArrayList<DecodeValueDetector> decodeValueDetectors, ArrayList<FieldNameDetector> fieldNameDetectors, ArrayList<TypeNameDetector> typeNameDetectors, HashSet<Option> options) {
            this.typeAliasDetectors = typeAliasDetectors;
            this.typeMapperDetectors = typeMapperDetectors;
            this.fieldReaderDetectors = fieldReaderDetectors;
            this.creatorMethodDetectors = creatorMethodDetectors;
            this.entityMappingDetectors = entityMappingDetectors;
            this.subTypesDetectors = subTypesDetectors;
            this.encodeValueDetectors = encodeValueDetectors;
            this.decodeValueDetectors = decodeValueDetectors;
            this.fieldNameDetectors = fieldNameDetectors;
            this.typeNameDetectors = typeNameDetectors;
            this.options = options;
        }
    }

    public static class EntityKey {
        private final JavaType type;
        private final Annotations annotations;

        @ConstructorProperties(value={"type", "annotations"})
        public EntityKey(JavaType type, Annotations annotations) {
            this.type = type;
            this.annotations = annotations;
        }

        public JavaType getType() {
            return this.type;
        }

        public Annotations getAnnotations() {
            return this.annotations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntityKey)) {
                return false;
            }
            EntityKey other = (EntityKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Annotations this$annotations = this.getAnnotations();
            Annotations other$annotations = other.getAnnotations();
            return !(this$annotations == null ? other$annotations != null : !this$annotations.equals(other$annotations));
        }

        public boolean canEqual(Object other) {
            return other instanceof EntityKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 0 : $type.hashCode());
            Annotations $annotations = this.getAnnotations();
            result = result * 59 + ($annotations == null ? 0 : $annotations.hashCode());
            return result;
        }

        public String toString() {
            return "EntityMapper.EntityKey(type=" + this.getType() + ", annotations=" + this.getAnnotations() + ")";
        }
    }
}

