/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.Decoder;
import eu.toolchain.scribe.DecoderFactory;
import eu.toolchain.scribe.Encoder;
import eu.toolchain.scribe.EncoderFactory;
import eu.toolchain.scribe.EntityResolver;
import eu.toolchain.scribe.JavaType;
import eu.toolchain.scribe.StreamEncoder;
import eu.toolchain.scribe.StreamEncoderFactory;
import eu.toolchain.scribe.typemapping.TypeMapping;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class EncodedTypeMapping
implements TypeMapping {
    private final JavaType type;

    public <Target, Source> Optional<Encoder<Target, Source>> newEncoder(EntityResolver resolver, EncoderFactory<Target> factory) {
        List results = factory.newEncoder(resolver, this.type).collect(Collectors.toList());
        if (results.size() > 1) {
            throw new IllegalArgumentException("Type (" + this.type + ") has more than one matching encoder: " + results);
        }
        return results.stream().findFirst();
    }

    public <Target, Source> Optional<StreamEncoder<Target, Source>> newStreamEncoder(EntityResolver resolver, StreamEncoderFactory<Target> factory) {
        List results = factory.newStreamEncoder(resolver, this.type).collect(Collectors.toList());
        if (results.size() > 1) {
            throw new IllegalArgumentException("Type (" + this.type + ") has more than one matching encoder: " + results);
        }
        return results.stream().findFirst();
    }

    public <Target, Source> Optional<Decoder<Target, Source>> newDecoder(EntityResolver resolver, DecoderFactory<Target> factory) {
        List results = factory.newDecoder(resolver, this.type).collect(Collectors.toList());
        if (results.size() > 1) {
            throw new IllegalArgumentException("Type (" + this.type + ") has more than one matching decoder: " + results);
        }
        return results.stream().findFirst();
    }

    @ConstructorProperties(value={"type"})
    public EncodedTypeMapping(JavaType type) {
        this.type = type;
    }

    public JavaType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncodedTypeMapping)) {
            return false;
        }
        EncodedTypeMapping other = (EncodedTypeMapping)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JavaType this$type = this.getType();
        JavaType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    public boolean canEqual(Object other) {
        return other instanceof EncodedTypeMapping;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavaType $type = this.getType();
        result = result * 59 + ($type == null ? 0 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "EncodedTypeMapping(type=" + this.getType() + ")";
    }
}

