/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.toxiproxy;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpClient {
    private static final Gson GSON = new Gson();
    private final String protocol;
    private final String host;
    private final int port;

    HttpClient(String protocol, String host, int port) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
    }

    public JsonObject post(String path, String name, float value) throws IOException {
        JsonObject data = new JsonObject();
        data.addProperty(name, (Number)Float.valueOf(value));
        return this.post(path, data);
    }

    public JsonObject post(String path, String name, boolean value) throws IOException {
        JsonObject data = new JsonObject();
        data.addProperty(name, Boolean.valueOf(value));
        return this.post(path, data);
    }

    public JsonObject post(String path, String name, String value) throws IOException {
        JsonObject data = new JsonObject();
        data.addProperty(name, value);
        return this.post(path, data);
    }

    public String getPlain(String path) throws IOException {
        HttpURLConnection connection = this.getConnection(path);
        int status = connection.getResponseCode();
        if (status < 200 || status > 299) {
            throw new IOException(HttpClient.readTextAndClose(connection.getErrorStream()));
        }
        return HttpClient.readTextAndClose(connection.getInputStream());
    }

    public JsonObject get(String path) throws IOException {
        return this.get(path, JsonObject.class);
    }

    public <T> T get(String path, Class<T> clazz) throws IOException {
        HttpURLConnection connection = this.getConnection(path);
        return HttpClient.readResponse(connection, clazz);
    }

    public int post(String path) throws IOException {
        HttpURLConnection connection = this.getConnection(path);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.getInputStream().close();
        return connection.getResponseCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject post(String path, JsonObject data) throws IOException {
        HttpURLConnection connection = this.getConnection(path);
        connection.setDoOutput(true);
        try (OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());){
            GSON.toJson((JsonElement)data, (Appendable)writer);
        }
        return HttpClient.readResponse(connection, JsonObject.class);
    }

    public int delete(String path) throws IOException {
        HttpURLConnection connection = this.getConnection(path);
        connection.setDoOutput(true);
        connection.setRequestMethod("DELETE");
        connection.getInputStream().close();
        return connection.getResponseCode();
    }

    private HttpURLConnection getConnection(String path) throws IOException {
        URL url = new URL(String.format("%s://%s:%d%s", this.protocol, this.host, this.port, path));
        return (HttpURLConnection)url.openConnection();
    }

    private static <T> T readResponse(HttpURLConnection connection, Class<T> clazz) throws IOException {
        int status = connection.getResponseCode();
        if (status < 200 || status > 299) {
            JsonObject errorJson;
            String errorBody = HttpClient.readTextAndClose(connection.getErrorStream());
            String message = null;
            message = errorBody == null ? String.format("[%d]", new Object[0]) : ((errorJson = (JsonObject)GSON.fromJson(errorBody, JsonObject.class)) == null || !errorJson.has("error") ? String.format("[%d]", errorBody) : String.format("[%d] %s", status, errorJson.get("error").getAsString()));
            throw new IOException(message);
        }
        return HttpClient.readAndClose(connection.getInputStream(), clazz);
    }

    private static <T> T readAndClose(InputStream is, Class<T> clazz) throws IOException {
        try {
            Object object = GSON.fromJson((Reader)new InputStreamReader(is), clazz);
            return (T)object;
        }
        finally {
            is.close();
        }
    }

    private static String readTextAndClose(InputStream is) throws IOException {
        int len;
        char[] buffer = new char[1024];
        StringBuilder result = new StringBuilder();
        InputStreamReader r = new InputStreamReader(is);
        while ((len = r.read(buffer)) > -1) {
            result.append(buffer, 0, len);
        }
        return result.toString();
    }
}

