/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.gatt;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.polestar.naosdk.gatt.GattInterface;
import com.polestar.naosdk.gatt.INAOGattListener;
import com.polestar.naosdk.gatt.TGATTERROR;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@TargetApi(value=18)
public class GattManager
implements GattInterface {
    private static final int NB_CONNECTIONS_MAX = 5;
    private static final String TAG = "GattManager";
    private boolean a;
    private boolean b;
    private INAOGattListener a;
    private BluetoothAdapter a;
    private BluetoothManager a;
    private ConcurrentHashMap<String, BluetoothGatt> a;
    private Context a;
    private Handler a = new ConcurrentHashMap();
    private ConcurrentHashMap<String, HashMap<UUID, UUID>> b = false;

    public GattManager(Context context) {
        this.a = context;
        this.b = new ConcurrentHashMap();
        this.a();
    }

    private void a() {
        if (this.a == null) {
            this.a = (BluetoothManager)this.a.getSystemService("bluetooth");
            if (this.a == null) {
                Log.e((String)this.getClass().getSimpleName(), (String)"Unable to initialize BluetoothManager.");
                return;
            }
        }
        this.a = this.a.getAdapter();
        if (this.a == null) {
            Log.e((String)this.getClass().getSimpleName(), (String)"Unable to obtain a BluetoothAdapter.");
            return;
        }
    }

    @Override
    public void connectDevice(final String string2) {
        if (this.a.containsKey(string2) && this.a.get(string2) != null) {
            Log.e((String)this.getClass().getSimpleName(), (String)(string2 + "already connected !"));
            return;
        }
        final BluetoothDevice bluetoothDevice = this.a.getRemoteDevice(string2);
        if (this.b) {
            this.a.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothGatt bluetoothGatt = bluetoothDevice.connectGatt(GattManager.this.a.getApplicationContext(), GattManager.this.a, (BluetoothGattCallback)new a());
                    GattManager.this.a.put(string2, bluetoothGatt);
                }
            });
        } else {
            BluetoothGatt bluetoothGatt = bluetoothDevice.connectGatt(this.a.getApplicationContext(), this.a, (BluetoothGattCallback)new a());
            this.a.put(string2, bluetoothGatt);
        }
    }

    @Override
    public void disconnectDevice(final String string2) {
        if (!this.a.containsKey(string2)) {
            Log.e((String)this.getClass().getSimpleName(), (String)(string2 + "already disconnected !"));
            return;
        }
        if (this.b) {
            this.a.post(new Runnable(){

                @Override
                public void run() {
                    GattManager.this.a(string2);
                }
            });
        } else {
            this.a(string2);
        }
    }

    @Override
    public void readAtt(final String string2, String string3) {
        BluetoothGatt bluetoothGatt = (BluetoothGatt)this.a.get(string2);
        if (bluetoothGatt == null) {
            Log.e((String)this.getClass().getSimpleName(), (String)("No connection available for " + string2));
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    GattManager.this.a.onGattError(string2, TGATTERROR.DEVICE_NOT_CONNECTED);
                }
            });
            thread.start();
            return;
        }
        BluetoothGattService bluetoothGattService = bluetoothGatt.getService((UUID)((HashMap)this.b.get(string2)).get(UUID.fromString(string3)));
        if (bluetoothGattService == null) {
            Log.e((String)this.getClass().getSimpleName(), (String)"Cannot read attribute : Gatt service is null");
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    GattManager.this.a.onGattError(string2, TGATTERROR.SERVICE_NOT_AVAILABLE);
                }
            });
            thread.start();
            return;
        }
        BluetoothGattCharacteristic bluetoothGattCharacteristic = bluetoothGatt.getService((UUID)((HashMap)this.b.get(string2)).get(UUID.fromString(string3))).getCharacteristic(UUID.fromString(string3));
        bluetoothGatt.readCharacteristic(bluetoothGattCharacteristic);
    }

    @Override
    public void writeAtt(String string2, String string3, byte[] byArray) {
        BluetoothGatt bluetoothGatt = (BluetoothGatt)this.a.get(string2);
        if (bluetoothGatt == null) {
            Log.e((String)this.getClass().getSimpleName(), (String)("No connection available for " + string2));
            return;
        }
        BluetoothGattService bluetoothGattService = bluetoothGatt.getService((UUID)((HashMap)this.b.get(string2)).get(UUID.fromString(string3)));
        if (bluetoothGattService == null) {
            Log.e((String)this.getClass().getSimpleName(), (String)"Cannot write attribute : Gatt service is null");
            this.a.onGattError(string2, TGATTERROR.SERVICE_NOT_AVAILABLE);
            return;
        }
        BluetoothGattCharacteristic bluetoothGattCharacteristic = bluetoothGattService.getCharacteristic(UUID.fromString(string3));
        bluetoothGattCharacteristic.setValue(byArray);
        bluetoothGatt.writeCharacteristic(bluetoothGattCharacteristic);
    }

    @Override
    public void setGattListener(INAOGattListener iNAOGattListener) {
        this.a = iNAOGattListener;
    }

    @Override
    public void clearConnections() {
        if (null != this.a) {
            this.a.clear();
        }
    }

    @Override
    public void setGattSettings(boolean bl, boolean bl2) {
        Log.i((String)this.getClass().getSimpleName(), (String)("autoconnect: " + bl + ", mainthread: " + bl2));
        this.b = bl2;
        this.a = bl;
    }

    public static String byteArrayToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (byte by : byArray) {
            int n = by & 0xFF;
            if (n < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString();
    }

    private void a(String string2) {
        if (this.a.containsKey(string2)) {
            ((BluetoothGatt)this.a.get(string2)).close();
            ((BluetoothGatt)this.a.get(string2)).disconnect();
            this.a.remove(string2);
        }
    }

    private class a
    extends BluetoothGattCallback {
        private a() {
        }

        public void onConnectionStateChange(final BluetoothGatt bluetoothGatt, int n, int n2) {
            Thread thread;
            super.onConnectionStateChange(bluetoothGatt, n, n2);
            Log.i((String)GattManager.TAG, (String)("OnConnectionStateChange: " + bluetoothGatt.getDevice().getAddress() + " Status: " + n));
            if (n == 133) {
                GattManager.this.a(bluetoothGatt.getDevice().getAddress());
                thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GattManager.this.a.onGattError(bluetoothGatt.getDevice().getAddress(), TGATTERROR.DEVICE_NOT_CONNECTED);
                    }
                });
                thread.start();
            }
            if (n2 == 2 && n == 0) {
                if (Build.VERSION.SDK_INT >= 21) {
                    bluetoothGatt.requestConnectionPriority(1);
                }
                Log.d((String)GattManager.TAG, (String)"Device connected! discovering services...");
                GattManager.this.a.put(bluetoothGatt.getDevice().getAddress(), bluetoothGatt);
                bluetoothGatt.discoverServices();
                Log.d((String)GattManager.TAG, (String)("Connection size: " + GattManager.this.a.size()));
            } else if (n2 == 0) {
                GattManager.this.a(bluetoothGatt.getDevice().getAddress());
                Log.i((String)GattManager.TAG, (String)("Disconnected: " + bluetoothGatt.getDevice().getAddress()));
                Log.d((String)GattManager.TAG, (String)("Connection size: " + GattManager.this.a.size()));
                thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            GattManager.this.a.onDisconnected(bluetoothGatt.getDevice().getAddress());
                        }
                        catch (Exception exception) {
                            Log.e((String)GattManager.TAG, (String)exception.getMessage());
                        }
                    }
                });
                thread.start();
            } else if (n2 == 1) {
                Log.d((String)GattManager.TAG, (String)("Connecting: " + bluetoothGatt.getDevice().getAddress()));
            } else {
                Log.i((String)GattManager.TAG, (String)"onGattError");
                thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GattManager.this.a.onGattError(bluetoothGatt.getDevice().getAddress(), TGATTERROR.DEVICE_NOT_CONNECTED);
                    }
                });
                thread.start();
            }
        }

        public void onServicesDiscovered(final BluetoothGatt bluetoothGatt, int n) {
            super.onServicesDiscovered(bluetoothGatt, n);
            if (n == 0) {
                Object object;
                Log.d((String)GattManager.TAG, (String)(bluetoothGatt.getServices().size() + " services discovered"));
                if (!GattManager.this.b.containsKey(bluetoothGatt.getDevice().getAddress())) {
                    object = new HashMap();
                    for (BluetoothGattService bluetoothGattService : bluetoothGatt.getServices()) {
                        for (BluetoothGattCharacteristic bluetoothGattCharacteristic : bluetoothGattService.getCharacteristics()) {
                            ((HashMap)object).put(bluetoothGattCharacteristic.getUuid(), bluetoothGattService.getUuid());
                        }
                    }
                    GattManager.this.b.put(bluetoothGatt.getDevice().getAddress(), object);
                }
                Log.d((String)GattManager.TAG, (String)"characteristics loaded");
                object = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GattManager.this.a.onConnected(bluetoothGatt.getDevice().getAddress());
                    }
                });
                ((Thread)object).start();
            } else {
                Log.w((String)GattManager.TAG, (String)("onServicesDiscovered received: " + n));
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GattManager.this.a.onGattError(bluetoothGatt.getDevice().getAddress(), TGATTERROR.UNABLE_TO_DISCOVER_SERVICES);
                    }
                });
                thread.start();
            }
        }

        public void onCharacteristicRead(final BluetoothGatt bluetoothGatt, final BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
            super.onCharacteristicRead(bluetoothGatt, bluetoothGattCharacteristic, n);
            if (null == bluetoothGattCharacteristic.getValue()) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GattManager.this.a.onGattError(bluetoothGatt.getDevice().getAddress(), TGATTERROR.UNKNOWN_ERROR);
                    }
                });
                thread.start();
                return;
            }
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    GattManager.this.a.onReadAttribute(bluetoothGatt.getDevice().getAddress(), bluetoothGattCharacteristic.getUuid().toString().toUpperCase(), bluetoothGattCharacteristic.getValue());
                }
            });
            thread.start();
        }

        public void onCharacteristicWrite(final BluetoothGatt bluetoothGatt, final BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
            super.onCharacteristicWrite(bluetoothGatt, bluetoothGattCharacteristic, n);
            if (n == 0) {
                Log.d((String)GattManager.TAG, (String)"onCharacteristicWrite");
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GattManager.this.a.onWriteAttribute(bluetoothGatt.getDevice().getAddress(), bluetoothGattCharacteristic.getUuid().toString().toUpperCase());
                    }
                });
                thread.start();
            } else {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GattManager.this.a.onGattError(bluetoothGatt.getDevice().getAddress(), TGATTERROR.UNKNOWN_ERROR);
                    }
                });
                thread.start();
            }
        }
    }
}

