/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.fota.service;

import android.app.Activity;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.widget.Toast;
import com.polestar.helpers.Log;
import com.polestar.naosdk.api.external.NAOERRORCODE;
import com.polestar.naosdk.api.external.NAOSensorsListener;
import com.polestar.naosdk.fota.BLESettings;
import com.polestar.naosdk.fota.BeaconConfiguration;
import com.polestar.naosdk.fota.BeaconFota;
import com.polestar.naosdk.fota.BeaconState;
import com.polestar.naosdk.fota.CampaignFota;
import com.polestar.naosdk.fota.CampaignState;
import com.polestar.naosdk.fota.listeners.NAOBeaconConfListener;
import com.polestar.naosdk.fota.service.NAOBeaconConfigurationManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class NAOBeaconConfigurationService
extends Service
implements NAOSensorsListener,
NAOBeaconConfListener {
    public NAOBeaconConfigurationManager a;
    private Handler a;
    private final IBinder mBinder = new BeaconConfigBinder();
    private ArrayList<BeaconConfServiceListener> a;
    private List<BeaconConfiguration> a;
    private boolean a = false;

    public List<BeaconConfiguration> getCurrentMissionConfigs() {
        return this.a;
    }

    public CampaignFota getMissionById(int n) {
        return (CampaignFota)((HashMap)((Object)this.a.a)).get(n);
    }

    public List<CampaignFota> getAssignedMissions() {
        if (this.a.a != null) {
            return new ArrayList<CampaignFota>(((HashMap)((Object)this.a.a)).values());
        }
        return null;
    }

    public CampaignState getMissionState(int n) {
        if (this.a.a != null) {
            return this.a.getMissionState(n);
        }
        return null;
    }

    public void loadFirmware(String string2, int n) {
        this.a.loadFirmware(string2, n);
    }

    public void onCreate() {
        super.onCreate();
        this.a = new NAOBeaconConfigurationManager(this.getApplicationContext(), this, this);
        this.a = new Handler(this.getMainLooper());
    }

    public int onStartCommand(Intent intent, int n, int n2) {
        return 2;
    }

    public void onDestroy() {
        if (null != this.a) {
            this.a.unregisterClient();
            this.a = false;
            Log.alwaysWarn(this.getClass().getSimpleName(), "Service stopped");
        }
    }

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    public void registerClientToNative(String string2, String string3, int n, String string4) {
        if (!this.a) {
            this.a.registerClient(string2, string3, n, string4);
            this.a = true;
        }
    }

    public void startMission(final int n, final boolean bl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                NAOBeaconConfigurationService.this.a.startMission(n, bl);
            }
        };
        this.a.post(runnable);
    }

    public void stopMission() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                NAOBeaconConfigurationService.this.a.stopMission();
            }
        };
        this.a.post(runnable);
    }

    public void loadMission(final int n) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                NAOBeaconConfigurationService.this.a.loadMission(n);
            }
        };
        this.a.post(runnable);
    }

    public void setBleSettings(final BLESettings bLESettings) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                NAOBeaconConfigurationService.this.a.setBLESettings(bLESettings);
            }
        };
        this.a.post(runnable);
    }

    public BLESettings getBLESettings() {
        return this.a.getBLEBleSettings();
    }

    public void sendMissionsReports() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                NAOBeaconConfigurationService.this.a.sendMissionsReports();
            }
        };
        this.a.post(runnable);
    }

    public BeaconFota getBeaconByID(int n) {
        if (this.a.b == null) {
            return null;
        }
        return (BeaconFota)((HashMap)((Object)this.a.b)).get(n);
    }

    public void setCurrentActivity(Activity activity) {
        this.a.setCurrentActivity(activity);
    }

    public void downloadMissions() {
        this.a.downloadMissions();
    }

    public void loadConfigurationsByMission(int n) {
        final ArrayList<Integer> arrayList = this.getMissionById(n).getBeaconToProcess();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (Integer n : arrayList) {
                    Integer n2 = ((BeaconFota)((HashMap)((Object)NAOBeaconConfigurationService.this.a.b)).get(n)).getConfId();
                    if (NAOBeaconConfigurationService.this.a(n2)) continue;
                    NAOBeaconConfigurationService.this.a.add(NAOBeaconConfigurationService.this.a.c.get(n2));
                }
                NAOBeaconConfigurationService.this.a();
            }
        };
        this.a.post(runnable);
    }

    private boolean a(Integer n) {
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            BeaconConfiguration beaconConfiguration = (BeaconConfiguration)iterator.next();
            if (beaconConfiguration.getId() != n.intValue()) continue;
            return true;
        }
        return false;
    }

    private void a() {
        Iterator iterator = ((ArrayList)((Object)this.a)).iterator();
        while (iterator.hasNext()) {
            BeaconConfServiceListener beaconConfServiceListener = (BeaconConfServiceListener)iterator.next();
            beaconConfServiceListener.onConfigsMissionLoaded();
        }
    }

    @Override
    public void onBeaconConfClientReady() {
        Iterator iterator = ((ArrayList)((Object)this.a)).iterator();
        while (iterator.hasNext()) {
            BeaconConfServiceListener beaconConfServiceListener = (BeaconConfServiceListener)iterator.next();
            beaconConfServiceListener.onServiceReady();
        }
    }

    @Override
    public void onMissionsDownloaded(int n) {
        Iterator iterator = ((ArrayList)((Object)this.a)).iterator();
        while (iterator.hasNext()) {
            BeaconConfServiceListener beaconConfServiceListener = (BeaconConfServiceListener)iterator.next();
            beaconConfServiceListener.onMissionsDownloaded(n);
        }
    }

    @Override
    public void onBeaconStatusChanged(int n, BeaconState beaconState) {
        Iterator iterator = ((ArrayList)((Object)this.a)).iterator();
        while (iterator.hasNext()) {
            BeaconConfServiceListener beaconConfServiceListener = (BeaconConfServiceListener)iterator.next();
            beaconConfServiceListener.onBeaconChanged(n, beaconState);
        }
    }

    @Override
    public void onMissionStatusChanged(int n, CampaignState campaignState) {
        Iterator iterator = ((ArrayList)((Object)this.a)).iterator();
        while (iterator.hasNext()) {
            BeaconConfServiceListener beaconConfServiceListener = (BeaconConfServiceListener)iterator.next();
            beaconConfServiceListener.onMissionStateChanged(n, campaignState);
        }
    }

    @Override
    public void onFlashLostDetected(int n) {
        Iterator iterator = ((ArrayList)((Object)this.a)).iterator();
        while (iterator.hasNext()) {
            BeaconConfServiceListener beaconConfServiceListener = (BeaconConfServiceListener)iterator.next();
            beaconConfServiceListener.onFlashLost(n);
        }
    }

    @Override
    public void requiresCompassCalibration() {
        Iterator iterator = ((ArrayList)((Object)this.a)).iterator();
        while (iterator.hasNext()) {
            BeaconConfServiceListener beaconConfServiceListener = (BeaconConfServiceListener)iterator.next();
            beaconConfServiceListener.onSensorMessage("Please calibrate compass ");
        }
    }

    @Override
    public void requiresWifiOn() {
        Iterator iterator = ((ArrayList)((Object)this.a)).iterator();
        while (iterator.hasNext()) {
            BeaconConfServiceListener beaconConfServiceListener = (BeaconConfServiceListener)iterator.next();
            beaconConfServiceListener.onSensorMessage("Please turn on Wifi");
        }
    }

    @Override
    public void requiresBLEOn() {
        Iterator iterator = ((ArrayList)((Object)this.a)).iterator();
        while (iterator.hasNext()) {
            BeaconConfServiceListener beaconConfServiceListener = (BeaconConfServiceListener)iterator.next();
            beaconConfServiceListener.onSensorMessage("Please turn on Bluetooth");
        }
    }

    @Override
    public void requiresLocationOn() {
        Iterator iterator = ((ArrayList)((Object)this.a)).iterator();
        while (iterator.hasNext()) {
            BeaconConfServiceListener beaconConfServiceListener = (BeaconConfServiceListener)iterator.next();
            beaconConfServiceListener.onSensorMessage("Please turn on Location");
        }
    }

    @Override
    public void onError(NAOERRORCODE nAOERRORCODE, String string2) {
        Log.alwaysError(this.getClass().getSimpleName(), nAOERRORCODE.toString() + string2);
        Toast.makeText((Context)this, (CharSequence)(nAOERRORCODE.toString() + string2), (int)1).show();
    }

    public static interface BeaconConfServiceListener {
        public void onMissionStateChanged(int var1, CampaignState var2);

        public void onConfigsMissionLoaded();

        public void onBeaconChanged(int var1, BeaconState var2);

        public void onServiceReady();

        public void onSensorMessage(String var1);

        public void onFlashLost(int var1);

        public void onMissionsDownloaded(int var1);
    }

    public class BeaconConfigBinder
    extends Binder {
        public NAOBeaconConfigurationService getService() {
            return NAOBeaconConfigurationService.this;
        }

        public void addObserver(BeaconConfServiceListener beaconConfServiceListener) {
            NAOBeaconConfigurationService.this.a.add(beaconConfServiceListener);
        }

        public void removerObserver(BeaconConfServiceListener beaconConfServiceListener) {
            NAOBeaconConfigurationService.this.a.remove(beaconConfServiceListener);
        }
    }
}

