/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.controllers;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationServices;
import com.polestar.helpers.Log;
import com.polestar.helpers.PrefHelper;
import com.polestar.helpers.c;
import com.polestar.helpers.h;
import com.polestar.models.GeofenceTransition;
import com.polestar.naosdk.api.GeofencePDB;
import com.polestar.naosdk.api.IGPSGeofencingManager;
import com.polestar.naosdk.api.external.NAOWakeUpRegistrationListener;
import com.polestar.naosdk.api.external.TNAOWAKEUP_REGISTER_STATUS;
import com.polestar.naosdk.managers.NaoContext;
import java.util.ArrayList;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class a
extends IGPSGeofencingManager {
    private Context a;
    private GoogleApiClient a;
    private List<Geofence> a;
    private boolean a;
    NAOWakeUpRegistrationListener a;
    private GoogleApiClient.OnConnectionFailedListener a;
    private GoogleApiClient.ConnectionCallbacks a = new GoogleApiClient.ConnectionCallbacks(){

        public void onConnected(Bundle bundle) {
            a.this.a = false;
            if (!a.this.b()) {
                String string2 = "Geofencing registration needs ACCESS_FINE_LOCATION permission ";
                Log.alwaysWarn(this.getClass().getName(), string2);
                a.this.a(TNAOWAKEUP_REGISTER_STATUS.REGISTER_ERROR, string2);
                return;
            }
            PendingIntent pendingIntent = a.this.a();
            GeofencingRequest geofencingRequest = new GeofencingRequest.Builder().addGeofences(a.this.a).build();
            PendingResult pendingResult = LocationServices.GeofencingApi.addGeofences(a.this.a, geofencingRequest, pendingIntent);
            pendingResult.setResultCallback((ResultCallback)new ResultCallback<Status>(){

                public void a(Status status) {
                    if (status.isSuccess()) {
                        PrefHelper.put(a.this.a, "android_geofencing_registered", true);
                        String string2 = "Android geofencing registered!";
                        a.this.a(TNAOWAKEUP_REGISTER_STATUS.REGISTERED, string2);
                        Log.alwaysWarn(this.getClass().getName(), string2);
                        Log.restricted(this.getClass().getName(), "ApiClient -- REGISTER SUCCESSFUL");
                    } else {
                        String string3 = "Registering failed: " + status.getStatusMessage();
                        a.this.a(TNAOWAKEUP_REGISTER_STATUS.REGISTER_ERROR, string3);
                        Log.alwaysError(this.getClass().getName(), string3);
                    }
                    a.this.a.disconnect();
                }

                public /* synthetic */ void onResult(Result result) {
                    this.a((Status)result);
                }
            });
        }

        public void onConnectionSuspended(int n) {
            String string2 = "onConnectionSuspended: " + n;
            a.this.a(TNAOWAKEUP_REGISTER_STATUS.REGISTER_ERROR, string2);
            Log.alwaysError(this.getClass().getName(), string2);
            Log.restricted(this.getClass().getName(), "ApiClient -- FAILED");
        }
    };
    private GoogleApiClient.ConnectionCallbacks b = new GoogleApiClient.ConnectionCallbacks(){

        public void onConnected(Bundle bundle) {
            if (!a.this.b()) {
                String string2 = "Geofencing registration needs ACCESS_FINE_LOCATION permission ";
                Log.alwaysWarn(this.getClass().getName(), string2);
                a.this.a(TNAOWAKEUP_REGISTER_STATUS.REGISTER_ERROR, string2);
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Geofence geofence : a.this.a) {
                arrayList.add(geofence.getRequestId());
            }
            if (arrayList.size() > 0) {
                PendingResult pendingResult = LocationServices.GeofencingApi.removeGeofences(a.this.a, arrayList);
                pendingResult.setResultCallback((ResultCallback)new ResultCallback<Status>(){

                    public void a(Status status) {
                        if (status.isSuccess()) {
                            PrefHelper.put(a.this.a, "android_geofencing_registered", false);
                            String string2 = "Geofences removed";
                            a.this.a(TNAOWAKEUP_REGISTER_STATUS.UNREGISTERED, string2);
                            Log.alwaysWarn(this.getClass().getName(), string2);
                        } else {
                            String string3 = "Removing geofencesGPS failed !";
                            a.this.a(TNAOWAKEUP_REGISTER_STATUS.UNREGISTER_ERROR, string3);
                            Log.alwaysError(this.getClass().getName(), string3);
                        }
                        a.this.a.disconnect();
                    }

                    public /* synthetic */ void onResult(Result result) {
                        this.a((Status)result);
                    }
                });
            }
        }

        public void onConnectionSuspended(int n) {
            String string2 = "onConnectionSuspended: " + n;
            a.this.a(TNAOWAKEUP_REGISTER_STATUS.UNREGISTER_ERROR, string2);
            Log.alwaysError(this.getClass().getName(), string2);
            Log.restricted(this.getClass().getName(), "ApiClient -- FAILED");
        }
    };

    public a(Context context) {
        this.a = context.getApplicationContext();
        this.a = new ArrayList();
    }

    public void a(NAOWakeUpRegistrationListener nAOWakeUpRegistrationListener) {
        this.a = nAOWakeUpRegistrationListener;
    }

    public void a(String string2) {
        if (string2 != null && string2.length() > 2) {
            List<GeofencePDB> list = this.a(string2);
            if (!list.isEmpty()) {
                this.b(list);
                this.a();
            } else {
                String string3 = "No GPS geofences to add found, app.json might be missing";
                this.a(TNAOWAKEUP_REGISTER_STATUS.REGISTER_ERROR, string3);
                Log.alwaysWarn(this.getClass().getName(), string3);
            }
        }
    }

    public void a(List<GeofencePDB> list) {
        if (!list.isEmpty()) {
            this.b(list);
            this.a();
        } else {
            String string2 = "No GPS Geofences to register ...";
            this.a(TNAOWAKEUP_REGISTER_STATUS.REGISTER_ERROR, string2);
            Log.alwaysWarn(this.getClass().getName(), string2);
        }
    }

    public void b(String string2) {
        if (string2 != null && string2.length() > 2) {
            List<GeofencePDB> list = this.a(string2);
            if (!list.isEmpty()) {
                this.b(list);
                this.b();
            } else {
                String string3 = "No GPS geofences to delete found , app.json might be missing";
                this.a(TNAOWAKEUP_REGISTER_STATUS.UNREGISTER_ERROR, string3);
                Log.alwaysWarn(this.getClass().getName(), string3);
            }
        }
    }

    public boolean a(Context context) {
        return PrefHelper.get(context, "android_geofencing_registered", false);
    }

    public boolean a() {
        return h.a(this.a, "com.polestar.naosdk.controllers.AndroidGeofencingService");
    }

    private void a(TNAOWAKEUP_REGISTER_STATUS tNAOWAKEUP_REGISTER_STATUS, String string2) {
        if (this.a != null) {
            this.a.onStatusChanged(tNAOWAKEUP_REGISTER_STATUS, string2);
        }
    }

    private void a() {
        if (this.a) {
            Log.alwaysWarn(this.getClass().getName(), "Already trying to connect to Google API client. Abort geofences registering...");
            return;
        }
        Log.alwaysWarn(this.getClass().getName(), "registering Geofences:\n enabled: " + this.a());
        if (!this.b()) {
            String string2 = "Geofencing registration needs ACCESS_FINE_LOCATION permission ";
            Log.alwaysWarn(this.getClass().getName(), string2);
            this.a(TNAOWAKEUP_REGISTER_STATUS.REGISTER_ERROR, string2);
            return;
        }
        if (!this.a()) {
            String string3 = "AndroidGeofencingService must be declared in the application Manifest.xml";
            Log.alwaysWarn(this.getClass().getName(), string3);
            this.a(TNAOWAKEUP_REGISTER_STATUS.REGISTER_ERROR, string3);
            return;
        }
        Log.alwaysWarn(this.getClass().getName(), "Registering Android Geofences .....");
        if (!this.a.isEmpty()) {
            this.a(this.a);
        } else {
            String string4 = "No GPS Geofences to register ...";
            this.a(TNAOWAKEUP_REGISTER_STATUS.REGISTER_ERROR, string4);
            Log.alwaysWarn(this.getClass().getName(), string4);
        }
    }

    private void b() {
        if (this.a) {
            Log.alwaysWarn(this.getClass().getName(), "Already trying to connect to Google API client. Abort geofences unregistering...");
            return;
        }
        if (!this.b()) {
            String string2 = "Geofencing unregistration needs ACCESS_FINE_LOCATION permission ";
            Log.alwaysWarn(this.getClass().getName(), string2);
            this.a(TNAOWAKEUP_REGISTER_STATUS.UNREGISTER_ERROR, string2);
            return;
        }
        this.a(this.b);
    }

    private List<GeofencePDB> a(String string2) {
        ArrayList<GeofencePDB> arrayList = new ArrayList<GeofencePDB>();
        if (string2 != null && string2.length() > 2 && this.a.getExternalFilesDir(".nao") != null) {
            arrayList.addAll(NaoContext.getGeofenceGPS(this.a.getExternalFilesDir(".nao").getAbsolutePath(), string2));
        }
        return arrayList;
    }

    public static Geofence a(GeofencePDB geofencePDB) {
        if (geofencePDB.getRadius() > 0) {
            Geofence geofence = new Geofence.Builder().setExpirationDuration(-1L).setTransitionTypes(3).setRequestId(geofencePDB.getName()).setCircularRegion((double)geofencePDB.getLat(), (double)geofencePDB.getLon(), (float)geofencePDB.getRadius()).build();
            return geofence;
        }
        return null;
    }

    private void b(List<GeofencePDB> list) {
        for (GeofencePDB geofencePDB : list) {
            Geofence geofence = com.polestar.naosdk.controllers.a.a(geofencePDB);
            if (geofence == null) continue;
            this.a.add(geofence);
        }
    }

    private boolean b() {
        return c.a(this.a, "android.permission.ACCESS_FINE_LOCATION");
    }

    private PendingIntent a() {
        Intent intent = new Intent(this.a, GeofenceTransition.class);
        return PendingIntent.getService((Context)this.a, (int)0, (Intent)intent, (int)0x8000000);
    }

    private void a(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.a = new GoogleApiClient.Builder(this.a).addApi(LocationServices.API).addConnectionCallbacks(connectionCallbacks).addOnConnectionFailedListener(this.a).build();
        this.a.connect();
        this.a = true;
    }

    @Override
    public void registerGPSGeofences(ArrayList<GeofencePDB> arrayList) {
        Log.alwaysWarn(this.getClass().getName(), "Registering GPS Geofence from native...");
        this.a(arrayList);
    }
}

