/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.controllers;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.IBinder;
import android.support.annotation.Nullable;
import com.polestar.helpers.Log;
import com.polestar.helpers.PrefHelper;
import com.polestar.helpers.h;
import com.polestar.naosdk.api.external.NAOERRORCODE;
import com.polestar.naosdk.api.external.NAOLocationHandle;
import com.polestar.naosdk.api.external.NAOLocationListener;
import com.polestar.naosdk.api.external.NAOSensorsListener;
import com.polestar.naosdk.api.external.NAOWakeUpNotifier;
import com.polestar.naosdk.api.external.TNAOFIXSTATUS;
import com.polestar.naosdk.api.external.TPOWERMODE;
import com.polestar.naosdk.managers.NaoServiceManager;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AndroidGeofencingService
extends Service
implements NAOLocationListener,
NAOSensorsListener {
    private NAOLocationHandle a;
    private NAOWakeUpNotifier a;
    private static boolean a = false;
    private boolean b = false;

    public static boolean isInsideOSGeofence() {
        return a;
    }

    public int onStartCommand(Intent intent, int n, int n2) {
        String string2 = intent.getStringExtra("event");
        if (string2 != null) {
            if (string2.equalsIgnoreCase("enter")) {
                if (!a) {
                    this.a();
                    a = true;
                }
            } else if (string2.equalsIgnoreCase("exit")) {
                a = false;
                this.b();
            }
        }
        return 2;
    }

    public void onDestroy() {
        Log.writeToLog(this.getClass().getName(), "AndroidGeofencingService >> onDestroy");
        super.onDestroy();
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    protected void a() {
        NAOWakeUpNotifier nAOWakeUpNotifier;
        Log.writeToLog(this.getClass().getName(), "AndroidGeofencingService >> onEnter");
        if (this.c()) {
            NaoServiceManager.acquireWakeLock(this.getApplicationContext());
        }
        if ((nAOWakeUpNotifier = this.a()) != null) {
            nAOWakeUpNotifier.onEnterGPSArea();
            if (!this.b) {
                this.a(this, this);
            }
        }
    }

    @Override
    public void onEnterSite(String string2) {
        this.b = true;
        Log.restricted(this.getClass().getName(), "onEnterSite: Stop location and wake the app up");
        NAOWakeUpNotifier nAOWakeUpNotifier = this.a();
        if (nAOWakeUpNotifier != null) {
            nAOWakeUpNotifier.onEnterBeaconArea();
            this.e();
        }
    }

    protected void b() {
        Log.writeToLog(this.getClass().getName(), "AndroidGeofencingService >> onExit");
        NAOWakeUpNotifier nAOWakeUpNotifier = this.a();
        if (nAOWakeUpNotifier != null) {
            nAOWakeUpNotifier.onExitGPSArea();
        }
        if (!this.b()) {
            this.d();
        } else if (this.a == null) {
            Log.writeToLog(this.getClass().getName(), "AndroidGeofencingService >> checkExitCoverage");
            this.a(null, null);
            this.c();
        }
    }

    private boolean b() {
        if (NaoServiceManager.getService() != null && NaoServiceManager.getService().getNaoContext() != null) {
            return NaoServiceManager.getService().getNaoContext().a.hasTriggeredEnterSite();
        }
        return false;
    }

    private boolean c() {
        if (NaoServiceManager.getService() != null && NaoServiceManager.getService().getNaoContext() != null) {
            return NaoServiceManager.getService().getNaoContext().a.hasServiceClients();
        }
        return false;
    }

    private void c() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Log.writeToLog(this.getClass().getName(), "AndroidGeofencingService >> waitForNaoServiceToBeStarted");
                if (h.a()) {
                    Log.writeToLog(this.getClass().getName(), "AndroidGeofencingService >> wait for exit site");
                    while (!a) {
                        if (!AndroidGeofencingService.this.b()) {
                            Log.writeToLog(this.getClass().getName(), "AndroidGeofencingService >> onExitCoverage");
                            AndroidGeofencingService.this.b = false;
                            AndroidGeofencingService.this.d();
                            break;
                        }
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                    if (a) {
                        Log.writeToLog(this.getClass().getName(), "AndroidGeofencingService >> isInsideOSGeofence now");
                        AndroidGeofencingService.this.e();
                    }
                } else {
                    AndroidGeofencingService.this.onError(NAOERRORCODE.GENERIC_ERROR, "Can't instantiate NaoContext");
                }
            }
        }).start();
    }

    private void d() {
        NAOWakeUpNotifier nAOWakeUpNotifier = this.a();
        if (nAOWakeUpNotifier != null) {
            nAOWakeUpNotifier.onExitCoverage();
        }
        NaoServiceManager.releaseWakeLock();
        this.e();
        Log.writeToLog(this.getClass().getName(), "AndroidGeofencingService >> stopSelf");
        this.stopSelf();
    }

    @Override
    public void onExitSite(String string2) {
        this.b = false;
        NAOWakeUpNotifier nAOWakeUpNotifier = this.a();
        if (nAOWakeUpNotifier != null) {
            nAOWakeUpNotifier.onExitBeaconArea();
        }
        if (!a) {
            this.d();
        }
    }

    private NAOWakeUpNotifier a() {
        if (this.a == null) {
            try {
                String string2 = PrefHelper.get(this.getApplicationContext(), "[logger]wake_up_notifier", null);
                if (string2 != null) {
                    Class<?> clazz = Class.forName(string2);
                    this.a = (NAOWakeUpNotifier)clazz.newInstance();
                    this.a.setContext((Context)this);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        return this.a;
    }

    private void a(NAOLocationListener nAOLocationListener, NAOSensorsListener nAOSensorsListener) {
        String string2 = PrefHelper.get(this.getApplicationContext(), "[logger]service_name", null);
        Log.writeToLog(this.getClass().getName(), "AndroidGeofencingService >> startRecoveryLocation : " + string2 + " (client -> " + (nAOLocationListener != null) + ")");
        if (string2 != null) {
            try {
                Class<?> clazz = Class.forName(string2);
                this.a = new NAOLocationHandle((Context)this, clazz, PrefHelper.get(this.getApplicationContext(), "[logger]logs_app_key", null), nAOLocationListener, nAOSensorsListener);
                this.a.setPowerMode(TPOWERMODE.LOW);
                this.a.start();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
    }

    private void e() {
        if (this.a != null) {
            this.a.stop();
            this.a = null;
            Log.writeToLog(this.getClass().getName(), "Recovery location stopped ...");
        } else {
            Log.alwaysWarn(this.getClass().getName(), "Cannot stop recovery location because not instantiated");
        }
    }

    @Override
    public void onError(NAOERRORCODE nAOERRORCODE, String string2) {
        Log.alwaysError(AndroidGeofencingService.class.getName(), "Error: " + (Object)((Object)nAOERRORCODE) + " " + string2);
    }

    @Override
    public void onLocationChanged(Location location) {
        Log.alwaysWarn(this.getClass().getName(), "Recovery Service Loc " + location.getLongitude() + ", " + location.getLatitude());
    }

    @Override
    public void onLocationStatusChanged(TNAOFIXSTATUS tNAOFIXSTATUS) {
        Log.restricted(this.getClass().getName(), "Recovery Service Loc Status " + tNAOFIXSTATUS.toString());
    }

    @Override
    public void requiresCompassCalibration() {
    }

    @Override
    public void requiresWifiOn() {
    }

    @Override
    public void requiresBLEOn() {
    }

    @Override
    public void requiresLocationOn() {
    }
}

