/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.api.external;

import android.content.Context;
import android.support.annotation.NonNull;
import com.polestar.helpers.PrefHelper;
import com.polestar.naosdk.api.TSENSORTYPE;
import com.polestar.naosdk.api.external.NAOException;
import com.polestar.naosdk.api.external.NAOWakeUpNotifier;
import com.polestar.naosdk.api.external.NAOWakeUpRegistrationListener;
import com.polestar.naosdk.api.external.TPOWERMODE;
import com.polestar.naosdk.controllers.a;
import com.polestar.naosdk.managers.NaoContext;
import com.polestar.naosdk.managers.NaoServiceManager;

public final class NAOServicesConfig {
    public static final String[] BASIC_PERMISSIONS = new String[]{"android.permission.ACCESS_FINE_LOCATION"};

    public static void setRootURL(String string2) {
        NaoContext.a = string2;
        if (NaoServiceManager.getService() != null && NaoServiceManager.getService().getNaoContext() != null) {
            NaoServiceManager.getService().getNaoContext().setRootURL(string2);
        }
    }

    public static String getRootURL() {
        return NaoContext.getRootURL();
    }

    public static TPOWERMODE getPowerMode() {
        if (NaoServiceManager.getService() == null || NaoServiceManager.getService().getNaoContext() == null) {
            return TPOWERMODE.LOW;
        }
        return NaoServiceManager.getService().getNaoContext().getPowerMode();
    }

    public static String getSoftwareVersion() {
        return NaoContext.getSoftwareVersion();
    }

    public static void enableOnSiteWakeUp(@NonNull Context context, @NonNull String string2, @NonNull Class<? extends NAOWakeUpNotifier> clazz, NAOWakeUpRegistrationListener nAOWakeUpRegistrationListener) {
        PrefHelper.put(context, "[logger]wake_up_notifier", clazz.getName());
        a a2 = new a(context);
        a2.a(nAOWakeUpRegistrationListener);
        a2.a(string2);
    }

    public static void disableOnSiteWakeUp(@NonNull Context context, @NonNull String string2, NAOWakeUpRegistrationListener nAOWakeUpRegistrationListener) {
        PrefHelper.put(context, "[logger]wake_up_notifier", null);
        a a2 = new a(context);
        a2.a(nAOWakeUpRegistrationListener);
        a2.b(string2);
    }

    public static boolean isWakeUpNotifierRegistered(Context context) {
        return null != PrefHelper.get(context, "[logger]wake_up_notifier", null);
    }

    public static void uploadNAOLogInfo(String string2) throws NAOException {
        NAOServicesConfig.getNaoContextOrThrow().a.uploadNAOLogInfo(string2);
    }

    public static void startLoggingMeasurements() throws NAOException {
        NAOServicesConfig.getNaoContextOrThrow().a.getMeasureLogger().startLoggingMeasurements("", true);
    }

    public static void stopLoggingMeasurements() throws NAOException {
        NAOServicesConfig.getNaoContextOrThrow().a.getMeasureLogger().stopLoggingMeasurements();
    }

    public static void setSensorBypass(String string2, boolean bl) throws NAOException {
        NAOServicesConfig.getNaoContextOrThrow().a.setSensorBypass(TSENSORTYPE.valueOf(string2), bl);
    }

    public static NaoContext getNaoContextOrThrow() throws NAOException {
        if (NaoServiceManager.getService() == null || NaoServiceManager.getService().getNaoContext() == null) {
            throw new NAOException("No NaoContext instance: you must first instantiate a service handle.");
        }
        return NaoServiceManager.getService().getNaoContext();
    }
}

