/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.api;

import com.polestar.naosdk.api.external.NAOERRORCODE;
import com.polestar.naosdk.fota.BeaconState;
import com.polestar.naosdk.fota.CampaignState;
import com.polestar.naosdk.fota.INAOBeaconConfCommands;
import com.polestar.naosdk.gatt.GattAction;
import com.polestar.naosdk.gatt.INAOGattListener;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class INAOBeaconConfigSynchroClient {
    public abstract void clearGatt();

    public abstract void setGattSettings(boolean var1, boolean var2);

    public abstract void onActionToExecute(GattAction var1);

    public abstract void setGattListener(INAOGattListener var1);

    public abstract void setBeaconConfClient(INAOBeaconConfCommands var1);

    public abstract void onMissionsDownloaded(int var1);

    public abstract void onMissionStatusChanged(int var1, CampaignState var2);

    public abstract void onBeaconStatusChanged(int var1, BeaconState var2);

    public abstract void onBeaconFlashLostDetected(int var1);

    public abstract void onError(NAOERRORCODE var1, String var2);

    public abstract String getClourdURL();

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static final class CppProxy
    extends INAOBeaconConfigSynchroClient {
        private final long nativeRef;
        private final AtomicBoolean a = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = l;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean bl = this.a.getAndSet(true);
            if (!bl) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void clearGatt() {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_clearGatt(this.nativeRef);
        }

        private native void native_clearGatt(long var1);

        @Override
        public void setGattSettings(boolean bl, boolean bl2) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setGattSettings(this.nativeRef, bl, bl2);
        }

        private native void native_setGattSettings(long var1, boolean var3, boolean var4);

        @Override
        public void onActionToExecute(GattAction gattAction) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_onActionToExecute(this.nativeRef, gattAction);
        }

        private native void native_onActionToExecute(long var1, GattAction var3);

        @Override
        public void setGattListener(INAOGattListener iNAOGattListener) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setGattListener(this.nativeRef, iNAOGattListener);
        }

        private native void native_setGattListener(long var1, INAOGattListener var3);

        @Override
        public void setBeaconConfClient(INAOBeaconConfCommands iNAOBeaconConfCommands) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setBeaconConfClient(this.nativeRef, iNAOBeaconConfCommands);
        }

        private native void native_setBeaconConfClient(long var1, INAOBeaconConfCommands var3);

        @Override
        public void onMissionsDownloaded(int n) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_onMissionsDownloaded(this.nativeRef, n);
        }

        private native void native_onMissionsDownloaded(long var1, int var3);

        @Override
        public void onMissionStatusChanged(int n, CampaignState campaignState) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_onMissionStatusChanged(this.nativeRef, n, campaignState);
        }

        private native void native_onMissionStatusChanged(long var1, int var3, CampaignState var4);

        @Override
        public void onBeaconStatusChanged(int n, BeaconState beaconState) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_onBeaconStatusChanged(this.nativeRef, n, beaconState);
        }

        private native void native_onBeaconStatusChanged(long var1, int var3, BeaconState var4);

        @Override
        public void onBeaconFlashLostDetected(int n) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_onBeaconFlashLostDetected(this.nativeRef, n);
        }

        private native void native_onBeaconFlashLostDetected(long var1, int var3);

        @Override
        public void onError(NAOERRORCODE nAOERRORCODE, String string2) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_onError(this.nativeRef, nAOERRORCODE, string2);
        }

        private native void native_onError(long var1, NAOERRORCODE var3, String var4);

        @Override
        public String getClourdURL() {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_getClourdURL(this.nativeRef);
        }

        private native String native_getClourdURL(long var1);
    }
}

