/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.helpers;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.polestar.helpers.Log;
import com.polestar.helpers.i;
import com.polestar.naosdk.api.IHttpHelper;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Cache;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class HttpHelper {
    public static final MediaType FILE = MediaType.parse((String)"application/octet-stream");
    public static final MediaType TXT = MediaType.parse((String)"text/plain; charset=utf-8");

    public static OkHttpClient getClient(Context context) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (context != null) {
            File file = new File(context.getCacheDir(), "OkHttpCache");
            int n = 0x100000;
            builder.cache(new Cache(file, (long)n));
        }
        return builder.build();
    }

    public static OkHttpClient getHttpsClient(Context context) {
        Object object;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (context != null) {
            object = new File(context.getCacheDir(), "OkHttpCache");
            int n = 0x100000;
            builder.cache(new Cache((File)object, (long)n));
        }
        object = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                try {
                    x509CertificateArray[0].checkValidity();
                }
                catch (Exception exception) {
                    throw new CertificateException("Certificate not valid or trusted.");
                }
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, new TrustManager[]{object}, null);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            return builder.sslSocketFactory(sSLSocketFactory, (X509TrustManager)object).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            }).build();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (KeyManagementException keyManagementException) {
            keyManagementException.printStackTrace();
        }
        return null;
    }

    public static Response uploadFile(String string, String string2, String ... stringArray) {
        File file = new File(string);
        if (!file.exists()) {
            Log.alwaysError("HttpHelper", "File not found: " + string);
            return null;
        }
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder.setType(MultipartBody.FORM);
        if (stringArray.length % 2 == 0) {
            for (int j = 0; j < stringArray.length; j += 2) {
                builder.addFormDataPart(stringArray[j], stringArray[j + 1]);
            }
        }
        builder.addFormDataPart("file", file.getName(), RequestBody.create((MediaType)FILE, (File)file));
        Request request = new Request.Builder().url(string2).post((RequestBody)builder.build()).build();
        try {
            Response response = HttpHelper.getHttpsClient(null).newCall(request).execute();
            return response;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Response downloadFile(String string, String string2) {
        return HttpHelper.downloadFile(string, string2, null);
    }

    public static Response downloadFile(String string, String string2, String string3) {
        Response response = null;
        Request.Builder builder = new Request.Builder();
        builder.url(string).get();
        if (string3 != null && !string3.isEmpty()) {
            builder.addHeader("If-Modified-Since", string3);
        }
        Request request = builder.build();
        try {
            response = HttpHelper.getHttpsClient(null).newCall(request).execute();
            if (response != null && response.code() >= 200 && response.code() <= 300) {
                File file = new File(string2);
                if (!file.exists()) {
                    file.createNewFile();
                }
                BufferedSink bufferedSink = Okio.buffer((Sink)Okio.sink((File)file));
                bufferedSink.writeAll((Source)response.body().source());
                response.body().close();
                bufferedSink.close();
            }
            return response;
        }
        catch (IOException iOException) {
            Log.alwaysError("HttpHelper", "Error downloading file");
            return null;
        }
    }

    public static String postText(String string, String ... stringArray) {
        MultipartBody.Builder builder;
        String string2 = "";
        Request.Builder builder2 = new Request.Builder().url(string);
        if (stringArray.length > 1) {
            builder = new MultipartBody.Builder();
            builder.setType(MultipartBody.FORM);
            if (stringArray.length % 2 == 0) {
                for (int j = 0; j < stringArray.length; j += 2) {
                    String string3 = stringArray[j];
                    String string4 = stringArray[j + 1];
                    builder.addFormDataPart(string3, string4);
                }
            }
            builder2.post((RequestBody)builder.build());
        } else {
            builder2.post(RequestBody.create((MediaType)TXT, (String)""));
        }
        try {
            builder = HttpHelper.getHttpsClient(null).newCall(builder2.build()).execute();
            if (builder != null && builder.code() >= 200 && builder.code() <= 300) {
                string2 = builder.body().string();
            }
        }
        catch (Exception exception) {
            return string2;
        }
        return string2;
    }

    public static Response get(String string) {
        Request request = new Request.Builder().url(string).get().build();
        try {
            Response response = HttpHelper.getHttpsClient(null).newCall(request).execute();
            return response;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static String getText(String string) {
        Object var1_1 = null;
        Response response = HttpHelper.get(string);
        if (response != null) {
            try {
                return response.body().string();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static boolean checkHttpResponse(Response response) {
        if (response != null && response.code() >= 200 && response.code() <= 300) {
            return true;
        }
        try {
            Log.writeToLog("HttpHelper", "Response body: " + response.body().string());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    public static boolean isOnline(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnectedOrConnecting();
    }

    public class a
    extends IHttpHelper {
        @Override
        public int sendFile(String string, String string2) {
            return HttpHelper.uploadFile(string, string2, new String[0]).code();
        }

        @Override
        public int getFile(String string, String string2) {
            return HttpHelper.downloadFile(string, string2).code();
        }

        @Override
        public int getFileIfModified(String string, String string2, String string3) {
            return HttpHelper.downloadFile(string, string2, string3).code();
        }

        @Override
        public String getText(String string) {
            return HttpHelper.getText(string);
        }

        @Override
        public String postText(String string, HashMap<String, String> hashMap) {
            String[] stringArray = new String[2 * hashMap.size()];
            int n = 0;
            for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                stringArray[2 * n] = entry.getKey();
                stringArray[2 * n + 1] = entry.getValue();
                ++n;
            }
            return HttpHelper.postText(string, stringArray);
        }

        @Override
        public boolean zipAndUploadFiles(ArrayList<String> arrayList, String string, String string2, String string3, ArrayList<String> arrayList2) {
            try {
                i.a(arrayList, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            String[] stringArray = new String[arrayList2.size()];
            stringArray = arrayList2.toArray(stringArray);
            Response response = HttpHelper.uploadFile(string, string2, stringArray);
            String string4 = arrayList2.get(2);
            if (response != null && response.code() >= 200 && response.code() <= 300) {
                int n = string4.indexOf("$");
                String string5 = string.substring(string.lastIndexOf(47) + 1);
                String string6 = string4.substring(0, n) + string5;
                String string7 = HttpHelper.postText(string3, "file", string6);
                return string7.contains("success");
            }
            return false;
        }
    }
}

