/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.output;

import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.util.Objects;

public class Marker {
    private final Output output;
    private final Output.Verbosity verbosity;
    private final StringBuilder message;

    public Marker(Output output, Output.Verbosity verbosity) {
        this.output = output;
        this.verbosity = verbosity;
        this.message = new StringBuilder();
    }

    public Marker word(Intent intent, String word) {
        Objects.requireNonNull(intent, "intent");
        Objects.requireNonNull(word, "word");
        this.message.append(word);
        return this;
    }

    public Marker emphasize(String word) {
        return this.word(Intent.EMPHASIZE, word);
    }

    public Marker outstanding(String word) {
        return this.word(Intent.OUTSTANDING, word);
    }

    public Marker normal(String word) {
        return this.word(Intent.NORMAL, word);
    }

    public Marker detail(String word) {
        return this.word(Intent.DETAIL, word);
    }

    public Marker unimportant(String word) {
        return this.word(Intent.UNIMPORTANT, word);
    }

    public Marker scary(String word) {
        return this.word(Intent.SCARY, word);
    }

    public Marker bloody(String word) {
        return this.word(Intent.BLOODY, word);
    }

    public void say(Object ... params) {
        if (this.output.isHeard(this.verbosity)) {
            this.output.handle(this.verbosity, this.toString(), params);
        }
    }

    public String toString() {
        String result = this.message.toString();
        this.message.setLength(0);
        return result;
    }

    public static enum Intent {
        EMPHASIZE,
        OUTSTANDING,
        NORMAL,
        DETAIL,
        UNIMPORTANT,
        SCARY,
        BLOODY;

    }
}

