/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal.jdom;

import eu.maveniverse.maven.toolbox.shared.internal.jdom.JDomCfg;
import eu.maveniverse.maven.toolbox.shared.internal.jdom.JDomContentHelper;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Parent;
import org.jdom2.Text;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.filter.Filters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JDomUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JDomUtils.class);

    private JDomUtils() {
    }

    public static void addElement(Element element, Element root) {
        JDomUtils.addElement(element, root, JDomUtils.calcNewElementIndex(element.getName(), root));
    }

    public static void addElement(Element element, Element root, int index) {
        root.addContent(index, (Content)element);
        String prependingElementName = ((Element)root.getContent(Math.max(0, index - 1))).getName();
        if (JDomUtils.isBlankLineBetweenElements(prependingElementName, element.getName(), root)) {
            root.addContent(index, (Content)new Text("\n\n" + JDomUtils.detectIndentation(root)));
        } else {
            root.addContent(index, (Content)new Text("\n" + JDomUtils.detectIndentation(root)));
        }
        JDomUtils.resetIndentations(root, JDomUtils.detectIndentation(root));
        JDomUtils.resetIndentations(element, JDomUtils.detectIndentation(root) + "  ");
    }

    public static int getElementIndex(Element element, Element root) {
        return root.indexOf((Content)element);
    }

    private static int getLastElementIndex(Element root) {
        List elements = root.getContent((Filter)new ElementFilter());
        int size = elements.size();
        return size > 0 ? root.indexOf((Content)elements.get(size - 1)) : -1;
    }

    public static Element insertNewElement(String name, Element root) {
        return JDomUtils.insertNewElement(name, root, JDomUtils.calcNewElementIndex(name, root));
    }

    public static Element insertNewElement(String name, Element root, int index) {
        String indent = JDomUtils.detectIndentation(root);
        Element newElement = new Element(name, root.getNamespace());
        newElement.addContent("\n" + indent);
        root.addContent(index, (Content)newElement);
        String prependingElementName = ((Element)root.getContent(Math.max(0, index - 1))).getName();
        if (JDomUtils.isBlankLineBetweenElements(prependingElementName, name, root)) {
            root.addContent(index, (Content)new Text("\n\n" + indent));
        } else {
            root.addContent(index, (Content)new Text("\n" + indent));
        }
        return newElement;
    }

    public static Element insertNewNestedElements(Element jdomParent, String ... tags) {
        for (String tag : tags) {
            jdomParent = JDomUtils.insertNewElement(tag, jdomParent);
        }
        return jdomParent;
    }

    public static void insertContentElement(Element jdomParent, String tag, String text) {
        if (text != null) {
            Element jdomVersion = JDomUtils.insertNewElement(tag, jdomParent);
            jdomVersion.setContent((Content)new Text(text));
        }
    }

    private static int calcNewElementIndex(String name, Element root) {
        int addIndex = 0;
        List<String> elementOrder = JDomCfg.getInstance().getElementOrder(root.getName());
        if (elementOrder == null) {
            addIndex = Math.max(0, JDomUtils.getLastElementIndex(root) + 1);
        } else {
            for (int i = elementOrder.indexOf(name) - 1; i >= 0; --i) {
                Element addAfterElement;
                String addAfterElementName = elementOrder.get(i);
                if (addAfterElementName.isEmpty() || (addAfterElement = root.getChild(addAfterElementName, root.getNamespace())) == null) continue;
                addIndex = root.indexOf((Content)addAfterElement) + 1;
                break;
            }
        }
        return addIndex;
    }

    private static boolean isBlankLineBetweenElements(String element1, String element2, Element root) {
        List<String> elementOrder = JDomCfg.getInstance().getElementOrder(root.getName());
        if (elementOrder != null) {
            return elementOrder.subList(elementOrder.indexOf(element1), elementOrder.indexOf(element2)).contains("");
        }
        return false;
    }

    public static String detectIndentation(Element element) {
        Iterator iterator = element.getContent(Filters.textOnly()).iterator();
        while (iterator.hasNext()) {
            String text = ((Text)iterator.next()).getText();
            int lastLsIndex = StringUtils.lastIndexOfAny((String)text, (String[])new String[]{"\n", "\r"});
            if (lastLsIndex <= -1) continue;
            String indent = text.substring(lastLsIndex + 1);
            if (iterator.hasNext()) {
                return indent;
            }
            return indent + "  ";
        }
        Parent parent = element.getParent();
        if (parent instanceof Element) {
            return JDomUtils.detectIndentation((Element)parent) + "  ";
        }
        return "";
    }

    public static Element newDetachedElement(String name, Element parent) {
        Element newElement = new Element(name, parent.getNamespace());
        newElement.addContent("\n" + JDomUtils.detectIndentation(parent));
        return newElement;
    }

    public static Element getChildElement(String name, Element parent) {
        return parent.getChild(name, parent.getNamespace());
    }

    public static String getChildElementTextTrim(String name, Element parent) {
        Element child = JDomUtils.getChildElement(name, parent);
        if (child == null) {
            return null;
        }
        String text = child.getTextTrim();
        return "null".equals(text) ? null : text;
    }

    public static void removeChildElement(Element parent, Element removeChild) {
        int index = parent.indexOf((Content)removeChild);
        parent.removeContent(index--);
        if (index >= 0 && parent.getContent(index) instanceof Text) {
            parent.removeContent(index);
        }
        removeChild.detach();
    }

    public static void removeChildAndItsCommentFromContent(Element parent, Content removeChild) {
        int index = parent.indexOf(removeChild);
        if (index >= 0) {
            LOG.debug("");
            LOG.debug("index [{}] => REMOVE: {}", (Object)index, (Object)JDomContentHelper.contentAsString(parent.getContent(index)));
            parent.removeContent(index);
            Content elementToCheck = JDomContentHelper.getContentWithIndex(--index, parent);
            if (JDomContentHelper.isNewline(elementToCheck) && JDomUtils.simpleRemoveAtIndex(index, parent)) {
                int prevIndex;
                int newIndex = index - 1;
                do {
                    prevIndex = newIndex;
                } while ((newIndex = JDomUtils.removeContentAtIndexIfContentIsComment(newIndex, parent)) >= 0 && newIndex != prevIndex);
            } else if (JDomContentHelper.isMultiNewLine(elementToCheck)) {
                JDomUtils.removeFirstNewLineFromMultiline(parent.indexOf(elementToCheck), parent);
            }
            removeChild.detach();
        }
    }

    private static boolean simpleRemoveAtIndex(int index, Element parent) {
        if (!JDomContentHelper.isIndexValid(index, parent)) {
            return false;
        }
        Content contentToRemove = parent.getContent(index);
        LOG.debug("remove content => {} from parent tag: <{}>", (Object)JDomContentHelper.contentAsString(contentToRemove), (Object)parent.getName());
        parent.removeContent(index);
        contentToRemove.detach();
        return true;
    }

    static void simpleRemoveAtIndex(Content content) {
        Element parent = content.getParentElement();
        int index = parent.indexOf(content);
        Content contentToRemove = parent.getContent(index);
        LOG.debug("remove content => {} from parent tag: <{}>", (Object)JDomContentHelper.contentAsString(contentToRemove), (Object)parent.getName());
        parent.removeContent(index);
        contentToRemove.detach();
    }

    private static void removeFirstNewLineFromMultiline(int index, Element parent) {
        if (!JDomContentHelper.isIndexValid(index, parent)) {
            return;
        }
        Content contentToRemove = parent.getContent(index);
        LOG.debug("       Content to remove  : {}", (Object)JDomContentHelper.contentAsString(contentToRemove));
        String text = contentToRemove.getValue().replaceFirst("\n", "");
        Content predecessor = JDomContentHelper.getPredecessorOfContentWithIndex(index, parent);
        Content successor = JDomContentHelper.getSuccessorOfContentWithIndex(index, parent);
        if (JDomContentHelper.hasNewlines(successor) || predecessor != null && !JDomContentHelper.hasNewlines(predecessor)) {
            text = text.replaceAll(" ", "");
            LOG.debug("       Replaced intention : {}", (Object)text);
        }
        JDomUtils.simpleRemoveAtIndex(index, parent);
        Text replacement = new Text(text);
        parent.addContent(index, (Content)replacement);
        LOG.debug("       Content replacement: {}", (Object)JDomContentHelper.contentAsString((Content)replacement));
    }

    private static int removeContentAtIndexIfContentIsComment(int index, Element parent) {
        if (!JDomContentHelper.isIndexValid(index, parent)) {
            return -1;
        }
        Content content = parent.getContent(index);
        if (!JDomContentHelper.isComment(content)) {
            LOG.debug("Content at index {} is no comment", (Object)index);
            return index;
        }
        JDomUtils.simpleRemoveAtIndex(index, parent);
        int prevIndex = index - 1;
        if (prevIndex < 0) {
            return -2;
        }
        Content predecessor = JDomContentHelper.getPredecessorOfContentWithIndex(index, parent);
        if (JDomContentHelper.isNewline(predecessor)) {
            JDomUtils.simpleRemoveAtIndex(prevIndex, parent);
            return prevIndex - 1;
        }
        if (JDomContentHelper.isMultiNewLine(predecessor)) {
            JDomUtils.removeFirstNewLineFromMultiline(prevIndex, parent);
            return -3;
        }
        return prevIndex;
    }

    public static void resetIndentations(Element element, String indent) {
        List childContents = element.getContent();
        for (int i = 1; i < childContents.size(); ++i) {
            Content childContent = (Content)childContents.get(i);
            if (!(childContent instanceof Element)) continue;
            Element childElement = (Element)childContent;
            JDomUtils.resetIndentation((Content)childContents.get(i - 1), indent);
            List grandChildElements = childElement.getContent();
            if (grandChildElements.size() <= 1) continue;
            JDomUtils.resetIndentation((Content)grandChildElements.get(grandChildElements.size() - 1), indent);
        }
    }

    private static void resetIndentation(Content whitespaceContentBeforeElement, String indent) {
        if (whitespaceContentBeforeElement instanceof Text) {
            Text whitespaceTextContent = (Text)whitespaceContentBeforeElement;
            String whitespaces = whitespaceTextContent.getText();
            int lastLsIndex = StringUtils.lastIndexOfAny((String)whitespaces, (String[])new String[]{"\n", "\r"});
            whitespaceTextContent.setText("\n" + whitespaces.substring(0, lastLsIndex) + indent);
        }
    }

    public static void rewriteValue(Element element, String value) {
        Text text = null;
        if (element.getContent() != null) {
            Iterator it = element.getContent().iterator();
            while (it.hasNext()) {
                Object content = it.next();
                if (!(content instanceof Text) || ((Text)content).getTextTrim().isEmpty()) continue;
                text = (Text)content;
                while (it.hasNext() && (content = it.next()) instanceof Text) {
                    text.append((Text)content);
                    it.remove();
                }
                break block0;
            }
        }
        if (text == null) {
            element.addContent(value);
        } else {
            String chars = text.getText();
            String trimmed = text.getTextTrim();
            int idx = chars.indexOf(trimmed);
            String leadingWhitespace = chars.substring(0, idx);
            String trailingWhitespace = chars.substring(idx + trimmed.length());
            text.setText(leadingWhitespace + value + trailingWhitespace);
        }
    }

    public static Element rewriteElement(String name, String value, Element root) {
        Element tagElement = root.getChild(name, root.getNamespace());
        if (tagElement != null) {
            if (value != null) {
                JDomUtils.rewriteValue(tagElement, value);
            } else {
                JDomUtils.removeChildAndItsCommentFromContent(root, (Content)tagElement);
            }
        } else if (value != null) {
            Element element = JDomUtils.insertNewElement(name, root);
            element.setText(value);
            tagElement = element;
        }
        return tagElement;
    }
}

