/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.toolbox.shared.internal.Artifacts;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;

public final class ModuleDescriptorExtractingSink
implements Artifacts.Sink,
DependencyVisitor {
    private final Output output;
    private final ConcurrentMap<Artifact, ModuleDescriptor> moduleDescriptors;

    public ModuleDescriptorExtractingSink(Output output) {
        this.output = Objects.requireNonNull(output, "output");
        this.moduleDescriptors = new ConcurrentHashMap<Artifact, ModuleDescriptor>();
    }

    @Override
    public void accept(Artifact artifact) throws IOException {
        if (artifact.getFile() != null) {
            this.moduleDescriptors.computeIfAbsent(artifact, k -> this.getModuleDescriptor(artifact.getFile().toPath()));
        }
    }

    public String formatString(ModuleDescriptor moduleDescriptor) {
        String moduleInfo = "-- module " + moduleDescriptor.name();
        if (moduleDescriptor.automatic()) {
            moduleInfo = "MANIFEST".equals(moduleDescriptor.moduleNameSource()) ? moduleInfo + " [auto]" : moduleInfo + " (auto)";
        }
        return moduleInfo;
    }

    public ModuleDescriptor getModuleDescriptor(Artifact artifact) {
        return (ModuleDescriptor)this.moduleDescriptors.get(artifact);
    }

    public Map<Artifact, ModuleDescriptor> getModuleDescriptors() {
        return Collections.unmodifiableMap(this.moduleDescriptors);
    }

    private ModuleDescriptor getModuleDescriptor(Path artifactPath) {
        ModuleDescriptorImpl moduleDescriptor;
        block11: {
            moduleDescriptor = null;
            try {
                Class<?> moduleFinderClass = Class.forName("java.lang.module.ModuleFinder");
                Method ofMethod = moduleFinderClass.getMethod("of", Path[].class);
                Object moduleFinderInstance = ofMethod.invoke(null, new Object[]{new Path[]{artifactPath}});
                Method findAllMethod = moduleFinderClass.getMethod("findAll", new Class[0]);
                Set moduleReferences = (Set)findAllMethod.invoke(moduleFinderInstance, new Object[0]);
                if (moduleReferences.isEmpty()) break block11;
                Object moduleReference = moduleReferences.iterator().next();
                Method descriptorMethod = moduleReference.getClass().getMethod("descriptor", new Class[0]);
                Object moduleDescriptorInstance = descriptorMethod.invoke(moduleReference, new Object[0]);
                Method nameMethod = moduleDescriptorInstance.getClass().getMethod("name", new Class[0]);
                String name = (String)nameMethod.invoke(moduleDescriptorInstance, new Object[0]);
                moduleDescriptor = new ModuleDescriptorImpl();
                moduleDescriptor.name = name;
                Method isAutomaticMethod = moduleDescriptorInstance.getClass().getMethod("isAutomatic", new Class[0]);
                moduleDescriptor.automatic = (Boolean)isAutomaticMethod.invoke(moduleDescriptorInstance, new Object[0]);
                if (!moduleDescriptor.automatic || !Files.isRegularFile(artifactPath, new LinkOption[0])) break block11;
                try (JarFile jarFile = new JarFile(artifactPath.toFile());){
                    Manifest manifest = jarFile.getManifest();
                    moduleDescriptor.moduleNameSource = manifest != null && manifest.getMainAttributes().getValue("Automatic-Module-Name") != null ? "MANIFEST" : "FILENAME";
                }
                catch (IOException iOException) {}
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                this.output.warn("Ignored Exception:", e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                this.output.warn("Can't extract module name from {}:", artifactPath.getFileName(), cause);
            }
        }
        return moduleDescriptor;
    }

    public boolean visitEnter(DependencyNode dependencyNode) {
        if (dependencyNode.getDependency() != null) {
            try {
                this.accept(dependencyNode.getDependency().getArtifact());
            }
            catch (IOException e) {
                this.output.warn("IO problem: ", e);
            }
        }
        return true;
    }

    public boolean visitLeave(DependencyNode dependencyNode) {
        return true;
    }

    public Function<DependencyNode, String> decorator() {
        return node -> {
            ModuleDescriptor moduleDescriptor;
            if (node != null && node.getDependency() != null && (moduleDescriptor = this.getModuleDescriptor(node.getDependency().getArtifact())) != null) {
                return this.formatString(moduleDescriptor);
            }
            return null;
        };
    }

    public static interface ModuleDescriptor {
        public String name();

        public boolean automatic();

        public String moduleNameSource();
    }

    private static class ModuleDescriptorImpl
    implements ModuleDescriptor {
        String name;
        boolean automatic = true;
        String moduleNameSource;

        private ModuleDescriptorImpl() {
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean automatic() {
            return this.automatic;
        }

        @Override
        public String moduleNameSource() {
            return this.moduleNameSource;
        }
    }
}

