/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;
import org.eclipse.aether.version.VersionConstraint;

public class DependencyGraphDumper
implements DependencyVisitor {
    private static final List<Function<DependencyNode, String>> DEFAULT_DECORATORS = Collections.unmodifiableList(Arrays.asList(DependencyGraphDumper.effectiveDependency(), DependencyGraphDumper.premanagedVersion(), DependencyGraphDumper.premanagedScope(), DependencyGraphDumper.premanagedOptional(), DependencyGraphDumper.premanagedExclusions(), DependencyGraphDumper.premanagedProperties(), DependencyGraphDumper.rangeMember(), DependencyGraphDumper.winnerNode()));
    private final Consumer<String> consumer;
    private final List<Function<DependencyNode, String>> decorators;
    private final LineFormatter lineFormatter;
    private final Deque<DependencyNode> nodes = new ArrayDeque<DependencyNode>();

    public static Function<DependencyNode, String> effectiveDependency() {
        return dependencyNode -> {
            Dependency d = dependencyNode.getDependency();
            if (d != null && !d.getScope().isEmpty()) {
                Object result = d.getScope();
                if (d.isOptional()) {
                    result = (String)result + ", optional";
                }
                return "[" + (String)result + "]";
            }
            return null;
        };
    }

    public static Function<DependencyNode, Boolean> isPremanaged() {
        return node -> DependencyManagerUtils.getPremanagedVersion((DependencyNode)node) != null && !Objects.equals(DependencyManagerUtils.getPremanagedVersion((DependencyNode)node), node.getDependency().getArtifact().getVersion()) || DependencyManagerUtils.getPremanagedScope((DependencyNode)node) != null && !Objects.equals(DependencyManagerUtils.getPremanagedScope((DependencyNode)node), node.getDependency().getScope()) || DependencyManagerUtils.getPremanagedOptional((DependencyNode)node) != null && !Objects.equals(DependencyManagerUtils.getPremanagedOptional((DependencyNode)node), node.getDependency().getOptional()) || DependencyManagerUtils.getPremanagedExclusions((DependencyNode)node) != null && !Objects.equals(DependencyManagerUtils.getPremanagedExclusions((DependencyNode)node), node.getDependency().getExclusions());
    }

    public static Function<DependencyNode, String> premanagedVersion() {
        return dependencyNode -> {
            String premanagedVersion;
            if (dependencyNode.getArtifact() != null && (premanagedVersion = DependencyManagerUtils.getPremanagedVersion((DependencyNode)dependencyNode)) != null && !premanagedVersion.equals(dependencyNode.getArtifact().getBaseVersion())) {
                return "(version managed from " + premanagedVersion + ")";
            }
            return null;
        };
    }

    public static Function<DependencyNode, String> premanagedScope() {
        return dependencyNode -> {
            String premanagedScope;
            Dependency d = dependencyNode.getDependency();
            if (d != null && (premanagedScope = DependencyManagerUtils.getPremanagedScope((DependencyNode)dependencyNode)) != null && !premanagedScope.equals(d.getScope())) {
                return "(scope managed from " + premanagedScope + ")";
            }
            return null;
        };
    }

    public static Function<DependencyNode, String> premanagedOptional() {
        return dependencyNode -> {
            Boolean premanagedOptional;
            Dependency d = dependencyNode.getDependency();
            if (d != null && (premanagedOptional = DependencyManagerUtils.getPremanagedOptional((DependencyNode)dependencyNode)) != null && !premanagedOptional.equals(d.getOptional())) {
                return "(optionality managed from " + premanagedOptional + ")";
            }
            return null;
        };
    }

    public static Function<DependencyNode, String> premanagedExclusions() {
        return dependencyNode -> {
            Collection premanagedExclusions;
            Dependency d = dependencyNode.getDependency();
            if (d != null && (premanagedExclusions = DependencyManagerUtils.getPremanagedExclusions((DependencyNode)dependencyNode)) != null) {
                if (!DependencyGraphDumper.equals(premanagedExclusions, d.getExclusions())) {
                    return "(exclusions managed from " + String.valueOf(premanagedExclusions) + ")";
                }
                return "(exclusions applied: " + premanagedExclusions.size() + ")";
            }
            return null;
        };
    }

    public static Function<DependencyNode, String> premanagedProperties() {
        return dependencyNode -> {
            Map premanagedProperties;
            if (dependencyNode.getArtifact() != null && (premanagedProperties = DependencyManagerUtils.getPremanagedProperties((DependencyNode)dependencyNode)) != null && !DependencyGraphDumper.equals(premanagedProperties, dependencyNode.getArtifact().getProperties())) {
                return "(properties managed from " + String.valueOf(premanagedProperties) + ")";
            }
            return null;
        };
    }

    public static Function<DependencyNode, String> rangeMember() {
        return dependencyNode -> {
            VersionConstraint constraint = dependencyNode.getVersionConstraint();
            if (constraint != null && constraint.getRange() != null) {
                return "(range '" + String.valueOf(constraint.getRange()) + "')";
            }
            return null;
        };
    }

    public static Function<DependencyNode, String> winnerNode() {
        return dependencyNode -> {
            DependencyNode winner;
            if (dependencyNode.getArtifact() != null && (winner = (DependencyNode)dependencyNode.getData().get("conflict.winner")) != null) {
                if (ArtifactIdUtils.equalsId((Artifact)dependencyNode.getArtifact(), (Artifact)winner.getArtifact())) {
                    return "(nearer exists)";
                }
                Artifact w = winner.getArtifact();
                Object result = "conflicts with ";
                result = ArtifactIdUtils.toVersionlessId((Artifact)dependencyNode.getArtifact()).equals(ArtifactIdUtils.toVersionlessId((Artifact)w)) ? (String)result + w.getVersion() : (String)result + String.valueOf(w);
                return "(" + (String)result + ")";
            }
            return null;
        };
    }

    public static Function<DependencyNode, String> artifactProperties(Collection<String> properties) {
        Objects.requireNonNull(properties, "properties");
        return dependencyNode -> {
            String props;
            if (!properties.isEmpty() && dependencyNode.getDependency() != null && !(props = properties.stream().map(p -> p + "=" + dependencyNode.getDependency().getArtifact().getProperty(p, "n/a")).collect(Collectors.joining(","))).isEmpty()) {
                return "(" + props + ")";
            }
            return null;
        };
    }

    @SafeVarargs
    public static List<Function<DependencyNode, String>> defaultsWith(Function<DependencyNode, String> ... extras) {
        return DependencyGraphDumper.defaultsWith(Arrays.asList(extras));
    }

    public static List<Function<DependencyNode, String>> defaultsWith(Collection<Function<DependencyNode, String>> extras) {
        Objects.requireNonNull(extras, "extras");
        ArrayList<Function<DependencyNode, String>> result = new ArrayList<Function<DependencyNode, String>>(DEFAULT_DECORATORS);
        result.addAll(extras);
        return result;
    }

    public DependencyGraphDumper(Consumer<String> consumer) {
        this(consumer, DEFAULT_DECORATORS);
    }

    public DependencyGraphDumper(Consumer<String> consumer, Collection<Function<DependencyNode, String>> decorators) {
        this(consumer, decorators, new LineFormatter());
    }

    public DependencyGraphDumper(Consumer<String> consumer, Collection<Function<DependencyNode, String>> decorators, LineFormatter lineFormatter) {
        this.consumer = Objects.requireNonNull(consumer);
        this.decorators = new ArrayList<Function<DependencyNode, String>>(decorators);
        this.lineFormatter = Objects.requireNonNull(lineFormatter);
    }

    public boolean visitEnter(DependencyNode node) {
        this.nodes.push(node);
        this.consumer.accept(this.lineFormatter.formatLine(this.nodes, this.decorators));
        return true;
    }

    public boolean visitLeave(DependencyNode node) {
        if (!this.nodes.isEmpty()) {
            this.nodes.pop();
        }
        return true;
    }

    private static boolean equals(Collection<Exclusion> c1, Collection<Exclusion> c2) {
        return c1 != null && c2 != null && c1.size() == c2.size() && c1.containsAll(c2);
    }

    private static boolean equals(Map<String, String> m1, Map<String, String> m2) {
        return m1 != null && m2 != null && m1.size() == m2.size() && m1.entrySet().stream().allMatch(entry -> Objects.equals(m2.get(entry.getKey()), entry.getValue()));
    }

    public static class LineFormatter {
        public String formatLine(Deque<DependencyNode> nodes, List<Function<DependencyNode, String>> decorators) {
            return this.formatIndentation(nodes) + this.formatNode(nodes, decorators);
        }

        protected String formatIndentation(Deque<DependencyNode> nodes) {
            return this.formatIndentation(nodes, "\\- ", "+- ", "   ", "|  ");
        }

        protected String formatIndentation(Deque<DependencyNode> nodes, String endLastStr, String endStr, String midLastStr, String midStr) {
            DependencyNode child;
            StringBuilder buffer = new StringBuilder(128);
            Iterator<DependencyNode> iter = nodes.descendingIterator();
            DependencyNode parent = iter.hasNext() ? iter.next() : null;
            DependencyNode dependencyNode = child = iter.hasNext() ? iter.next() : null;
            while (parent != null && child != null) {
                boolean end;
                boolean lastChild = parent.getChildren().get(parent.getChildren().size() - 1) == child;
                boolean bl = end = child == nodes.peekFirst();
                String indent = end ? (lastChild ? endLastStr : endStr) : (lastChild ? midLastStr : midStr);
                buffer.append(indent);
                parent = child;
                child = iter.hasNext() ? iter.next() : null;
            }
            return buffer.toString();
        }

        protected String formatNode(Deque<DependencyNode> nodes, List<Function<DependencyNode, String>> decorators) {
            DependencyNode node = Objects.requireNonNull(nodes.peek(), "bug: should not happen");
            StringBuilder buffer = new StringBuilder(128);
            Artifact a = node.getArtifact();
            buffer.append(a);
            for (Function<DependencyNode, String> decorator : decorators) {
                String decoration = decorator.apply(node);
                if (decoration == null) continue;
                buffer.append(" ").append(decoration);
            }
            return buffer.toString();
        }
    }
}

