/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.toolbox.shared.ArtifactRecorder;
import eu.maveniverse.maven.toolbox.shared.internal.Artifacts;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;

public class ArtifactRecorderImpl
extends AbstractRepositoryListener
implements Artifacts.Source,
ArtifactRecorder {
    private final ConcurrentHashMap<RemoteRepository, List<Artifact>> recordedArtifacts = new ConcurrentHashMap();
    private final AtomicBoolean active = new AtomicBoolean(false);

    public void artifactResolved(RepositoryEvent event) {
        if (this.active.get()) {
            RemoteRepository repository = event.getRepository() instanceof RemoteRepository ? (RemoteRepository)event.getRepository() : SENTINEL;
            this.recordedArtifacts.computeIfAbsent(repository, k -> Collections.synchronizedList(new ArrayList())).add(event.getArtifact());
        }
    }

    @Override
    public boolean isActive() {
        return this.active.get();
    }

    @Override
    public boolean setActive(boolean val) {
        return this.active.compareAndSet(!val, val);
    }

    @Override
    public int recordedCount() {
        return this.recordedArtifacts.values().stream().mapToInt(Collection::size).sum();
    }

    @Override
    public void clear() {
        this.recordedArtifacts.clear();
    }

    @Override
    public Map<RemoteRepository, List<Artifact>> getRecordedArtifacts() {
        return this.recordedArtifacts;
    }
}

