/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared;

import eu.maveniverse.maven.toolbox.shared.internal.Artifacts;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public final class ProjectArtifacts
implements Artifacts.Source {
    private final Artifact prototype;
    private final Map<CE, Path> artifacts;

    private ProjectArtifacts(Artifact prototype, Map<CE, Path> artifacts) {
        this.prototype = prototype;
        this.artifacts = artifacts;
    }

    @Override
    public Stream<Artifact> get() {
        return this.artifacts.entrySet().stream().map(e -> new DefaultArtifact(this.prototype.getGroupId(), this.prototype.getArtifactId(), ((CE)e.getKey()).classifier, ((CE)e.getKey()).extension, this.prototype.getVersion()).setFile(((Path)e.getValue()).toFile()));
    }

    private static final class CE {
        private final String classifier;
        private final String extension;

        private CE(String classifier, String extension) {
            this.classifier = classifier;
            this.extension = Objects.requireNonNull(extension, "extension");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CE ce = (CE)o;
            return Objects.equals(this.classifier, ce.classifier) && Objects.equals(this.extension, ce.extension);
        }

        public int hashCode() {
            return Objects.hash(this.classifier, this.extension);
        }
    }

    public static class Builder {
        private final Artifact prototype;
        private final Map<CE, Path> artifacts;

        public Builder(String gav) {
            this.prototype = new DefaultArtifact(gav);
            this.artifacts = new HashMap<CE, Path>();
        }

        public void addPom(Path artifact) {
            this.addArtifact(null, "pom", artifact);
        }

        public void addMain(Path artifact) {
            this.addArtifact(null, this.prototype.getExtension(), artifact);
        }

        public void addSources(Path artifact) {
            this.addArtifact("sources", "jar", artifact);
        }

        public void addJavadoc(Path artifact) {
            this.addArtifact("javadoc", "jar", artifact);
        }

        public void addArtifact(String classifier, String extension, Path artifact) {
            Objects.requireNonNull(extension, "extension");
            Objects.requireNonNull(artifact, "artifact");
            if (!Files.exists(artifact, new LinkOption[0]) || Files.isDirectory(artifact, new LinkOption[0])) {
                throw new IllegalArgumentException("artifact backing file must exist and cannot be a directory");
            }
            CE ce = new CE(classifier, extension);
            if (this.artifacts.containsKey(ce)) {
                throw new IllegalArgumentException("artifact already present");
            }
            this.artifacts.put(ce, artifact);
        }

        public ProjectArtifacts build() {
            return new ProjectArtifacts(this.prototype, this.artifacts);
        }
    }
}

