/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared;

import eu.maveniverse.maven.toolbox.shared.ArtifactNameMapper;
import eu.maveniverse.maven.toolbox.shared.internal.SpecParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public interface ArtifactMatcher
extends Predicate<Artifact> {
    public static ArtifactMatcher not(final ArtifactMatcher matcher) {
        return new ArtifactMatcher(){

            @Override
            public boolean test(Artifact artifact) {
                return !matcher.test(artifact);
            }
        };
    }

    public static ArtifactMatcher and(ArtifactMatcher ... matchers) {
        return ArtifactMatcher.and(Arrays.asList(matchers));
    }

    public static ArtifactMatcher and(final Collection<ArtifactMatcher> matchers) {
        return new ArtifactMatcher(){

            @Override
            public boolean test(Artifact artifact) {
                for (ArtifactMatcher matcher : matchers) {
                    if (matcher.test(artifact)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static ArtifactMatcher or(ArtifactMatcher ... matchers) {
        return ArtifactMatcher.or(Arrays.asList(matchers));
    }

    public static ArtifactMatcher or(final Collection<ArtifactMatcher> matchers) {
        return new ArtifactMatcher(){

            @Override
            public boolean test(Artifact artifact) {
                for (ArtifactMatcher matcher : matchers) {
                    if (!matcher.test(artifact)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static ArtifactMatcher withoutClassifier() {
        return a -> a.getClassifier() == null || a.getClassifier().trim().isEmpty();
    }

    public static ArtifactMatcher artifact(String coordinate) {
        Artifact prototype = ArtifactMatcher.parsePrototype(coordinate);
        return a -> ArtifactMatcher.matches(prototype.getGroupId(), a.getGroupId()) && ArtifactMatcher.matches(prototype.getArtifactId(), a.getArtifactId()) && ArtifactMatcher.matches(prototype.getVersion(), a.getVersion()) && ArtifactMatcher.matches(prototype.getExtension(), a.getExtension()) && ArtifactMatcher.matches(prototype.getClassifier(), a.getClassifier());
    }

    public static ArtifactMatcher any() {
        return ArtifactMatcher.artifact("*");
    }

    public static ArtifactMatcher snapshot() {
        return new ArtifactMatcher(){

            @Override
            public boolean test(Artifact artifact) {
                return artifact.isSnapshot();
            }
        };
    }

    public static ArtifactMatcher unique() {
        return ArtifactMatcher.uniqueBy(ArtifactNameMapper.GACEVKey());
    }

    public static ArtifactMatcher uniqueBy(final ArtifactNameMapper mapper) {
        final HashSet keys = new HashSet();
        return new ArtifactMatcher(){

            @Override
            public boolean test(Artifact artifact) {
                return keys.add((String)mapper.apply(artifact));
            }
        };
    }

    public static ArtifactMatcher build(Map<String, ?> properties, String spec) {
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(spec, "spec");
        ArtifactMatcherBuilder builder = new ArtifactMatcherBuilder(properties);
        SpecParser.parse(spec).accept(builder);
        return builder.build();
    }

    public static boolean isAny(String str) {
        return "*".equals(str);
    }

    public static boolean matches(String pattern, String str) {
        if (ArtifactMatcher.isAny(pattern)) {
            return true;
        }
        if (pattern.endsWith("*")) {
            return str.startsWith(pattern.substring(0, pattern.length() - 1));
        }
        if (pattern.startsWith("*")) {
            return str.endsWith(pattern.substring(1));
        }
        return Objects.equals(pattern, str);
    }

    public static Artifact parsePrototype(String coordinate) {
        DefaultArtifact s;
        Objects.requireNonNull(coordinate, "coordinate");
        String[] parts = coordinate.split(":", -1);
        switch (parts.length) {
            case 1: {
                s = new DefaultArtifact(parts[0], "*", "*", "*", "*");
                break;
            }
            case 2: {
                s = new DefaultArtifact(parts[0], parts[1], "*", "*", "*");
                break;
            }
            case 3: {
                s = new DefaultArtifact(parts[0], parts[1], "*", "*", parts[2]);
                break;
            }
            case 4: {
                s = new DefaultArtifact(parts[0], parts[1], "*", parts[2], parts[3]);
                break;
            }
            case 5: {
                s = new DefaultArtifact(parts[0], parts[1], parts[2], parts[3], parts[4]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad artifact coordinates " + coordinate + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
            }
        }
        return s;
    }

    public static class ArtifactMatcherBuilder
    extends SpecParser.Builder {
        public ArtifactMatcherBuilder(Map<String, ?> properties) {
            super(properties);
        }

        @Override
        public boolean visitEnter(SpecParser.Node node) {
            return super.visitEnter(node) && !"uniqueBy".equals(node.getValue());
        }

        @Override
        protected void processOp(SpecParser.Node node) {
            switch (node.getValue()) {
                case "withoutClassifier": {
                    this.params.add(ArtifactMatcher.withoutClassifier());
                    break;
                }
                case "any": {
                    this.params.add(ArtifactMatcher.any());
                    break;
                }
                case "snapshot": {
                    this.params.add(ArtifactMatcher.snapshot());
                    break;
                }
                case "artifact": {
                    this.params.add(ArtifactMatcher.artifact(this.stringParam(node.getValue())));
                    break;
                }
                case "unique": {
                    this.params.add(ArtifactMatcher.unique());
                    break;
                }
                case "uniqueBy": {
                    if (node.getChildren().size() != 1) {
                        throw new IllegalArgumentException("op uniqueBy accepts only 1 argument");
                    }
                    ArtifactNameMapper.ArtifactNameMapperBuilder nameMapper = new ArtifactNameMapper.ArtifactNameMapperBuilder(this.properties);
                    node.getChildren().get(0).accept(nameMapper);
                    this.params.add(ArtifactMatcher.uniqueBy(nameMapper.build()));
                    node.getChildren().clear();
                    break;
                }
                case "not": {
                    this.params.add(ArtifactMatcher.not(this.typedParam(ArtifactMatcher.class, node.getValue())));
                    break;
                }
                case "and": {
                    this.params.add(ArtifactMatcher.and(this.typedParams(ArtifactMatcher.class, node.getValue())));
                    break;
                }
                case "or": {
                    this.params.add(ArtifactMatcher.or(this.typedParams(ArtifactMatcher.class, node.getValue())));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown op " + node.getValue());
                }
            }
        }

        public ArtifactMatcher build() {
            return this.build(ArtifactMatcher.class);
        }
    }
}

