/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.output;

import eu.maveniverse.maven.toolbox.shared.internal.DependencyGraphDecorators;
import eu.maveniverse.maven.toolbox.shared.internal.DependencyGraphDumper;
import eu.maveniverse.maven.toolbox.shared.output.Marker;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import eu.maveniverse.maven.toolbox.shared.output.OutputSupport;
import java.io.Serializable;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.aether.graph.DependencyNode;
import org.jline.jansi.Ansi;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class AnsiOutput
extends OutputSupport {
    private final Output output;

    public AnsiOutput(Output output) {
        super(output.getVerbosity(), output.isShowErrors());
        this.output = output;
    }

    @Override
    public <T> T tool(Class<? extends T> klazz, Supplier<T> supplier) {
        if (DependencyGraphDumper.LineFormatter.class.isAssignableFrom(klazz)) {
            if (DependencyGraphDecorators.TreeDecorator.class.equals(klazz)) {
                return (T)new AnsiTreeFormatter(this.marker(Output.Verbosity.NORMAL), new TreeIntentMapper());
            }
            if (DependencyGraphDecorators.DmTreeDecorator.class.equals(klazz)) {
                return (T)new AnsiTreeFormatter(this.marker(Output.Verbosity.NORMAL), new DmTreeIntentMapper());
            }
            if (DependencyGraphDecorators.ParentChildTreeDecorator.class.equals(klazz)) {
                return (T)new AnsiTreeFormatter(this.marker(Output.Verbosity.NORMAL), new SourceTreeIntentMapper());
            }
            if (DependencyGraphDecorators.SubprojectTreeDecorator.class.equals(klazz)) {
                return (T)new AnsiTreeFormatter(this.marker(Output.Verbosity.NORMAL), new SourceTreeIntentMapper());
            }
            if (DependencyGraphDecorators.ProjectDependenciesTreeDecorator.class.equals(klazz)) {
                return (T)new AnsiTreeFormatter(this.marker(Output.Verbosity.NORMAL), new SourceTreeIntentMapper());
            }
        }
        return supplier.get();
    }

    @Override
    public Marker marker(Output.Verbosity verbosity) {
        return new AnsiMarker(this, verbosity);
    }

    @Override
    protected void doHandle(Output.Verbosity verbosity, String message, Object ... params) {
        FormattingTuple tuple = MessageFormatter.arrayFormat((String)message, (Object[])params);
        this.output.handle(verbosity, tuple.getMessage(), new Object[0]);
        if (tuple.getThrowable() != null) {
            this.writeThrowable(tuple.getThrowable(), this.output, verbosity);
        }
    }

    private void writeThrowable(Throwable t, Output output, Output.Verbosity verbosity) {
        if (t == null) {
            return;
        }
        Object builder = AnsiOutput.bold(t.getClass().getName());
        if (t.getMessage() != null) {
            builder = (String)builder + ": " + AnsiOutput.italic(t.getMessage());
        }
        output.handle(verbosity, (String)builder, new Object[0]);
        if (this.errors) {
            this.printStackTrace(t, output, verbosity, "");
        }
        output.handle(verbosity, Ansi.ansi().reset().toString(), new Object[0]);
    }

    private void printStackTrace(Throwable t, Output output, Output.Verbosity verbosity, String prefix) {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement stackTraceElement : t.getStackTrace()) {
            builder.append(prefix);
            builder.append("    ");
            builder.append(AnsiOutput.bold("at"));
            builder.append(" ");
            builder.append(stackTraceElement.getClassName());
            builder.append(".");
            builder.append(stackTraceElement.getMethodName());
            builder.append(" (");
            builder.append(AnsiOutput.bold(this.getLocation(stackTraceElement)));
            builder.append(")");
            output.handle(verbosity, builder.toString(), new Object[0]);
            builder.setLength(0);
        }
        for (Serializable serializable : t.getSuppressed()) {
            this.writeThrowable((Throwable)serializable, output, verbosity, "Suppressed", prefix + "    ");
        }
        Throwable cause = t.getCause();
        if (cause != null && t != cause) {
            this.writeThrowable(cause, output, verbosity, "Caused by", prefix);
        }
    }

    private void writeThrowable(Throwable t, Output output, Output.Verbosity verbosity, String caption, String prefix) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix).append(AnsiOutput.bold(caption)).append(": ").append(t.getClass().getName());
        if (t.getMessage() != null) {
            builder.append(": ").append(AnsiOutput.italic(t.getMessage()));
        }
        output.handle(verbosity, builder.toString(), new Object[0]);
        this.printStackTrace(t, output, verbosity, prefix);
    }

    private String getLocation(StackTraceElement e) {
        if (e.isNativeMethod()) {
            return "Native Method";
        }
        if (e.getFileName() == null) {
            return "Unknown Source";
        }
        if (e.getLineNumber() >= 0) {
            return e.getFileName() + ":" + e.getLineNumber();
        }
        return e.getFileName();
    }

    private static String italic(String format) {
        return Ansi.ansi().a(Ansi.Attribute.ITALIC).a(format).a(Ansi.Attribute.ITALIC_OFF).toString();
    }

    private static String bold(String format) {
        return Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a(format).a(Ansi.Attribute.INTENSITY_BOLD_OFF).toString();
    }

    private static class AnsiTreeFormatter
    extends DependencyGraphDumper.LineFormatter {
        private final Marker marker;
        private final Function<Deque<DependencyNode>, Marker.Intent> intentMapper;

        public AnsiTreeFormatter(Marker marker, Function<Deque<DependencyNode>, Marker.Intent> intentMapper) {
            this.marker = marker;
            this.intentMapper = intentMapper;
        }

        @Override
        public String formatLine(Deque<DependencyNode> nodes, List<Function<DependencyNode, String>> decorators) {
            String indentationStr = this.formatIndentation(nodes, "\u2570\u2500", "\u251c\u2500", "  ", "\u2502 ");
            String nodeStr = this.formatNode(nodes, decorators);
            Marker.Intent intent = this.intentMapper.apply(nodes);
            Object result = "";
            switch (intent) {
                case EMPHASIZE: {
                    result = indentationStr + this.marker.emphasize(nodeStr).toString();
                    break;
                }
                case OUTSTANDING: {
                    result = indentationStr + this.marker.outstanding(nodeStr).toString();
                    break;
                }
                case NORMAL: {
                    result = indentationStr + this.marker.normal(nodeStr).toString();
                    break;
                }
                case DETAIL: {
                    result = indentationStr + this.marker.detail(nodeStr).toString();
                    break;
                }
                case UNIMPORTANT: {
                    result = indentationStr + this.marker.unimportant(nodeStr).toString();
                    break;
                }
                case SCARY: {
                    result = indentationStr + this.marker.scary(nodeStr).toString();
                    break;
                }
                case BLOODY: {
                    result = indentationStr + this.marker.bloody(nodeStr).toString();
                }
            }
            return result;
        }
    }

    private static class TreeIntentMapper
    implements Function<Deque<DependencyNode>, Marker.Intent> {
        private final Function<DependencyNode, String> winner = DependencyGraphDumper.winnerNode();
        private final Function<DependencyNode, Boolean> premanaged = DependencyGraphDumper.isPremanaged();

        private TreeIntentMapper() {
        }

        @Override
        public Marker.Intent apply(Deque<DependencyNode> nodes) {
            DependencyNode node = Objects.requireNonNull(nodes.peek(), "bug");
            if (nodes.size() == 1) {
                return Marker.Intent.OUTSTANDING;
            }
            if (this.winner.apply(node) != null) {
                return Marker.Intent.UNIMPORTANT;
            }
            if ("provided".equals(node.getDependency().getScope())) {
                return Marker.Intent.DETAIL;
            }
            if (this.premanaged.apply(node).booleanValue()) {
                return Marker.Intent.SCARY;
            }
            return Marker.Intent.OUTSTANDING;
        }
    }

    private static class DmTreeIntentMapper
    implements Function<Deque<DependencyNode>, Marker.Intent> {
        private DmTreeIntentMapper() {
        }

        @Override
        public Marker.Intent apply(Deque<DependencyNode> nodes) {
            DependencyNode node = Objects.requireNonNull(nodes.peek(), "bug");
            if (node.getDependency() != null && "import".equals(node.getDependency().getScope())) {
                return Marker.Intent.SCARY;
            }
            return Marker.Intent.OUTSTANDING;
        }
    }

    private static class SourceTreeIntentMapper
    implements Function<Deque<DependencyNode>, Marker.Intent> {
        private SourceTreeIntentMapper() {
        }

        @Override
        public Marker.Intent apply(Deque<DependencyNode> nodes) {
            DependencyNode node = Objects.requireNonNull(nodes.peek(), "bug");
            if ("external".equals(node.getArtifact().getProperty("source", ""))) {
                return Marker.Intent.UNIMPORTANT;
            }
            return Marker.Intent.OUTSTANDING;
        }
    }

    private static class AnsiMarker
    extends Marker {
        public AnsiMarker(Output output, Output.Verbosity verbosity) {
            super(output, verbosity);
        }

        @Override
        public Marker emphasize(String word) {
            return super.emphasize(Ansi.ansi().bold().fgBright(Ansi.Color.WHITE).a(word).reset().toString());
        }

        @Override
        public Marker outstanding(String word) {
            return super.outstanding(Ansi.ansi().fgBright(Ansi.Color.GREEN).a(word).reset().toString());
        }

        @Override
        public Marker detail(String word) {
            return super.detail(Ansi.ansi().fgBright(Ansi.Color.BLUE).a(word).reset().toString());
        }

        @Override
        public Marker unimportant(String word) {
            return super.unimportant(Ansi.ansi().fg(Ansi.Color.BLUE).a(word).reset().toString());
        }

        @Override
        public Marker scary(String word) {
            return super.scary(Ansi.ansi().fgBright(Ansi.Color.YELLOW).a(word).reset().toString());
        }

        @Override
        public Marker bloody(String word) {
            return super.bloody(Ansi.ansi().bold().fgBright(Ansi.Color.RED).a(word).reset().toString());
        }
    }
}

