/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.mima.context.ContextOverrides;
import eu.maveniverse.maven.toolbox.shared.internal.Java11HttpClientFactory;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.maven.search.api.MAVEN;
import org.apache.maven.search.api.Record;
import org.apache.maven.search.api.SearchBackend;
import org.apache.maven.search.api.SearchRequest;
import org.apache.maven.search.api.SearchResponse;
import org.apache.maven.search.api.request.BooleanQuery;
import org.apache.maven.search.api.request.Field;
import org.apache.maven.search.api.request.FieldQuery;
import org.apache.maven.search.api.request.Query;
import org.apache.maven.search.api.transport.Java11HttpClientTransport;
import org.apache.maven.search.api.transport.Transport;
import org.apache.maven.search.backend.remoterepository.RemoteRepositorySearchBackendFactory;
import org.apache.maven.search.backend.remoterepository.ResponseExtractor;
import org.apache.maven.search.backend.remoterepository.extractor.MavenCentralResponseExtractor;
import org.apache.maven.search.backend.remoterepository.extractor.Nx2ResponseExtractor;
import org.apache.maven.search.backend.smo.SmoSearchBackendFactory;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;

public class ToolboxSearchApiImpl {
    private final Output output;

    public ToolboxSearchApiImpl(Output output) {
        this.output = Objects.requireNonNull(output, "output");
    }

    public SearchBackend getRemoteRepositoryBackend(RepositorySystemSession session, RemoteRepository remoteRepository, String repositoryVendor) {
        MavenCentralResponseExtractor extractor;
        this.output.chatter("Creating backend for {} (vendor={})", remoteRepository, repositoryVendor == null ? "n/a" : repositoryVendor);
        if (repositoryVendor == null) {
            repositoryVendor = (String)session.getConfigProperties().get("toolbox.search.backend.type");
            if (repositoryVendor == null) {
                if ("central".equals(remoteRepository.getContentType())) {
                    repositoryVendor = "central";
                } else if ("nx2".equals(remoteRepository.getContentType())) {
                    repositoryVendor = "nx2";
                } else if (ContextOverrides.CENTRAL.getId().equals(remoteRepository.getId()) && ContextOverrides.CENTRAL.getUrl().equals(remoteRepository.getUrl())) {
                    repositoryVendor = "central";
                } else if (remoteRepository.getUrl().startsWith("https://repo.maven.apache.org/maven2") || remoteRepository.getUrl().startsWith("https://repo1.maven.org/maven2/")) {
                    repositoryVendor = "central";
                } else if (remoteRepository.getUrl().startsWith("https://repository.apache.org/") || remoteRepository.getUrl().startsWith("https://oss.sonatype.org/") || remoteRepository.getUrl().startsWith("https://s01.oss.sonatype.org/")) {
                    repositoryVendor = "nx2";
                } else if (remoteRepository.getUrl().contains("/content/groups/") || remoteRepository.getUrl().contains("/content/repositories/")) {
                    repositoryVendor = "nx2";
                }
            }
            this.output.chatter("Vendor guessed to {}", repositoryVendor);
        }
        if ("central".equalsIgnoreCase(repositoryVendor)) {
            extractor = new MavenCentralResponseExtractor();
        } else if ("nx2".equalsIgnoreCase(repositoryVendor)) {
            extractor = new Nx2ResponseExtractor();
        } else {
            throw new IllegalArgumentException("Unsupported Search RR extractor: '" + repositoryVendor + "'; (supported are 'central', 'nx2')");
        }
        this.output.chatter("Creating backend {}-rr {}:{}:{}", remoteRepository.getId(), remoteRepository.getId(), remoteRepository.getId(), repositoryVendor);
        return RemoteRepositorySearchBackendFactory.create((String)(remoteRepository.getId() + "-rr"), (String)remoteRepository.getId(), (String)remoteRepository.getUrl(), (Transport)new Java11HttpClientTransport(Java11HttpClientFactory.DEFAULT_TIMEOUT, Java11HttpClientFactory.buildHttpClient(session, remoteRepository)), (ResponseExtractor)extractor);
    }

    public SearchBackend getSmoBackend(RepositorySystemSession session, RemoteRepository remoteRepository) {
        if (!ContextOverrides.CENTRAL.getId().equals(remoteRepository.getId())) {
            throw new IllegalArgumentException("The SMO service is offered for Central only");
        }
        this.output.chatter("Creating SMO backend", new Object[0]);
        return SmoSearchBackendFactory.create((String)(remoteRepository.getId() + "-smo"), (String)remoteRepository.getId(), (String)"https://search.maven.org/solrsearch/select", (Transport)new Java11HttpClientTransport(Java11HttpClientFactory.DEFAULT_TIMEOUT, Java11HttpClientFactory.buildHttpClient(session, remoteRepository)));
    }

    public List<String> renderGavoid(List<Record> page, Predicate<String> versionPredicate) {
        ArrayList<String> result = new ArrayList<String>();
        for (Record record : page) {
            String version = record.getValue(MAVEN.VERSION);
            if (version != null && versionPredicate != null && !versionPredicate.test(version)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(record.getValue(MAVEN.GROUP_ID));
            if (record.hasField((Field)MAVEN.ARTIFACT_ID)) {
                sb.append(":").append(record.getValue(MAVEN.ARTIFACT_ID));
            }
            if (record.hasField((Field)MAVEN.PACKAGING)) {
                if (record.hasField((Field)MAVEN.CLASSIFIER)) {
                    sb.append(":").append(record.getValue(MAVEN.CLASSIFIER));
                }
                sb.append(":").append(record.getValue(MAVEN.PACKAGING));
            } else if (record.hasField((Field)MAVEN.FILE_EXTENSION)) {
                if (record.hasField((Field)MAVEN.CLASSIFIER)) {
                    sb.append(":").append(record.getValue(MAVEN.CLASSIFIER));
                }
                sb.append(":").append(record.getValue(MAVEN.FILE_EXTENSION));
            }
            if (record.hasField((Field)MAVEN.VERSION)) {
                sb.append(":").append(record.getValue(MAVEN.VERSION));
            }
            result.add(sb.toString());
        }
        return result;
    }

    public Collection<Artifact> renderArtifacts(RepositorySystemSession session, List<Record> page, Predicate<String> versionPredicate) {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Record record : page) {
            ArtifactType type;
            String version = record.getValue(MAVEN.VERSION);
            if (version != null && versionPredicate != null && !versionPredicate.test(version)) continue;
            String groupId = record.getValue(MAVEN.GROUP_ID);
            String artifactId = record.getValue(MAVEN.ARTIFACT_ID);
            String classifier = record.getValue(MAVEN.CLASSIFIER);
            String packaging = record.getValue(MAVEN.PACKAGING);
            String fileExtension = record.getValue(MAVEN.FILE_EXTENSION);
            if ((fileExtension == null || fileExtension.trim().isEmpty() && packaging != null) && (type = session.getArtifactTypeRegistry().get(packaging)) != null) {
                fileExtension = type.getExtension();
            }
            if (fileExtension == null || fileExtension.trim().isEmpty()) continue;
            HashMap<String, String> properties = new HashMap<String, String>();
            if (packaging != null) {
                properties.put("packaging", packaging);
            }
            if (record.getLastUpdated() != null) {
                properties.put("lastUpdated", String.valueOf(record.getLastUpdated()));
            }
            if (record.hasField((Field)MAVEN.VERSION_COUNT)) {
                properties.put("versionCount", String.valueOf(record.getValue(MAVEN.VERSION_COUNT)));
            }
            if (record.hasField((Field)MAVEN.HAS_SOURCE)) {
                properties.put("hasSource", Boolean.toString(record.getValue(MAVEN.HAS_SOURCE)));
            }
            if (record.hasField((Field)MAVEN.HAS_JAVADOC)) {
                properties.put("hasJavadoc", Boolean.toString(record.getValue(MAVEN.HAS_JAVADOC)));
            }
            result.add(new DefaultArtifact(groupId, artifactId, classifier, fileExtension, version).setProperties(properties));
        }
        return result;
    }

    public boolean exists(SearchBackend backend, Artifact artifact) throws IOException {
        Query query = this.toRrQuery(artifact);
        SearchRequest searchRequest = new SearchRequest(query);
        SearchResponse searchResponse = backend.search(searchRequest);
        this.output.chatter("SearchRequest: {} SearchResponse TH/CH {}/{}", searchResponse.getSearchRequest(), searchResponse.getTotalHits(), searchResponse.getCurrentHits());
        return searchResponse.getTotalHits() == 1;
    }

    public boolean verify(SearchBackend backend, Artifact artifact, String sha1) throws IOException {
        Query query = this.toRrQuery(artifact);
        query = BooleanQuery.and((Query)query, (Query[])new Query[]{FieldQuery.fieldQuery((Field)MAVEN.SHA1, (String)sha1)});
        SearchRequest searchRequest = new SearchRequest(query);
        SearchResponse searchResponse = backend.search(searchRequest);
        this.output.chatter("SearchRequest: {} SearchResponse TH/CH {}/{}", searchResponse.getSearchRequest(), searchResponse.getTotalHits(), searchResponse.getCurrentHits());
        return searchResponse.getTotalHits() == 1;
    }

    public Map<String, Artifact> identify(RepositorySystemSession session, SearchBackend searchBackend, Collection<String> sha1s) throws IOException {
        HashMap<String, Artifact> result = new HashMap<String, Artifact>(sha1s.size());
        for (String sha1 : sha1s) {
            this.output.suggest("Identifying artifact with SHA1={}", sha1);
            SearchRequest searchRequest = new SearchRequest((Query)FieldQuery.fieldQuery((Field)MAVEN.SHA1, (String)sha1));
            SearchResponse searchResponse = searchBackend.search(searchRequest);
            this.output.chatter("SearchRequest: {} SearchResponse TH/CH {}/{}", searchResponse.getSearchRequest(), searchResponse.getTotalHits(), searchResponse.getCurrentHits());
            if (searchResponse.getCurrentHits() == 0) {
                result.put(sha1, null);
                continue;
            }
            while (searchResponse.getCurrentHits() > 0) {
                Collection<Artifact> res = this.renderArtifacts(session, searchResponse.getPage(), null);
                if (res.isEmpty()) {
                    result.put(sha1, null);
                } else {
                    for (Artifact artifact : res) {
                        result.put(sha1, artifact);
                    }
                }
                searchResponse = searchBackend.search(searchResponse.getSearchRequest().nextPage());
                this.output.chatter("SearchRequest: {} SearchResponse TH/CH {}/{}", searchResponse.getSearchRequest(), searchResponse.getTotalHits(), searchResponse.getCurrentHits());
            }
        }
        return result;
    }

    public Query toRrQuery(Artifact artifact) {
        FieldQuery result = FieldQuery.fieldQuery((Field)MAVEN.GROUP_ID, (String)artifact.getGroupId());
        result = BooleanQuery.and((Query)result, (Query[])new Query[]{FieldQuery.fieldQuery((Field)MAVEN.ARTIFACT_ID, (String)artifact.getArtifactId())});
        result = BooleanQuery.and((Query)result, (Query[])new Query[]{FieldQuery.fieldQuery((Field)MAVEN.VERSION, (String)artifact.getVersion())});
        if (artifact.getClassifier() != null && !artifact.getClassifier().isEmpty()) {
            result = BooleanQuery.and((Query)result, (Query[])new Query[]{FieldQuery.fieldQuery((Field)MAVEN.CLASSIFIER, (String)artifact.getClassifier())});
        }
        return BooleanQuery.and((Query)result, (Query[])new Query[]{FieldQuery.fieldQuery((Field)MAVEN.FILE_EXTENSION, (String)artifact.getExtension())});
    }

    public Query toSmoQuery(Artifact artifact) {
        FieldQuery result = null;
        if (!"*".equals(artifact.getGroupId())) {
            result = FieldQuery.fieldQuery((Field)MAVEN.GROUP_ID, (String)artifact.getGroupId());
        }
        if (!"*".equals(artifact.getArtifactId())) {
            Object object = result = result != null ? BooleanQuery.and((Query)result, (Query[])new Query[]{FieldQuery.fieldQuery((Field)MAVEN.ARTIFACT_ID, (String)artifact.getArtifactId())}) : FieldQuery.fieldQuery((Field)MAVEN.ARTIFACT_ID, (String)artifact.getArtifactId());
        }
        if (!"*".equals(artifact.getVersion())) {
            Object object = result = result != null ? BooleanQuery.and((Query)result, (Query[])new Query[]{FieldQuery.fieldQuery((Field)MAVEN.VERSION, (String)artifact.getVersion())}) : FieldQuery.fieldQuery((Field)MAVEN.VERSION, (String)artifact.getVersion());
        }
        if (!"*".equals(artifact.getClassifier()) && !"".equals(artifact.getClassifier())) {
            Object object = result = result != null ? BooleanQuery.and((Query)result, (Query[])new Query[]{FieldQuery.fieldQuery((Field)MAVEN.CLASSIFIER, (String)artifact.getClassifier())}) : FieldQuery.fieldQuery((Field)MAVEN.CLASSIFIER, (String)artifact.getClassifier());
        }
        if (!"*".equals(artifact.getExtension())) {
            Object object = result = result != null ? BooleanQuery.and((Query)result, (Query[])new Query[]{FieldQuery.fieldQuery((Field)MAVEN.PACKAGING, (String)artifact.getExtension())}) : FieldQuery.fieldQuery((Field)MAVEN.PACKAGING, (String)artifact.getExtension());
        }
        if (result == null) {
            throw new IllegalArgumentException("Too broad query expression");
        }
        return result;
    }
}

