/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.mima.extensions.mmr.MavenModelReader;
import eu.maveniverse.maven.mima.extensions.mmr.ModelRequest;
import eu.maveniverse.maven.mima.extensions.mmr.ModelResponse;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionSelector;
import eu.maveniverse.maven.toolbox.shared.ProjectLocator;
import eu.maveniverse.maven.toolbox.shared.ReactorLocator;
import eu.maveniverse.maven.toolbox.shared.ResolutionRoot;
import eu.maveniverse.maven.toolbox.shared.ResolutionScope;
import eu.maveniverse.maven.toolbox.shared.internal.LevelDependencySelector;
import eu.maveniverse.maven.toolbox.shared.internal.ProjectLocatorImpl;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.eclipse.aether.version.VersionScheme;

public class ToolboxResolverImpl {
    private static final String CTX_TOOLBOX = "toolbox";
    private final Output output;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession session;
    private final MavenModelReader mavenModelReader;
    private final ProjectLocator projectLocator;
    private final List<RemoteRepository> remoteRepositories;
    private final VersionScheme versionScheme;

    public ToolboxResolverImpl(Output output, RepositorySystem repositorySystem, RepositorySystemSession session, MavenModelReader mavenModelReader, List<RemoteRepository> remoteRepositories, VersionScheme versionScheme) {
        this.output = Objects.requireNonNull(output, "output");
        this.repositorySystem = Objects.requireNonNull(repositorySystem, "repositorySystem");
        this.session = Objects.requireNonNull(session, "session");
        this.mavenModelReader = Objects.requireNonNull(mavenModelReader, "mavenModelReader");
        this.projectLocator = new ProjectLocatorImpl(session, mavenModelReader);
        this.remoteRepositories = Objects.requireNonNull(remoteRepositories, "remoteRepositories");
        this.versionScheme = Objects.requireNonNull(versionScheme, "versionScheme");
    }

    public ProjectLocator projectLocator() {
        return this.projectLocator;
    }

    public ArtifactDescriptorResult readArtifactDescriptor(Artifact artifact) throws ArtifactDescriptorException {
        ArtifactDescriptorRequest artifactDescriptorRequest = new ArtifactDescriptorRequest(artifact, this.remoteRepositories, CTX_TOOLBOX);
        return this.repositorySystem.readArtifactDescriptor(this.session, artifactDescriptorRequest);
    }

    public List<Dependency> importBOMs(Collection<String> boms) throws ArtifactDescriptorException {
        HashSet keys = new HashSet();
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(this.session);
        session.setArtifactDescriptorPolicy((ArtifactDescriptorPolicy)new SimpleArtifactDescriptorPolicy(false, false));
        ArrayList<Dependency> managedDependencies = new ArrayList<Dependency>();
        for (String bomGav : boms) {
            if (null == bomGav || bomGav.isEmpty()) continue;
            DefaultArtifact bom = new DefaultArtifact(bomGav);
            ArtifactDescriptorResult artifactDescriptorResult = this.readArtifactDescriptor((Artifact)bom);
            artifactDescriptorResult.getManagedDependencies().forEach(arg_0 -> this.lambda$importBOMs$0(keys, managedDependencies, (Artifact)bom, arg_0));
        }
        return managedDependencies;
    }

    public Artifact parseGav(String gav, List<Dependency> managedDependencies) {
        try {
            return new DefaultArtifact(gav);
        }
        catch (IllegalArgumentException e) {
            if (managedDependencies != null) {
                return managedDependencies.stream().map(Dependency::getArtifact).filter(a -> gav.equals(a.getGroupId() + ":" + a.getArtifactId())).findFirst().orElseThrow(() -> e);
            }
            throw e;
        }
    }

    public RemoteRepository parseRemoteRepository(String spec) {
        String url;
        String[] parts = spec.split("::");
        String id = "mima";
        String type = "default";
        if (parts.length == 1) {
            url = parts[0];
        } else if (parts.length == 2) {
            id = parts[0];
            url = parts[1];
        } else if (parts.length == 3) {
            id = parts[0];
            type = parts[1];
            url = parts[2];
        } else {
            throw new IllegalArgumentException("Invalid remote repository spec");
        }
        return this.repositorySystem.newDeploymentRepository(this.session, new RemoteRepository.Builder(id, type, url).build());
    }

    public ResolutionRoot loadGav(String gav, Collection<String> boms) throws InvalidVersionSpecificationException, VersionRangeResolutionException, ArtifactDescriptorException {
        List<Dependency> managedDependency = this.importBOMs(boms);
        Artifact artifact = this.parseGav(gav, managedDependency);
        return this.loadRoot(ResolutionRoot.ofLoaded(artifact).withManagedDependencies(managedDependency).build());
    }

    public ResolutionRoot loadRoot(ResolutionRoot resolutionRoot) throws InvalidVersionSpecificationException, VersionRangeResolutionException, ArtifactDescriptorException {
        if (resolutionRoot.isPrepared()) {
            return resolutionRoot;
        }
        if (resolutionRoot.isLoad()) {
            Artifact resolvedVersionArtifact = this.mayResolveArtifactVersion(resolutionRoot.getArtifact(), ArtifactVersionSelector.last());
            ArtifactDescriptorResult artifactDescriptorResult = this.readArtifactDescriptor(resolvedVersionArtifact);
            resolutionRoot = ResolutionRoot.ofLoaded(resolvedVersionArtifact).withDependencies(this.mergeDeps(resolutionRoot.getDependencies(), artifactDescriptorResult.getDependencies())).withManagedDependencies(this.mergeDeps(resolutionRoot.getManagedDependencies(), artifactDescriptorResult.getManagedDependencies())).build();
        } else if (this.versionScheme.parseVersionConstraint(resolutionRoot.getArtifact().getVersion()).getRange() != null) {
            throw new IllegalArgumentException("non-loaded resolution root artifact version must be simple version but is range: " + String.valueOf(resolutionRoot.getArtifact()));
        }
        return resolutionRoot.prepared();
    }

    private List<Dependency> mergeDeps(List<Dependency> dominant, List<Dependency> recessive) {
        List<Dependency> result;
        if (dominant == null || dominant.isEmpty()) {
            result = recessive;
        } else if (recessive == null || recessive.isEmpty()) {
            result = dominant;
        } else {
            int initialCapacity = dominant.size() + recessive.size();
            result = new ArrayList<Dependency>(initialCapacity);
            HashSet<String> ids = new HashSet<String>(initialCapacity, 1.0f);
            for (Dependency dependency : dominant) {
                ids.add(ToolboxResolverImpl.getId(dependency.getArtifact()));
                result.add(dependency);
            }
            for (Dependency dependency : recessive) {
                if (ids.contains(ToolboxResolverImpl.getId(dependency.getArtifact()))) continue;
                result.add(dependency);
            }
        }
        return result;
    }

    private static String getId(Artifact a) {
        return a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getClassifier() + ":" + a.getExtension();
    }

    public CollectResult collect(ResolutionScope resolutionScope, Artifact root, List<Dependency> dependencies, List<Dependency> managedDependencies, boolean verbose) throws DependencyCollectionException {
        return this.doCollect(resolutionScope, null, root, dependencies, managedDependencies, this.remoteRepositories, -1, verbose);
    }

    public CollectResult collect(ResolutionScope resolutionScope, Artifact root, List<Dependency> dependencies, List<Dependency> managedDependencies, int dirtyMaxLevel, boolean verbose) throws DependencyCollectionException {
        return this.doCollect(resolutionScope, null, root, dependencies, managedDependencies, this.remoteRepositories, dirtyMaxLevel, verbose);
    }

    public CollectResult collect(ResolutionScope resolutionScope, Dependency root, List<Dependency> dependencies, List<Dependency> managedDependencies, boolean verbose) throws DependencyCollectionException {
        return this.doCollect(resolutionScope, root, null, dependencies, managedDependencies, this.remoteRepositories, -1, verbose);
    }

    public CollectResult collect(ResolutionScope resolutionScope, Dependency root, List<Dependency> dependencies, List<Dependency> managedDependencies, int dirtyMaxLevel, boolean verbose) throws DependencyCollectionException {
        return this.doCollect(resolutionScope, root, null, dependencies, managedDependencies, this.remoteRepositories, dirtyMaxLevel, verbose);
    }

    public CollectResult collectDm(Artifact root, List<Dependency> managedDependencies, boolean verbose) throws ArtifactDescriptorException, ArtifactResolutionException, VersionResolutionException {
        return this.doCollectDm(null, root, managedDependencies, this.remoteRepositories, verbose);
    }

    public CollectResult collectDm(Dependency root, List<Dependency> managedDependencies, boolean verbose) throws ArtifactDescriptorException, ArtifactResolutionException, VersionResolutionException {
        return this.doCollectDm(root, null, managedDependencies, this.remoteRepositories, verbose);
    }

    public CollectResult parentChildTree(ReactorLocator reactorLocator) {
        CollectRequest collectRequest = new CollectRequest();
        ProjectLocator.Project startingProject = reactorLocator.getCurrentProject();
        collectRequest.setRoot(new Dependency(this.source(startingProject), ""));
        CollectResult result = new CollectResult(collectRequest);
        ProjectLocator.Project currentProject = startingProject;
        result.setRoot((DependencyNode)new DefaultDependencyNode(collectRequest.getRoot()));
        DependencyNode leaf = result.getRoot();
        Optional<Object> parentArtifact = currentProject.getParent();
        while (parentArtifact.isPresent()) {
            DefaultDependencyNode node;
            Artifact pa = parentArtifact.orElseThrow();
            Optional<ProjectLocator.Project> parentProject = reactorLocator.locateProject(pa);
            if (parentProject.isPresent()) {
                currentProject = parentProject.orElseThrow();
                node = new DefaultDependencyNode(new Dependency(this.source(currentProject), ""));
            } else {
                Optional<ProjectLocator.Project> external = this.projectLocator.locateProject(pa);
                if (external.isPresent()) {
                    currentProject = external.orElseThrow();
                    node = new DefaultDependencyNode(new Dependency(this.source(currentProject), ""));
                } else {
                    currentProject = null;
                    node = new DefaultDependencyNode(new Dependency(pa, ""));
                }
            }
            node.getChildren().add(result.getRoot());
            result.setRoot((DependencyNode)node);
            parentArtifact = currentProject != null ? currentProject.getParent() : Optional.empty();
        }
        this.parentChildTree(leaf, reactorLocator, startingProject);
        return result;
    }

    private void parentChildTree(DependencyNode parentNode, ReactorLocator reactorLocator, ProjectLocator.Project parent) {
        List<ProjectLocator.Project> children = reactorLocator.locateChildren(parent);
        for (ProjectLocator.Project child : children) {
            DefaultDependencyNode childNode = new DefaultDependencyNode(new Dependency(this.source(child), ""));
            parentNode.getChildren().add(childNode);
            this.parentChildTree((DependencyNode)childNode, reactorLocator, child);
        }
    }

    public CollectResult subprojectTree(ReactorLocator reactorLocator) {
        CollectRequest collectRequest = new CollectRequest();
        ProjectLocator.Project startingProject = reactorLocator.getCurrentProject();
        collectRequest.setRoot(new Dependency(this.source(startingProject), ""));
        CollectResult result = new CollectResult(collectRequest);
        result.setRoot((DependencyNode)new DefaultDependencyNode(collectRequest.getRoot()));
        this.subprojectTree(result.getRoot(), reactorLocator, startingProject);
        return result;
    }

    private void subprojectTree(DependencyNode parentNode, ReactorLocator reactorLocator, ProjectLocator.Project parent) {
        List<ProjectLocator.Project> children = reactorLocator.locateCollected(parent);
        for (ProjectLocator.Project child : children) {
            DefaultDependencyNode childNode = new DefaultDependencyNode(new Dependency(this.source(child), ""));
            parentNode.getChildren().add(childNode);
            this.subprojectTree((DependencyNode)childNode, reactorLocator, child);
        }
    }

    public CollectResult projectDependencyTree(ReactorLocator reactorLocator, boolean showExternal) {
        CollectRequest collectRequest = new CollectRequest();
        ProjectLocator.Project rootProject = reactorLocator.getCurrentProject();
        collectRequest.setRoot(new Dependency(this.source(rootProject), ""));
        CollectResult result = new CollectResult(collectRequest);
        result.setRoot((DependencyNode)new DefaultDependencyNode(collectRequest.getRoot()));
        this.projectDependencyTree(result.getRoot(), reactorLocator, rootProject, showExternal, new HashSet<String>());
        return result;
    }

    private void projectDependencyTree(DependencyNode node, ReactorLocator reactorLocator, ProjectLocator.Project current, boolean showExternal, HashSet<String> seen) {
        ArrayDeque<DefaultDependencyNode> recursiveNodes = new ArrayDeque<DefaultDependencyNode>();
        for (Dependency dependency : current.dependencies()) {
            Optional<ProjectLocator.Project> depProject = reactorLocator.locateProject(dependency.getArtifact());
            String key = ArtifactIdUtils.toId((Artifact)dependency.getArtifact());
            if (!seen.add(key)) continue;
            if (depProject.isPresent()) {
                ProjectLocator.Project subProject = depProject.orElseThrow();
                DefaultDependencyNode subNode = new DefaultDependencyNode(dependency.setArtifact(this.source(subProject)));
                subNode.setData(ProjectLocator.Project.class, (Object)subProject);
                node.getChildren().add(subNode);
                recursiveNodes.add(subNode);
                continue;
            }
            if (!showExternal) continue;
            DefaultDependencyNode subNode = new DefaultDependencyNode(dependency.setArtifact(this.source(dependency.getArtifact(), true)));
            node.getChildren().add(subNode);
        }
        while (!recursiveNodes.isEmpty()) {
            DependencyNode recursiveNode = (DependencyNode)recursiveNodes.pop();
            ProjectLocator.Project recursiveProject = (ProjectLocator.Project)recursiveNode.getData().get(ProjectLocator.Project.class);
            this.projectDependencyTree(recursiveNode, reactorLocator, recursiveProject, showExternal, seen);
        }
    }

    private Artifact source(ProjectLocator.Project project) {
        return this.source(project.artifact(), project.origin() == this.projectLocator);
    }

    private Artifact source(Artifact artifact, boolean external) {
        HashMap<String, String> properties = new HashMap<String, String>(artifact.getProperties());
        properties.put("source", external ? "external" : "internal");
        return artifact.setProperties(properties);
    }

    public DependencyResult resolve(ResolutionScope resolutionScope, Artifact root, List<Dependency> dependencies, List<Dependency> managedDependencies) throws DependencyResolutionException {
        return this.doResolve(resolutionScope, null, root, dependencies, managedDependencies, this.remoteRepositories);
    }

    public DependencyResult resolve(ResolutionScope resolutionScope, Dependency root, List<Dependency> dependencies, List<Dependency> managedDependencies) throws DependencyResolutionException {
        return this.doResolve(resolutionScope, root, null, dependencies, managedDependencies, this.remoteRepositories);
    }

    private CollectResult doCollect(ResolutionScope resolutionScope, Dependency rootDependency, Artifact root, List<Dependency> dependencies, List<Dependency> managedDependencies, List<RemoteRepository> remoteRepositories, int dirtyMaxLevel, boolean verbose) throws DependencyCollectionException {
        boolean dirtyTree;
        Objects.requireNonNull(resolutionScope);
        if (rootDependency == null && root == null) {
            throw new NullPointerException("one of rootDependency or root must be non-null");
        }
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(this.session);
        session.setConfigProperty("aether.dependencyManager.verbose", (Object)true);
        if (verbose) {
            session.setConfigProperty("aether.conflictResolver.verbose", (Object)ConflictResolver.Verbosity.FULL);
        }
        boolean bl = dirtyTree = dirtyMaxLevel > 0;
        if (dirtyTree) {
            session.setDependencySelector((DependencySelector)new LevelDependencySelector(dirtyMaxLevel));
            session.setDependencyGraphTransformer(null);
        }
        CollectRequest collectRequest = new CollectRequest();
        if (rootDependency != null) {
            root = rootDependency.getArtifact();
        }
        collectRequest.setRootArtifact(root);
        if (dirtyTree) {
            collectRequest.setDependencies(dependencies);
        } else {
            collectRequest.setDependencies(dependencies.stream().filter(d -> !resolutionScope.isEliminateTest() || !"test".equals(d.getScope())).collect(Collectors.toList()));
        }
        collectRequest.setManagedDependencies(managedDependencies);
        collectRequest.setRepositories(remoteRepositories);
        collectRequest.setRequestContext(CTX_TOOLBOX);
        collectRequest.setTrace(RequestTrace.newChild(null, (Object)collectRequest));
        this.output.chatter("Collecting {} @ {}", collectRequest, resolutionScope.name());
        CollectResult result = this.repositorySystem.collectDependencies((RepositorySystemSession)session, collectRequest);
        if (!dirtyTree && !verbose && resolutionScope != ResolutionScope.TEST) {
            ArrayList<DependencyNode> childrenToRemove = new ArrayList<DependencyNode>();
            for (DependencyNode node : result.getRoot().getChildren()) {
                if (resolutionScope.getDirectInclude().contains(node.getDependency().getScope())) continue;
                childrenToRemove.add(node);
            }
            if (!childrenToRemove.isEmpty()) {
                result.getRoot().getChildren().removeAll(childrenToRemove);
            }
        }
        return result;
    }

    private CollectResult doCollectDm(Dependency rootDependency, Artifact root, List<Dependency> managedDependencies, List<RemoteRepository> remoteRepositories, boolean verbose) throws ArtifactDescriptorException, ArtifactResolutionException, VersionResolutionException {
        if (rootDependency == null && root == null) {
            throw new NullPointerException("one of rootDependency or root must be non-null");
        }
        CollectRequest collectRequest = new CollectRequest();
        if (rootDependency != null) {
            root = rootDependency.getArtifact();
        }
        collectRequest.setRootArtifact(root);
        collectRequest.setManagedDependencies(managedDependencies);
        collectRequest.setRepositories(remoteRepositories);
        collectRequest.setRequestContext(CTX_TOOLBOX);
        collectRequest.setTrace(RequestTrace.newChild(null, (Object)collectRequest));
        this.output.chatter("Collecting depMgt {}", root);
        CollectResult result = new CollectResult(collectRequest);
        DefaultDependencyNode rootNode = new DefaultDependencyNode(rootDependency != null ? rootDependency.getArtifact() : root);
        result.setRoot((DependencyNode)rootNode);
        HashMap<String, LinkedHashSet<String>> encounters = new HashMap<String, LinkedHashSet<String>>();
        this.doCollectDmRecursive(rootNode, encounters);
        Map<String, LinkedHashSet> conflicts = encounters.entrySet().stream().filter(e -> ((LinkedHashSet)e.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!conflicts.isEmpty()) {
            this.output.warn("DM conflicts discovered:", new Object[0]);
            for (Map.Entry<String, LinkedHashSet> entry : conflicts.entrySet()) {
                this.output.warn(" * {} version {} prevails, but met versions {}", entry.getKey(), entry.getValue().getFirst(), entry.getValue());
            }
        }
        return result;
    }

    private void doCollectDmRecursive(DefaultDependencyNode currentRoot, Map<String, LinkedHashSet<String>> encounters) throws ArtifactDescriptorException, ArtifactResolutionException, VersionResolutionException {
        ModelResponse modelResponse = this.mavenModelReader.readModel(ModelRequest.builder().setArtifact(currentRoot.getArtifact()).setRequestContext(CTX_TOOLBOX).build());
        Model rawModel = null;
        for (String lineage : modelResponse.getLineage()) {
            Model current = modelResponse.getLineageModel(lineage);
            if (rawModel == null) {
                rawModel = current;
                continue;
            }
            if (current.getDependencyManagement() == null) continue;
            if (rawModel.getDependencyManagement() == null) {
                rawModel.setDependencyManagement(new DependencyManagement());
            }
            rawModel.getDependencyManagement().getDependencies().addAll(0, current.getDependencyManagement().getDependencies());
        }
        for (Dependency managedDependency : modelResponse.toArtifactDescriptorResult(modelResponse.interpolateModel(rawModel)).getManagedDependencies()) {
            DefaultDependencyNode child = new DefaultDependencyNode(managedDependency);
            currentRoot.getChildren().add(child);
            String key = ArtifactIdUtils.toVersionlessId((Artifact)managedDependency.getArtifact());
            encounters.computeIfAbsent(key, k -> new LinkedHashSet()).add(managedDependency.getArtifact().getVersion());
            if (!"import".equals(child.getDependency().getScope())) continue;
            this.doCollectDmRecursive(child, encounters);
        }
    }

    private DependencyResult doResolve(ResolutionScope resolutionScope, Dependency rootDependency, Artifact root, List<Dependency> dependencies, List<Dependency> managedDependencies, List<RemoteRepository> remoteRepositories) throws DependencyResolutionException {
        Objects.requireNonNull(resolutionScope);
        if (rootDependency == null && root == null) {
            throw new NullPointerException("one of rootDependency or root must be non-null");
        }
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(this.session);
        CollectRequest collectRequest = new CollectRequest();
        if (rootDependency != null) {
            root = rootDependency.getArtifact();
        }
        collectRequest.setRootArtifact(root);
        collectRequest.setDependencies(dependencies.stream().filter(d -> !resolutionScope.isEliminateTest() || !"test".equals(d.getScope())).collect(Collectors.toList()));
        collectRequest.setManagedDependencies(managedDependencies);
        collectRequest.setRepositories(remoteRepositories);
        collectRequest.setRequestContext(CTX_TOOLBOX);
        collectRequest.setTrace(RequestTrace.newChild(null, (Object)collectRequest));
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, resolutionScope.getDependencyFilter());
        this.output.chatter("Resolving {} @ {}", dependencyRequest, resolutionScope.name());
        DependencyResult result = this.repositorySystem.resolveDependencies((RepositorySystemSession)session, dependencyRequest);
        try {
            ArtifactResult rootResult = this.resolveArtifacts(Collections.singletonList(root)).getFirst();
            DefaultDependencyNode newRoot = new DefaultDependencyNode(new Dependency(rootResult.getArtifact(), ""));
            newRoot.setChildren(result.getRoot().getChildren());
            result.setRoot((DependencyNode)newRoot);
            result.getArtifactResults().addFirst(rootResult);
            return result;
        }
        catch (ArtifactResolutionException e) {
            throw new DependencyResolutionException(result, (Throwable)e);
        }
    }

    public ArtifactResult resolveArtifact(Artifact artifact) throws ArtifactResolutionException {
        Objects.requireNonNull(artifact);
        return this.resolveArtifacts(Collections.singleton(artifact)).getFirst();
    }

    public List<ArtifactResult> resolveArtifacts(Collection<Artifact> artifacts) throws ArtifactResolutionException {
        Objects.requireNonNull(artifacts);
        ArrayList artifactRequests = new ArrayList();
        artifacts.forEach(a -> artifactRequests.add(new ArtifactRequest(a, this.remoteRepositories, null)));
        return this.repositorySystem.resolveArtifacts(this.session, artifactRequests);
    }

    public Artifact mayResolveArtifactVersion(Artifact artifact, BiFunction<Artifact, List<Version>, String> artifactVersionSelector) throws InvalidVersionSpecificationException, VersionRangeResolutionException {
        String version;
        VersionConstraint versionConstraint = this.versionScheme.parseVersionConstraint(artifact.getVersion());
        if (versionConstraint.getRange() != null) {
            VersionRangeResult versionRangeResult = this.repositorySystem.resolveVersionRange(this.session, new VersionRangeRequest(artifact, this.remoteRepositories, CTX_TOOLBOX));
            version = artifactVersionSelector.apply(artifact, versionRangeResult.getVersions());
        } else {
            version = versionConstraint.getVersion().toString();
        }
        return artifact.setVersion(version);
    }

    public Version findNewestVersion(Artifact artifact, Predicate<Version> filter) throws VersionRangeResolutionException {
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), "[0,)"));
        rangeRequest.setRepositories(this.remoteRepositories);
        rangeRequest.setRequestContext(CTX_TOOLBOX);
        VersionRangeResult result = this.repositorySystem.resolveVersionRange(this.session, rangeRequest);
        Version highest = result.getHighestVersion();
        if (filter.test(highest)) {
            return highest;
        }
        for (int idx = result.getVersions().size() - 1; idx >= 0; --idx) {
            highest = (Version)result.getVersions().get(idx);
            if (!filter.test(highest)) continue;
            return highest;
        }
        return null;
    }

    public List<Version> findNewerVersions(Artifact artifact, Predicate<Version> filter) throws VersionRangeResolutionException {
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), (String)(artifact.getVersion().contains(",") ? artifact.getVersion() : "(" + artifact.getVersion() + ",)")));
        rangeRequest.setRepositories(this.remoteRepositories);
        rangeRequest.setRequestContext(CTX_TOOLBOX);
        VersionRangeResult result = this.repositorySystem.resolveVersionRange(this.session, rangeRequest);
        return result.getVersions().stream().filter(filter).collect(Collectors.toList());
    }

    public List<Artifact> listAvailablePlugins(Collection<String> groupIds) throws Exception {
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(this.session);
        session.setUpdatePolicy("always");
        RequestTrace trace = RequestTrace.newChild(null, (Object)this);
        ArrayList<MetadataRequest> requests = new ArrayList<MetadataRequest>();
        for (String groupId : groupIds) {
            DefaultMetadata metadata = new DefaultMetadata(groupId, "maven-metadata.xml", Metadata.Nature.RELEASE);
            for (RemoteRepository repository : this.remoteRepositories) {
                requests.add(new MetadataRequest((Metadata)metadata, repository, CTX_TOOLBOX).setTrace(trace));
            }
        }
        HashSet<CallSite> processedGAs = new HashSet<CallSite>();
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        List results = this.repositorySystem.resolveMetadata((RepositorySystemSession)session, requests);
        for (MetadataResult res : results) {
            Metadata metadata = res.getMetadata();
            if (metadata == null || metadata.getFile() == null || !metadata.getFile().isFile()) continue;
            InputStream inputStream = Files.newInputStream(metadata.getFile().toPath(), new OpenOption[0]);
            try {
                org.apache.maven.artifact.repository.metadata.Metadata pluginGroupMetadata = new MetadataXpp3Reader().read(inputStream, false);
                List plugins = pluginGroupMetadata.getPlugins();
                for (Plugin plugin : plugins) {
                    DefaultArtifact blueprint;
                    Version newestVersion;
                    if (!processedGAs.add((CallSite)((Object)(metadata.getGroupId() + ":" + plugin.getArtifactId()))) || (newestVersion = this.findNewestVersion((Artifact)(blueprint = new DefaultArtifact(metadata.getGroupId(), plugin.getArtifactId(), "jar", "0")), ArtifactVersionMatcher.not(ArtifactVersionMatcher.snapshot()))) == null) continue;
                    result.add((Artifact)new DefaultArtifact(blueprint.getGroupId(), blueprint.getArtifactId(), blueprint.getExtension(), newestVersion.toString()));
                }
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        return result;
    }

    private /* synthetic */ void lambda$importBOMs$0(HashSet keys, ArrayList managedDependencies, Artifact bom, Dependency d) {
        if (keys.add(ArtifactIdUtils.toVersionlessId((Artifact)d.getArtifact()))) {
            managedDependencies.add(d);
        } else {
            this.output.warn("BOM {} introduced an already managed dependency {}", bom, d);
        }
    }
}

