/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class SpecParser {
    private SpecParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Op parse(String spec) {
        Objects.requireNonNull(spec);
        Op root = null;
        ArrayDeque<Op> path = new ArrayDeque<Op>();
        Object value = "";
        boolean wasComma = false;
        for (int idx = 0; idx < spec.length(); ++idx) {
            StringLiteral literal;
            char ch = spec.charAt(idx);
            if (Character.isWhitespace(ch)) continue;
            if (Character.isAlphabetic(ch) || Character.isDigit(ch) || '*' == ch || ':' == ch || '.' == ch || '-' == ch || '/' == ch || '\\' == ch || '$' == ch || '{' == ch || '}' == ch) {
                value = (String)value + ch;
                continue;
            }
            if ('(' == ch) {
                Op op = new Op((String)value);
                if (root == null) {
                    root = op;
                }
                value = "";
                if (!path.isEmpty()) {
                    ((Node)path.peek()).addChild(op);
                }
                wasComma = false;
                path.push(op);
                continue;
            }
            if (')' == ch) {
                if (!((String)value).isEmpty()) {
                    literal = new StringLiteral((String)value);
                    value = "";
                    if (path.isEmpty()) throw new IllegalArgumentException("misplaced closing braces");
                    ((Node)path.peek()).addChild(literal);
                } else if (wasComma) {
                    throw new IllegalArgumentException("misplaced comma");
                }
                wasComma = false;
                path.pop();
                continue;
            }
            if (',' != ch) throw new IllegalArgumentException("invalid character: " + ch);
            if (!((String)value).isEmpty()) {
                literal = new StringLiteral((String)value);
                value = "";
                if (path.isEmpty()) throw new IllegalArgumentException("misplaced comma");
                ((Node)path.peek()).addChild(literal);
            } else if (wasComma) {
                throw new IllegalArgumentException("misplaced comma");
            }
            wasComma = true;
        }
        if (root != null && path.isEmpty()) return root;
        throw new IllegalArgumentException("invalid spec string");
    }

    public static final class Op
    extends Node {
        Op(String name) {
            super(name);
        }
    }

    public static class Node {
        private final String value;
        private final List<Node> children;

        private Node(String value) {
            this.value = value;
            this.children = new ArrayList<Node>();
        }

        public String getValue() {
            return this.value;
        }

        public void addChild(Node node) {
            this.children.add(node);
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public boolean accept(Visitor visitor) {
            block1: {
                if (!visitor.visitEnter(this)) break block1;
                for (Node child : this.children) {
                    if (!child.accept(visitor)) break;
                }
            }
            return visitor.visitExit(this);
        }
    }

    public static class StringLiteral
    extends Literal {
        StringLiteral(String value) {
            super(value);
        }
    }

    public static abstract class Literal
    extends Node {
        private Literal(String value) {
            super(value);
        }

        @Override
        public void addChild(Node node) {
            throw new IllegalStateException("string literal is leaf");
        }

        @Override
        public List<Node> getChildren() {
            return Collections.emptyList();
        }
    }

    public static abstract class Builder
    implements Visitor {
        protected final ArrayList<Object> params = new ArrayList();
        protected final Map<String, ?> properties;

        public Builder(Map<String, ?> properties) {
            this.properties = new HashMap(properties);
        }

        @Override
        public boolean visitEnter(Node node) {
            return true;
        }

        @Override
        public boolean visitExit(Node node) {
            if (node instanceof Literal) {
                this.processLiteral(node);
            } else if (node instanceof Op) {
                this.processOp(node);
            }
            return true;
        }

        protected void processLiteral(Node node) {
            String value = node.getValue();
            if (value.startsWith("${") && value.endsWith("}")) {
                Object referenced = this.properties.get(value.substring(2, value.length() - 1));
                if (referenced == null) {
                    referenced = "";
                }
                this.params.add(referenced);
            } else {
                this.params.add(value);
            }
        }

        protected abstract void processOp(Node var1);

        protected String stringParam(String op) {
            if (this.params.isEmpty()) {
                throw new IllegalArgumentException("bad parameter count for " + op);
            }
            return (String)this.params.removeLast();
        }

        protected List<String> stringParams(String op) {
            ArrayList<String> result = new ArrayList<String>();
            while (!this.params.isEmpty() && this.params.getLast() instanceof String) {
                result.add(this.stringParam(op));
            }
            return result;
        }

        protected boolean booleanParam(String op) {
            if (this.params.isEmpty()) {
                throw new IllegalArgumentException("bad parameter count for " + op);
            }
            return Boolean.parseBoolean((String)this.params.removeLast());
        }

        protected int intParam(String op) {
            if (this.params.isEmpty()) {
                throw new IllegalArgumentException("bad parameter count for " + op);
            }
            return Integer.parseInt((String)this.params.removeLast());
        }

        protected <T> T typedParam(Class<T> clazz, String op) {
            if (this.params.isEmpty()) {
                throw new IllegalArgumentException("bad parameter count for " + op);
            }
            return clazz.cast(this.params.removeLast());
        }

        protected <T> Collection<T> typedParams(Class<T> clazz, String op) {
            ArrayList<T> result = new ArrayList<T>();
            while (!this.params.isEmpty() && clazz.isInstance(this.params.getLast())) {
                result.add(this.typedParam(clazz, op));
            }
            return result;
        }

        public <T> T build(Class<T> clazz) {
            if (this.params.size() != 1) {
                throw new IllegalArgumentException("bad spec");
            }
            return clazz.cast(this.params.getFirst());
        }
    }

    public static final class Dump
    implements Visitor {
        private final ArrayDeque<Node> nodes = new ArrayDeque();

        @Override
        public boolean visitEnter(Node node) {
            System.out.println(IntStream.rangeClosed(0, this.nodes.size()).mapToObj(i -> "  ").collect(Collectors.joining()) + node.getValue() + (node instanceof Literal ? " (lit)" : " (op)"));
            this.nodes.push(node);
            return true;
        }

        @Override
        public boolean visitExit(Node node) {
            if (!this.nodes.isEmpty()) {
                this.nodes.pop();
            }
            return true;
        }
    }

    public static interface Visitor {
        public boolean visitEnter(Node var1);

        public boolean visitExit(Node var1);
    }
}

