/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.toolbox.shared.Sink;
import eu.maveniverse.maven.toolbox.shared.internal.Artifacts;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.aether.artifact.Artifact;

public final class MultiArtifactSink
implements Artifacts.Sink {
    private final Output output;
    private final Map<Predicate<Artifact>, Sink<Artifact>> sinks;
    private final boolean missedArtifactFails;

    public static MultiArtifactSinkBuilder builder(Output output) {
        return new MultiArtifactSinkBuilder(output);
    }

    private MultiArtifactSink(Output output, LinkedHashMap<Predicate<Artifact>, Sink<Artifact>> sinks, boolean missedArtifactFails) {
        this.output = Objects.requireNonNull(output, "output");
        this.sinks = Collections.unmodifiableMap(sinks);
        this.missedArtifactFails = missedArtifactFails;
    }

    @Override
    public void accept(Artifact artifact) throws IOException {
        boolean processed = false;
        for (Map.Entry<Predicate<Artifact>, Sink<Artifact>> sink : this.sinks.entrySet()) {
            if (!sink.getKey().test(artifact)) continue;
            sink.getValue().accept(artifact);
            processed = true;
            break;
        }
        if (!processed && this.missedArtifactFails) {
            throw new IllegalStateException("Nobody accepted artifact: " + String.valueOf(artifact));
        }
        this.output.chatter("Processed {}: {}", artifact, processed ? "OK" : "MISSED");
    }

    @Override
    public void cleanup(Exception e) {
        this.sinks.values().forEach(a -> a.cleanup(e));
    }

    @Override
    public void close() throws Exception {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Sink<Artifact> sink : this.sinks.values()) {
            try {
                sink.close();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            IllegalStateException ex = new IllegalStateException("Closing failed");
            exceptions.forEach(ex::addSuppressed);
            throw ex;
        }
    }

    public static final class MultiArtifactSinkBuilder {
        private final Output output;
        private final LinkedHashMap<Predicate<Artifact>, Sink<Artifact>> sinks;
        private boolean missedArtifactFails = true;

        private MultiArtifactSinkBuilder(Output output) {
            this.output = Objects.requireNonNull(output, "output");
            this.sinks = new LinkedHashMap();
        }

        public MultiArtifactSinkBuilder setMissedArtifactFails(boolean missedArtifactFails) {
            this.missedArtifactFails = missedArtifactFails;
            return this;
        }

        public MultiArtifactSinkBuilder addSink(Predicate<Artifact> artifactMatcher, Sink<Artifact> sink) {
            Objects.requireNonNull(artifactMatcher, "artifactMatcher");
            Objects.requireNonNull(sink, "sink");
            this.sinks.put(artifactMatcher, sink);
            return this;
        }

        public MultiArtifactSink build() {
            return new MultiArtifactSink(this.output, this.sinks, this.missedArtifactFails);
        }
    }
}

