/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.toolbox.shared.internal.Artifacts;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3ReaderEx;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalRepositorySource
implements Artifacts.Source {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Path directory;
    private final MavenXpp3ReaderEx reader;

    public static LocalRepositorySource local(Path directory) {
        return new LocalRepositorySource(directory);
    }

    private LocalRepositorySource(Path directory) {
        this.directory = Objects.requireNonNull(directory, "directory").toAbsolutePath();
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("directory must exists");
        }
        this.reader = new MavenXpp3ReaderEx();
    }

    public Path getDirectory() {
        return this.directory;
    }

    @Override
    public Stream<Artifact> get() throws IOException {
        return this.poms().map(this::pomToArtifact).filter(Objects::nonNull).flatMap(this::collectPomArtifacts).filter(Objects::nonNull);
    }

    private Stream<Path> poms() {
        final ArrayList poms = new ArrayList();
        final PathMatcher pomMatcher = this.directory.getFileSystem().getPathMatcher("glob:**/*.pom");
        try {
            Files.walkFileTree(this.directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (pomMatcher.matches(file)) {
                        poms.add(file);
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return poms.stream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Artifact pomToArtifact(Path file) {
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            String v;
            String a;
            Model model = this.reader.read(is, false, null);
            String g = model.getGroupId();
            if (g == null || g.trim().isEmpty()) {
                g = model.getParent().getGroupId();
            }
            if ((a = model.getArtifactId()) == null || a.trim().isEmpty()) {
                a = model.getParent().getArtifactId();
            }
            if ((v = model.getVersion()) == null || v.trim().isEmpty()) {
                v = model.getParent().getVersion();
            }
            if (g == null) return null;
            if (a == null) return null;
            if (v == null) return null;
            Artifact artifact = new DefaultArtifact(g, a, null, "pom", v).setFile(file.toFile());
            return artifact;
        }
        catch (IOException | XmlPullParserException e) {
            this.logger.info("Could not parse POM at {}", (Object)file, (Object)e);
        }
        return null;
    }

    private Stream<Artifact> collectPomArtifacts(Artifact pom) {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        result.add(pom);
        String pomFileName = pom.getFile().getName();
        String fileNamePrefix = pomFileName.substring(0, pom.getFile().getName().length() - 4);
        try (Stream<Path> files = Files.list(pom.getFile().toPath().getParent());){
            files.filter(LocalRepositorySource.notItselfAndNotChecksum(pomFileName, fileNamePrefix)).forEach(p -> {
                String filename = p.getFileName().toString().substring(fileNamePrefix.length());
                if (filename.startsWith(".")) {
                    result.add(new SubArtifact(pom, null, filename.substring(1)).setFile(p.toFile()));
                } else if (filename.startsWith("-")) {
                    String classifier = filename.substring(1, filename.indexOf("."));
                    String extension = filename.substring(filename.indexOf(".") + 1);
                    result.add(new SubArtifact(pom, classifier, extension).setFile(p.toFile()));
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return result.stream();
    }

    private static Predicate<Path> notItselfAndNotChecksum(String fname, String prefix) {
        return p -> {
            String filename = p.getFileName().toString();
            return !fname.equals(filename) && filename.startsWith(prefix) && !filename.endsWith(".sha1") && !filename.endsWith(".md5");
        };
    }
}

