/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.toolbox.shared.ArtifactMapper;
import eu.maveniverse.maven.toolbox.shared.ArtifactMatcher;
import eu.maveniverse.maven.toolbox.shared.Source;
import eu.maveniverse.maven.toolbox.shared.internal.Artifacts;
import eu.maveniverse.maven.toolbox.shared.internal.DirectorySource;
import eu.maveniverse.maven.toolbox.shared.internal.LocalRepositorySource;
import eu.maveniverse.maven.toolbox.shared.internal.SpecParser;
import eu.maveniverse.maven.toolbox.shared.internal.ToolboxCommandoImpl;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public final class ArtifactSources {
    private ArtifactSources() {
    }

    public static Artifacts.Source build(Map<String, ?> properties, ToolboxCommandoImpl tc, String spec) {
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(tc, "tc");
        Objects.requireNonNull(spec, "spec");
        ArtifactSourceBuilder builder = new ArtifactSourceBuilder(properties, tc);
        SpecParser.parse(spec).accept(builder);
        return builder.build();
    }

    public static NullArtifactSource nullArtifactSource() {
        return new NullArtifactSource();
    }

    public static MatchingArtifactSource matchingArtifactSource(Predicate<Artifact> artifactMatcher, Source<Artifact> delegate) {
        Objects.requireNonNull(artifactMatcher, "artifactMatcher");
        Objects.requireNonNull(delegate, "delegate");
        return new MatchingArtifactSource(artifactMatcher, delegate);
    }

    public static MappingArtifactSource mappingArtifactSource(Function<Artifact, Artifact> artifactMapper, Source<Artifact> delegate) {
        Objects.requireNonNull(artifactMapper, "artifactMapper");
        Objects.requireNonNull(delegate, "delegate");
        return new MappingArtifactSource(artifactMapper, delegate);
    }

    public static Source<Artifact> gavArtifactSource(String gav) {
        Objects.requireNonNull(gav, "gav");
        return new GavArtifactSource(gav);
    }

    public static Source<Artifact> concatArtifactSource(Collection<Source<Artifact>> sources) {
        Objects.requireNonNull(sources, "sources");
        return new ConcatArtifactSource(sources);
    }

    static class ArtifactSourceBuilder
    extends SpecParser.Builder {
        private final ToolboxCommandoImpl tc;

        public ArtifactSourceBuilder(Map<String, ?> properties, ToolboxCommandoImpl tc) {
            super(properties);
            this.tc = tc;
        }

        @Override
        public boolean visitEnter(SpecParser.Node node) {
            return super.visitEnter(node) && !"matching".equals(node.getValue()) && !"mapping".equals(node.getValue());
        }

        @Override
        protected void processOp(SpecParser.Node node) {
            switch (node.getValue()) {
                case "null": {
                    this.params.add(ArtifactSources.nullArtifactSource());
                    break;
                }
                case "gav": {
                    String gav = this.stringParam(node.getValue());
                    this.params.add(ArtifactSources.gavArtifactSource(gav));
                    break;
                }
                case "directory": {
                    Path p0 = this.tc.basedir().resolve(this.stringParam(node.getValue()));
                    this.params.add(DirectorySource.directory(p0));
                    break;
                }
                case "sessionLocalRepository": {
                    this.params.add(LocalRepositorySource.local(this.tc.session().getLocalRepository().getBasedir().toPath()));
                    break;
                }
                case "localRepository": {
                    Path p0 = this.tc.basedir().resolve(this.stringParam(node.getValue()));
                    this.params.add(LocalRepositorySource.local(p0));
                    break;
                }
                case "recorder": {
                    this.params.add(this.tc.recorder());
                    break;
                }
                case "matching": {
                    if (node.getChildren().size() != 2) {
                        throw new IllegalArgumentException("op matching accepts only 2 argument");
                    }
                    ArtifactMatcher.ArtifactMatcherBuilder matcherBuilder = new ArtifactMatcher.ArtifactMatcherBuilder(this.properties);
                    node.getChildren().getFirst().accept(matcherBuilder);
                    ArtifactMatcher matcher = matcherBuilder.build();
                    ArtifactSourceBuilder sourceBuilder = new ArtifactSourceBuilder(this.properties, this.tc);
                    node.getChildren().get(1).accept(sourceBuilder);
                    Artifacts.Source delegate = sourceBuilder.build();
                    this.params.add(ArtifactSources.matchingArtifactSource(matcher, delegate));
                    node.getChildren().clear();
                    break;
                }
                case "mapping": {
                    if (node.getChildren().size() != 2) {
                        throw new IllegalArgumentException("op mapping accepts only 2 argument");
                    }
                    ArtifactMapper.ArtifactMapperBuilder mapperBuilder = new ArtifactMapper.ArtifactMapperBuilder(this.properties);
                    node.getChildren().getFirst().accept(mapperBuilder);
                    ArtifactMapper mapper = mapperBuilder.build();
                    ArtifactSourceBuilder sourceBuilder = new ArtifactSourceBuilder(this.properties, this.tc);
                    node.getChildren().get(1).accept(sourceBuilder);
                    Artifacts.Source delegate = sourceBuilder.build();
                    this.params.add(ArtifactSources.mappingArtifactSource(mapper, delegate));
                    node.getChildren().clear();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown op " + node.getValue());
                }
            }
        }

        public Artifacts.Source build() {
            return this.build(Artifacts.Source.class);
        }
    }

    public static class NullArtifactSource
    implements Artifacts.Source {
        private NullArtifactSource() {
        }

        @Override
        public Stream<Artifact> get() throws IOException {
            return Stream.empty();
        }
    }

    public static class MatchingArtifactSource
    extends DelegatingArtifactSource {
        private final Predicate<Artifact> artifactMatcher;

        private MatchingArtifactSource(Predicate<Artifact> artifactMatcher, Source<Artifact> delegate) {
            super(delegate);
            this.artifactMatcher = artifactMatcher;
        }

        @Override
        public Stream<Artifact> get() throws IOException {
            return super.get().filter(this.artifactMatcher);
        }
    }

    public static class MappingArtifactSource
    extends DelegatingArtifactSource {
        private final Function<Artifact, Artifact> artifactMapper;

        private MappingArtifactSource(Function<Artifact, Artifact> artifactMapper, Source<Artifact> delegate) {
            super(delegate);
            this.artifactMapper = artifactMapper;
        }

        @Override
        public Stream<Artifact> get() throws IOException {
            return super.get().map(this.artifactMapper);
        }
    }

    public static class GavArtifactSource
    implements Source<Artifact> {
        private final String gav;

        private GavArtifactSource(String gav) {
            this.gav = gav;
        }

        @Override
        public Stream<Artifact> get() throws IOException {
            return Stream.of(new DefaultArtifact(this.gav));
        }
    }

    public static class ConcatArtifactSource
    implements Source<Artifact> {
        private final Collection<Source<Artifact>> sources;

        private ConcatArtifactSource(Collection<Source<Artifact>> sources) {
            this.sources = sources;
        }

        @Override
        public Stream<Artifact> get() throws IOException {
            Stream<Artifact> result = null;
            for (Source<Artifact> source : this.sources) {
                if (result == null) {
                    result = source.get();
                    continue;
                }
                result = Stream.concat(result, source.get());
            }
            return result;
        }

        @Override
        public void close() throws Exception {
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            this.sources.forEach(s -> {
                try {
                    s.close();
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            });
            if (!exceptions.isEmpty()) {
                Exception e = new Exception("Could not close concat() sources: " + String.valueOf(exceptions));
                exceptions.forEach(e::addSuppressed);
                throw e;
            }
        }
    }

    public static abstract class DelegatingArtifactSource
    implements Artifacts.Source {
        private final Source<Artifact> delegate;

        public DelegatingArtifactSource(Source<Artifact> delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
        }

        @Override
        public Stream<Artifact> get() throws IOException {
            return this.delegate.get();
        }

        @Override
        public void close() throws Exception {
            this.delegate.close();
        }
    }
}

