/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

public final class IndexFileWriter
implements AutoCloseable {
    private final Path indexFile;
    private final Path file;
    private final AtomicBoolean failed;
    private final AtomicBoolean closed;
    private final PrintWriter printWriter;

    public IndexFileWriter(Path indexFile, boolean append) throws IOException {
        OpenOption[] openOptionArray;
        this.indexFile = Objects.requireNonNull(indexFile, "indexFile").toAbsolutePath();
        this.file = indexFile.getParent().resolve(".index-" + ThreadLocalRandom.current().nextInt());
        if (Files.isRegularFile(this.indexFile, new LinkOption[0]) && append) {
            Files.copy(this.indexFile, this.file, new CopyOption[0]);
        }
        this.failed = new AtomicBoolean(false);
        this.closed = new AtomicBoolean(false);
        if (append) {
            OpenOption[] openOptionArray2 = new StandardOpenOption[3];
            openOptionArray2[0] = StandardOpenOption.CREATE;
            openOptionArray2[1] = StandardOpenOption.WRITE;
            openOptionArray = openOptionArray2;
            openOptionArray2[2] = StandardOpenOption.APPEND;
        } else {
            StandardOpenOption[] standardOpenOptionArray = new StandardOpenOption[3];
            standardOpenOptionArray[0] = StandardOpenOption.CREATE;
            standardOpenOptionArray[1] = StandardOpenOption.WRITE;
            openOptionArray = standardOpenOptionArray;
            standardOpenOptionArray[2] = StandardOpenOption.TRUNCATE_EXISTING;
        }
        this.printWriter = new PrintWriter(Files.newBufferedWriter(this.file, openOptionArray));
    }

    public void write(Artifact artifact, String path) {
        Objects.requireNonNull(artifact, "artifact");
        Objects.requireNonNull(path, "path");
        if (this.closed.get()) {
            throw new IllegalStateException("already closed");
        }
        if (!this.failed.get()) {
            this.printWriter.println(ArtifactIdUtils.toId((Artifact)artifact) + " >> " + path);
        }
    }

    public void fail() {
        this.failed.set(true);
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.printWriter.flush();
            this.printWriter.close();
            if (this.failed.get()) {
                Files.deleteIfExists(this.file);
            } else {
                Files.move(this.file, this.indexFile, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }
}

