/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.toolbox.shared.internal.Artifacts;
import eu.maveniverse.maven.toolbox.shared.internal.IndexFileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.aether.artifact.Artifact;

public final class DirectorySource
implements Artifacts.Source {
    private final Path directory;
    private final IndexFileReader indexFileReader;

    public static DirectorySource directory(Path path) throws IOException {
        return new DirectorySource(path);
    }

    private DirectorySource(Path directory) {
        this.directory = Objects.requireNonNull(directory, "directory").toAbsolutePath();
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("directory must exists");
        }
        this.indexFileReader = new IndexFileReader(directory.resolve(".index"));
    }

    public Path getDirectory() {
        return this.directory;
    }

    @Override
    public Stream<Artifact> get() throws IOException {
        return this.indexFileReader.read(this.directory::resolve);
    }
}

