/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared;

import java.util.Objects;
import java.util.Optional;

public final class Result<T> {
    private final boolean success;
    private final String message;
    private final T data;

    public static <T> Result<T> failure(String message) {
        Objects.requireNonNull(message, "message");
        return new Result<Object>(false, message, null);
    }

    public static <T> Result<T> success(T data) {
        Objects.requireNonNull(data, "data");
        return new Result<T>(true, "Success", data);
    }

    private Result(boolean success, String message, T data) {
        this.success = success;
        this.message = message;
        this.data = data;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public Optional<T> getData() {
        return Optional.ofNullable(this.data);
    }
}

