/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;

public final class ResolutionRoot {
    private final Artifact artifact;
    private final boolean load;
    private final boolean prepared;
    private final List<Dependency> dependencies;
    private final List<Dependency> managedDependencies;

    private ResolutionRoot(Artifact artifact, boolean load, boolean prepared, List<Dependency> dependencies, List<Dependency> managedDependencies) {
        this.artifact = artifact;
        this.load = load;
        this.prepared = prepared;
        this.dependencies = dependencies.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(dependencies);
        this.managedDependencies = managedDependencies.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(managedDependencies);
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public boolean isLoad() {
        return this.load;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public ResolutionRoot prepared() {
        return new ResolutionRoot(this.artifact, this.load, true, this.dependencies, this.managedDependencies);
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public List<Dependency> getManagedDependencies() {
        return this.managedDependencies;
    }

    public Builder builder() {
        return new Builder(this.artifact, this.load, this.dependencies, this.managedDependencies);
    }

    public static Builder ofLoaded(Artifact artifact) {
        return new Builder(artifact).load();
    }

    public static Builder ofNotLoaded(Artifact artifact) {
        return new Builder(artifact).doNotLoad();
    }

    public static final class Builder {
        private final Artifact artifact;
        private boolean load;
        private List<Dependency> dependencies;
        private List<Dependency> managedDependencies;

        private Builder(Artifact artifact) {
            this(artifact, false, Collections.emptyList(), Collections.emptyList());
        }

        private Builder(Artifact artifact, boolean load, List<Dependency> dependencies, List<Dependency> managedDependencies) {
            this.artifact = Objects.requireNonNull(artifact, "artifact");
            this.load = load;
            this.dependencies = Objects.requireNonNull(dependencies, "dependencies");
            this.managedDependencies = Objects.requireNonNull(managedDependencies, "managedDependencies");
        }

        public Builder load() {
            this.load = true;
            return this;
        }

        public Builder doNotLoad() {
            this.load = false;
            return this;
        }

        public Builder withDependencies(List<Dependency> dependencies) {
            this.dependencies = new ArrayList<Dependency>(dependencies);
            return this;
        }

        public Builder withManagedDependencies(List<Dependency> managedDependencies) {
            this.managedDependencies = new ArrayList<Dependency>(managedDependencies);
            return this;
        }

        public ResolutionRoot build() {
            return new ResolutionRoot(this.artifact, this.load, false, this.dependencies, this.managedDependencies);
        }
    }
}

