/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared;

import eu.maveniverse.maven.toolbox.shared.internal.SpecParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public interface ArtifactMapper
extends Function<Artifact, Artifact> {
    public static ArtifactMapper compose(ArtifactMapper ... mappers) {
        return ArtifactMapper.compose(Arrays.asList(mappers));
    }

    public static ArtifactMapper compose(final Collection<ArtifactMapper> mappers) {
        return new ArtifactMapper(){

            @Override
            public Artifact apply(Artifact artifact) {
                for (ArtifactMapper mapper : mappers) {
                    artifact = (Artifact)mapper.apply(artifact);
                }
                return artifact;
            }
        };
    }

    public static ArtifactMapper identity() {
        return new ArtifactMapper(){

            @Override
            public Artifact apply(Artifact artifact) {
                return artifact;
            }
        };
    }

    public static ArtifactMapper versionSuffix(final String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            throw new IllegalArgumentException("suffix must not be null or empty");
        }
        return new ArtifactMapper(){

            @Override
            public Artifact apply(Artifact artifact) {
                return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), artifact.getVersion() + suffix, artifact.getProperties(), artifact.getFile());
            }
        };
    }

    public static ArtifactMapper baseVersion() {
        return new ArtifactMapper(){

            @Override
            public Artifact apply(Artifact artifact) {
                return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), artifact.getBaseVersion(), artifact.getProperties(), artifact.getFile());
            }
        };
    }

    public static ArtifactMapper baseVersionSuffix(final String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            throw new IllegalArgumentException("suffix must not be null or empty");
        }
        return new ArtifactMapper(){

            @Override
            public Artifact apply(Artifact artifact) {
                return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), artifact.getBaseVersion() + suffix, artifact.getProperties(), artifact.getFile());
            }
        };
    }

    public static ArtifactMapper omitClassifier() {
        return new ArtifactMapper(){

            @Override
            public Artifact apply(Artifact artifact) {
                return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), null, artifact.getExtension(), artifact.getVersion(), artifact.getProperties(), artifact.getFile());
            }
        };
    }

    public static ArtifactMapper rename(final Function<String, String> gf, final Function<String, String> af, final Function<String, String> vf) {
        Objects.requireNonNull(gf, "gf");
        Objects.requireNonNull(af, "af");
        Objects.requireNonNull(vf, "vf");
        return new ArtifactMapper(){

            @Override
            public Artifact apply(Artifact artifact) {
                return new DefaultArtifact((String)gf.apply(artifact.getGroupId()), (String)af.apply(artifact.getArtifactId()), artifact.getClassifier(), artifact.getExtension(), (String)vf.apply(artifact.getVersion()), artifact.getProperties(), artifact.getFile());
            }
        };
    }

    public static ArtifactMapper build(Map<String, ?> properties, String spec) {
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(spec, "spec");
        ArtifactMapperBuilder builder = new ArtifactMapperBuilder(properties);
        SpecParser.parse(spec).accept(builder);
        return builder.build();
    }

    private static Function<String, String> mf(String target) {
        Objects.requireNonNull(target, "target");
        if ("*".equals(target)) {
            return Function.identity();
        }
        return s -> target;
    }

    public static class ArtifactMapperBuilder
    extends SpecParser.Builder {
        public ArtifactMapperBuilder(Map<String, ?> properties) {
            super(properties);
        }

        @Override
        protected void processOp(SpecParser.Node node) {
            switch (node.getValue()) {
                case "identity": {
                    this.params.add(ArtifactMapper.identity());
                    break;
                }
                case "baseVersion": {
                    this.params.add(ArtifactMapper.baseVersion());
                    break;
                }
                case "versionSuffix": {
                    String p0 = this.stringParam(node.getValue());
                    this.params.add(ArtifactMapper.versionSuffix(p0));
                    break;
                }
                case "baseVersionSuffix": {
                    String p0 = this.stringParam(node.getValue());
                    this.params.add(ArtifactMapper.baseVersionSuffix(p0));
                    break;
                }
                case "omitClassifier": {
                    this.params.add(ArtifactMapper.omitClassifier());
                    break;
                }
                case "rename": {
                    Function<String, String> p2 = ArtifactMapper.mf(this.stringParam(node.getValue()));
                    Function<String, String> p1 = ArtifactMapper.mf(this.stringParam(node.getValue()));
                    Function<String, String> p0 = ArtifactMapper.mf(this.stringParam(node.getValue()));
                    this.params.add(ArtifactMapper.rename(p0, p1, p2));
                    break;
                }
                case "compose": {
                    this.params.add(ArtifactMapper.compose(this.typedParams(ArtifactMapper.class, node.getValue())));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown op " + node.getValue());
                }
            }
        }

        public ArtifactMapper build() {
            return this.build(ArtifactMapper.class);
        }
    }
}

