/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.mp;

import eu.maveniverse.maven.toolbox.plugin.MPPluginMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ArtifactMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionSelector;
import eu.maveniverse.maven.toolbox.shared.ResolutionRoot;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import picocli.CommandLine;

@Mojo(name="lock-plugin-versions", aggregator=true, threadSafe=true)
public class LockPluginVersionsMojo
extends MPPluginMojoSupport {
    @Parameter(property="artifactMatcherSpec", defaultValue="any()")
    private String artifactMatcherSpec;
    @Parameter(property="artifactVersionMatcherSpec", defaultValue="noSnapshotsAndPreviews()")
    private String artifactVersionMatcherSpec;
    @CommandLine.Option(names={"--artifactVersionSelectorSpec"}, defaultValue="last()", description={"Artifact version selector spec (default 'last()')"})
    @Parameter(property="artifactVersionSelectorSpec", defaultValue="last()")
    private String artifactVersionSelectorSpec;
    @Parameter(property="applyToPom")
    private boolean applyToPom;

    protected Result<Boolean> doExecute() throws Exception {
        List pluginsUpdates;
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        ArtifactMatcher artifactMatcher = toolboxCommando.parseArtifactMatcherSpec(this.artifactMatcherSpec);
        ArtifactVersionMatcher artifactVersionMatcher = toolboxCommando.parseArtifactVersionMatcherSpec(this.artifactVersionMatcherSpec);
        ArtifactVersionSelector artifactVersionSelector = toolboxCommando.parseArtifactVersionSelectorSpec(this.artifactVersionSelectorSpec);
        HashMap allPlugins = new HashMap();
        for (MavenProject project : this.mavenSession.getProjects()) {
            Result managedPlugins = toolboxCommando.versions("managed plugins", () -> this.allManagedPluginsAsResolutionRoots(toolboxCommando, project).stream().map(ResolutionRoot::getArtifact).filter((Predicate<Artifact>)artifactMatcher), (Predicate)artifactVersionMatcher, (BiFunction)artifactVersionSelector);
            if (!managedPlugins.isSuccess()) {
                return Result.failure((String)managedPlugins.getMessage());
            }
            allPlugins.putAll((Map)managedPlugins.getData().orElseThrow());
            Result plugins = toolboxCommando.versions("plugins", () -> this.allPluginsAsResolutionRoots(toolboxCommando, project).stream().map(ResolutionRoot::getArtifact).filter((Predicate<Artifact>)artifactMatcher), (Predicate)artifactVersionMatcher, (BiFunction)artifactVersionSelector);
            if (plugins.isSuccess()) {
                allPlugins.putAll((Map)plugins.getData().orElseThrow());
                continue;
            }
            return Result.failure((String)plugins.getMessage());
        }
        if (this.applyToPom && !(pluginsUpdates = toolboxCommando.calculateLatest(allPlugins, (BiFunction)artifactVersionSelector)).isEmpty()) {
            try (ToolboxCommando.EditSession editSession = toolboxCommando.createEditSession(this.mavenProject.getFile().toPath());){
                toolboxCommando.doEdit(editSession, ToolboxCommando.OpSubject.MANAGED_PLUGINS, ToolboxCommando.Op.UPSERT, pluginsUpdates::stream);
            }
        }
        return Result.success((Object)true);
    }
}

