/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.gav;

import eu.maveniverse.maven.toolbox.plugin.GavMojoSupport;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import java.nio.file.Path;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import picocli.CommandLine;

@CommandLine.Command(name="metadata-path", description={"Prints expected relative path for a given Maven Metadata in a local repository"})
@Mojo(name="gav-metadata-path", requiresProject=false, threadSafe=true)
public class GavMetadataPathMojo
extends GavMojoSupport {
    @CommandLine.Parameters(index="0", description={"The Metadata coordinates"}, arity="1")
    @Parameter(property="gav", required=true)
    private String gav;
    @CommandLine.Option(names={"--repository"}, description={"The optional remote repository spec string. It is expected to be in form of {@code id::url}, but we are really interested in repository ID only."})
    @Parameter(property="repository")
    private String repository;

    protected Result<Path> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        RemoteRepository rr = null;
        if (this.repository != null) {
            rr = toolboxCommando.parseRemoteRepository(this.repository);
        }
        String groupId = null;
        String artifactId = null;
        String version = null;
        String type = "maven-metadata.xml";
        String[] elems = this.gav.split(":", 0);
        if (elems.length > 0) {
            groupId = elems[0];
        }
        if (elems.length > 1) {
            artifactId = elems[1];
        }
        if (elems.length > 2) {
            version = elems[2];
        }
        if (elems.length > 3) {
            type = elems[3];
        }
        if (elems.length > 4) {
            throw new IllegalArgumentException("Invalid gav: " + this.gav);
        }
        return toolboxCommando.metadataPath((Metadata)new DefaultMetadata(groupId, artifactId, version, type, Metadata.Nature.RELEASE_OR_SNAPSHOT), rr);
    }
}

