/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.gav;

import eu.maveniverse.maven.toolbox.plugin.GavMojoSupport;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import java.nio.file.Path;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import picocli.CommandLine;

@CommandLine.Command(name="artifact-path", description={"Prints expected relative path for a given Maven Artifact in a local repository"})
@Mojo(name="gav-artifact-path", requiresProject=false, threadSafe=true)
public class GavArtifactPathMojo
extends GavMojoSupport {
    @CommandLine.Parameters(index="0", description={"The Artifact coordinates"}, arity="1")
    @Parameter(property="gav", required=true)
    private String gav;
    @CommandLine.Option(names={"--repository"}, description={"The optional remote repository spec string. It is expected to be in form of {@code id::url}, but we are really interested in repository ID only."})
    @Parameter(property="repository")
    private String repository;

    protected Result<Path> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        RemoteRepository rr = null;
        if (this.repository != null) {
            rr = toolboxCommando.parseRemoteRepository(this.repository);
        }
        return toolboxCommando.artifactPath((Artifact)new DefaultArtifact(this.gav), rr);
    }
}

