/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin;

import eu.maveniverse.maven.toolbox.plugin.MojoSupport;
import eu.maveniverse.maven.toolbox.shared.ProjectArtifacts;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public abstract class GavMojoSupport
extends MojoSupport {
    protected Collection<String> csv(String csv) {
        if (csv == null || csv.trim().isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(csv.split(","));
    }

    protected Collection<String> slurp(String csv) throws IOException {
        if (csv == null || csv.trim().isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Path target = Path.of(csv, new String[0]).toAbsolutePath();
            if (Files.isRegularFile(target, new LinkOption[0]) && Files.size(target) < 5000000L) {
                return Files.readAllLines(target);
            }
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
        return this.csv(csv);
    }

    protected ProjectArtifacts projectArtifacts(String gav, File jar, File pom, File sources, File javadoc) {
        ProjectArtifacts.Builder builder = new ProjectArtifacts.Builder(gav);
        builder.addMain(jar.toPath());
        if (pom != null) {
            builder.addPom(pom.toPath());
        }
        if (sources != null) {
            builder.addSources(sources.toPath());
        }
        if (javadoc != null) {
            builder.addJavadoc(javadoc.toPath());
        }
        return builder.build();
    }
}

