/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.gav;

import eu.maveniverse.maven.toolbox.plugin.GavMojoSupport;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.version.Version;
import picocli.CommandLine;

@CommandLine.Command(name="versions", description={"Lists available versions for artifacts."})
@Mojo(name="gav-versions", requiresProject=false, threadSafe=true)
public class GavVersionsMojo
extends GavMojoSupport {
    @CommandLine.Parameters(index="0", description={"The comma separated GAVs"}, arity="1")
    @Parameter(property="gav", required=true)
    private String gav;
    @CommandLine.Option(names={"--artifactVersionMatcherSpec"}, defaultValue="noSnapshotsAndPreviews()", description={"Artifact version matcher spec (default 'noSnapshotsAndPreviews()')"})
    @Parameter(property="artifactVersionMatcherSpec", defaultValue="noSnapshotsAndPreviews()")
    private String artifactVersionMatcherSpec;

    protected Result<Map<Artifact, List<Version>>> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        return toolboxCommando.versions("GAV", () -> this.slurp(this.gav).stream().map(DefaultArtifact::new), (Predicate)toolboxCommando.parseArtifactVersionMatcherSpec(this.artifactVersionMatcherSpec));
    }
}

